/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Ord;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.data.Array;
import fj.data.List;
import fj.data.Natural;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Semigroup<A> {
    private final F<A, F<A, A>> sum;
    public static final Semigroup<Integer> intAdditionSemigroup = Semigroup.semigroup(new F2<Integer, Integer, Integer>(){

        @Override
        public Integer f(Integer i1, Integer i2) {
            return i1 + i2;
        }
    });
    public static final Semigroup<Double> doubleAdditionSemigroup = Semigroup.semigroup(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double d1, Double d2) {
            return d1 + d2;
        }
    });
    public static final Semigroup<Integer> intMultiplicationSemigroup = Semigroup.semigroup(new F2<Integer, Integer, Integer>(){

        @Override
        public Integer f(Integer i1, Integer i2) {
            return i1 * i2;
        }
    });
    public static final Semigroup<Double> doubleMultiplicationSemigroup = Semigroup.semigroup(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double d1, Double d2) {
            return d1 * d2;
        }
    });
    public static final Semigroup<Integer> intMaximumSemigroup = Semigroup.semigroup(Ord.intOrd.max);
    public static final Semigroup<Integer> intMinimumSemigroup = Semigroup.semigroup(Ord.intOrd.min);
    public static final Semigroup<BigInteger> bigintAdditionSemigroup = Semigroup.semigroup(new F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger f(BigInteger i1, BigInteger i2) {
            return i1.add(i2);
        }
    });
    public static final Semigroup<BigInteger> bigintMultiplicationSemigroup = Semigroup.semigroup(new F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger f(BigInteger i1, BigInteger i2) {
            return i1.multiply(i2);
        }
    });
    public static final Semigroup<BigInteger> bigintMaximumSemigroup = Semigroup.semigroup(Ord.bigintOrd.max);
    public static final Semigroup<BigInteger> bigintMinimumSemigroup = Semigroup.semigroup(Ord.bigintOrd.min);
    public static final Semigroup<BigDecimal> bigdecimalAdditionSemigroup = Semigroup.semigroup(new F2<BigDecimal, BigDecimal, BigDecimal>(){

        @Override
        public BigDecimal f(BigDecimal i1, BigDecimal i2) {
            return i1.add(i2);
        }
    });
    public static final Semigroup<BigDecimal> bigdecimalMultiplicationSemigroup = Semigroup.semigroup(new F2<BigDecimal, BigDecimal, BigDecimal>(){

        @Override
        public BigDecimal f(BigDecimal i1, BigDecimal i2) {
            return i1.multiply(i2);
        }
    });
    public static final Semigroup<BigDecimal> bigDecimalMaximumSemigroup = Semigroup.semigroup(Ord.bigdecimalOrd.max);
    public static final Semigroup<BigDecimal> bigDecimalMinimumSemigroup = Semigroup.semigroup(Ord.bigdecimalOrd.min);
    public static final Semigroup<Natural> naturalMultiplicationSemigroup = Semigroup.semigroup(new F2<Natural, Natural, Natural>(){

        @Override
        public Natural f(Natural n1, Natural n2) {
            return n1.multiply(n2);
        }
    });
    public static final Semigroup<Natural> naturalAdditionSemigroup = Semigroup.semigroup(new F2<Natural, Natural, Natural>(){

        @Override
        public Natural f(Natural n1, Natural n2) {
            return n1.add(n2);
        }
    });
    public static final Semigroup<Natural> naturalMaximumSemigroup = Semigroup.semigroup(Ord.naturalOrd.max);
    public static final Semigroup<Natural> naturalMinimumSemigroup = Semigroup.semigroup(Ord.naturalOrd.min);
    public static final Semigroup<Long> longAdditionSemigroup = Semigroup.semigroup(new F2<Long, Long, Long>(){

        @Override
        public Long f(Long x, Long y) {
            return x + y;
        }
    });
    public static final Semigroup<Long> longMultiplicationSemigroup = Semigroup.semigroup(new F2<Long, Long, Long>(){

        @Override
        public Long f(Long x, Long y) {
            return x * y;
        }
    });
    public static final Semigroup<Long> longMaximumSemigroup = Semigroup.semigroup(Ord.longOrd.max);
    public static final Semigroup<Long> longMinimumSemigroup = Semigroup.semigroup(Ord.longOrd.min);
    public static final Semigroup<Boolean> disjunctionSemigroup = Semigroup.semigroup(new F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean f(Boolean b1, Boolean b2) {
            return b1 != false || b2 != false;
        }
    });
    public static final Semigroup<Boolean> exclusiveDisjunctionSemiGroup = Semigroup.semigroup(new F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean f(Boolean p, Boolean q) {
            return p != false && q == false || p == false && q != false;
        }
    });
    public static final Semigroup<Boolean> conjunctionSemigroup = Semigroup.semigroup(new F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean f(Boolean b1, Boolean b2) {
            return b1 != false && b2 != false;
        }
    });
    public static final Semigroup<String> stringSemigroup = Semigroup.semigroup(new F2<String, String, String>(){

        @Override
        public String f(String s1, String s2) {
            return s1 + s2;
        }
    });
    public static final Semigroup<StringBuffer> stringBufferSemigroup = Semigroup.semigroup(new F2<StringBuffer, StringBuffer, StringBuffer>(){

        @Override
        public StringBuffer f(StringBuffer s1, StringBuffer s2) {
            return new StringBuffer(s1).append(s2);
        }
    });
    public static final Semigroup<StringBuilder> stringBuilderSemigroup = Semigroup.semigroup(new F2<StringBuilder, StringBuilder, StringBuilder>(){

        @Override
        public StringBuilder f(StringBuilder s1, StringBuilder s2) {
            return new StringBuilder(s1).append((CharSequence)s2);
        }
    });
    public static final Semigroup<Unit> unitSemigroup = Semigroup.semigroup(new F2<Unit, Unit, Unit>(){

        @Override
        public Unit f(Unit u1, Unit u2) {
            return Unit.unit();
        }
    });

    private Semigroup(F<A, F<A, A>> sum) {
        this.sum = sum;
    }

    public A sum(A a1, A a2) {
        return this.sum.f(a1).f(a2);
    }

    public F<A, A> sum(A a1) {
        return this.sum.f(a1);
    }

    public F<A, F<A, A>> sum() {
        return this.sum;
    }

    public static <A> Semigroup<A> semigroup(F<A, F<A, A>> sum) {
        return new Semigroup<A>(sum);
    }

    public static <A> Semigroup<A> semigroup(F2<A, A, A> sum) {
        return new Semigroup<A>(Function.curry(sum));
    }

    public static <A, B> Semigroup<F<A, B>> functionSemigroup(final Semigroup<B> sb) {
        return Semigroup.semigroup(new F2<F<A, B>, F<A, B>, F<A, B>>(){

            @Override
            public F<A, B> f(final F<A, B> a1, final F<A, B> a2) {
                return new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return sb.sum(a1.f(a), a2.f(a));
                    }
                };
            }
        });
    }

    public static <A> Semigroup<List<A>> listSemigroup() {
        return Semigroup.semigroup(new F2<List<A>, List<A>, List<A>>(){

            @Override
            public List<A> f(List<A> a1, List<A> a2) {
                return a1.append(a2);
            }
        });
    }

    public static <A> Semigroup<NonEmptyList<A>> nonEmptyListSemigroup() {
        return Semigroup.semigroup(new F2<NonEmptyList<A>, NonEmptyList<A>, NonEmptyList<A>>(){

            @Override
            public NonEmptyList<A> f(NonEmptyList<A> a1, NonEmptyList<A> a2) {
                return a1.append(a2);
            }
        });
    }

    public static <A> Semigroup<Option<A>> optionSemigroup() {
        return Semigroup.semigroup(new F2<Option<A>, Option<A>, Option<A>>(){

            @Override
            public Option<A> f(Option<A> a1, Option<A> a2) {
                return a1.isSome() ? a1 : a2;
            }
        });
    }

    public static <A> Semigroup<Option<A>> firstOptionSemigroup() {
        return Semigroup.semigroup(new F2<Option<A>, Option<A>, Option<A>>(){

            @Override
            public Option<A> f(Option<A> a1, Option<A> a2) {
                return a1.orElse(a2);
            }
        });
    }

    public static <A> Semigroup<Option<A>> lastOptionSemigroup() {
        return Semigroup.semigroup(new F2<Option<A>, Option<A>, Option<A>>(){

            @Override
            public Option<A> f(Option<A> a1, Option<A> a2) {
                return a2.orElse(a1);
            }
        });
    }

    public static <A> Semigroup<Stream<A>> streamSemigroup() {
        return Semigroup.semigroup(new F2<Stream<A>, Stream<A>, Stream<A>>(){

            @Override
            public Stream<A> f(Stream<A> a1, Stream<A> a2) {
                return a1.append(a2);
            }
        });
    }

    public static <A> Semigroup<Array<A>> arraySemigroup() {
        return Semigroup.semigroup(new F2<Array<A>, Array<A>, Array<A>>(){

            @Override
            public Array<A> f(Array<A> a1, Array<A> a2) {
                return a1.append(a2);
            }
        });
    }

    public static <A> Semigroup<P1<A>> p1Semigroup(final Semigroup<A> sa) {
        return Semigroup.semigroup(new F2<P1<A>, P1<A>, P1<A>>(){

            @Override
            public P1<A> f(final P1<A> a1, final P1<A> a2) {
                return new P1<A>(){

                    @Override
                    public A _1() {
                        return sa.sum(a1._1(), a2._1());
                    }
                };
            }
        });
    }

    public static <A, B> Semigroup<P2<A, B>> p2Semigroup(final Semigroup<A> sa, final Semigroup<B> sb) {
        return Semigroup.semigroup(new F2<P2<A, B>, P2<A, B>, P2<A, B>>(){

            @Override
            public P2<A, B> f(final P2<A, B> a1, final P2<A, B> a2) {
                return new P2<A, B>(){

                    @Override
                    public A _1() {
                        return sa.sum(a1._1(), a2._1());
                    }

                    @Override
                    public B _2() {
                        return sb.sum(a1._2(), a2._2());
                    }
                };
            }
        });
    }

    public static <A> Semigroup<Set<A>> setSemigroup() {
        return Semigroup.semigroup(new F2<Set<A>, Set<A>, Set<A>>(){

            @Override
            public Set<A> f(Set<A> a, Set<A> b) {
                return a.union(b);
            }
        });
    }
}

