/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.F;
import fj.Function;
import fj.P;
import fj.P1;
import fj.Show;
import fj.Unit;
import fj.data.Array;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Effect1;
import java.util.Collection;
import java.util.Iterator;

public abstract class Either<A, B> {
    private Either() {
    }

    public final LeftProjection<A, B> left() {
        return new LeftProjection(this);
    }

    public final RightProjection<A, B> right() {
        return new RightProjection(this);
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public final <X> X either(F<A, X> left, F<B, X> right) {
        return this.isLeft() ? left.f(this.left().value()) : right.f(this.right().value());
    }

    public final Either<B, A> swap() {
        return this.isLeft() ? new Right(((Left)this).a) : new Left(((Right)this).b);
    }

    public static <A, B> Either<A, B> left(A a) {
        return new Left(a);
    }

    public static <A, B> F<A, Either<A, B>> left_() {
        return new F<A, Either<A, B>>(){

            @Override
            public Either<A, B> f(A a) {
                return Either.left(a);
            }
        };
    }

    public static <A, B> F<B, Either<A, B>> right_() {
        return new F<B, Either<A, B>>(){

            @Override
            public Either<A, B> f(B b) {
                return Either.right(b);
            }
        };
    }

    public static <A, B> Either<A, B> right(B b) {
        return new Right(b);
    }

    public static <A, B, X> F<F<A, X>, F<Either<A, B>, Either<X, B>>> leftMap_() {
        return new F<F<A, X>, F<Either<A, B>, Either<X, B>>>(){

            @Override
            public F<Either<A, B>, Either<X, B>> f(final F<A, X> axf) {
                return new F<Either<A, B>, Either<X, B>>(){

                    @Override
                    public Either<X, B> f(Either<A, B> e) {
                        return e.left().map(axf);
                    }
                };
            }
        };
    }

    public static <A, B, X> F<F<B, X>, F<Either<A, B>, Either<A, X>>> rightMap_() {
        return new F<F<B, X>, F<Either<A, B>, Either<A, X>>>(){

            @Override
            public F<Either<A, B>, Either<A, X>> f(final F<B, X> axf) {
                return new F<Either<A, B>, Either<A, X>>(){

                    @Override
                    public Either<A, X> f(Either<A, B> e) {
                        return e.right().map(axf);
                    }
                };
            }
        };
    }

    public static <A, B> Either<A, B> joinLeft(Either<Either<A, B>, B> e) {
        F id = Function.identity();
        return e.left().bind(id);
    }

    public static <A, B> Either<A, B> joinRight(Either<A, Either<A, B>> e) {
        F id = Function.identity();
        return e.right().bind(id);
    }

    public static <A, X> Either<List<A>, X> sequenceLeft(final List<Either<A, X>> a) {
        return a.isEmpty() ? Either.left(List.nil()) : a.head().left().bind(new F<A, Either<List<A>, X>>(){

            @Override
            public Either<List<A>, X> f(A aa) {
                return Either.sequenceLeft(a.tail()).left().map(List.cons_(aa));
            }
        });
    }

    public static <B, X> Either<X, List<B>> sequenceRight(final List<Either<X, B>> a) {
        return a.isEmpty() ? Either.right(List.nil()) : a.head().right().bind(new F<B, Either<X, List<B>>>(){

            @Override
            public Either<X, List<B>> f(B bb) {
                return Either.sequenceRight(a.tail()).right().map(List.cons_(bb));
            }
        });
    }

    public static <A> A reduce(Either<A, A> e) {
        return e.isLeft() ? e.left().value() : e.right().value();
    }

    public static <A, B> Either<A, B> iif(boolean c, P1<B> right, P1<A> left) {
        return c ? new Right(right._1()) : new Left(left._1());
    }

    public static <A, B> List<A> lefts(List<Either<A, B>> es) {
        return es.foldRight(new F<Either<A, B>, F<List<A>, List<A>>>(){

            @Override
            public F<List<A>, List<A>> f(final Either<A, B> e) {
                return new F<List<A>, List<A>>(){

                    @Override
                    public List<A> f(List<A> as) {
                        return e.isLeft() ? as.cons(e.left().value()) : as;
                    }
                };
            }
        }, List.nil());
    }

    public static <A, B> List<B> rights(List<Either<A, B>> es) {
        return es.foldRight(new F<Either<A, B>, F<List<B>, List<B>>>(){

            @Override
            public F<List<B>, List<B>> f(final Either<A, B> e) {
                return new F<List<B>, List<B>>(){

                    @Override
                    public List<B> f(List<B> bs) {
                        return e.isRight() ? bs.cons(e.right().value()) : bs;
                    }
                };
            }
        }, List.nil());
    }

    public String toString() {
        return Show.eitherShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    public final class RightProjection<A, B>
    implements Iterable<B> {
        private final Either<A, B> e;

        private RightProjection(Either<A, B> e) {
            this.e = e;
        }

        @Override
        public Iterator<B> iterator() {
            return this.toCollection().iterator();
        }

        public Either<A, B> either() {
            return this.e;
        }

        public B valueE(P1<String> err) {
            if (this.e.isRight()) {
                return (B)((Right)this.e).b;
            }
            throw Bottom.error(err._1());
        }

        public B value() {
            return this.valueE(P.p("right.value on Left"));
        }

        public B orValue(P1<B> b) {
            return Either.this.isRight() ? this.value() : b._1();
        }

        public B on(F<A, B> f) {
            return Either.this.isRight() ? this.value() : f.f(this.e.left().value());
        }

        public Unit foreach(F<B, Unit> f) {
            if (Either.this.isRight()) {
                f.f(this.value());
            }
            return Unit.unit();
        }

        public void foreachDoEffect(Effect1<B> f) {
            if (Either.this.isRight()) {
                f.f(this.value());
            }
        }

        public <X> Either<A, X> map(F<B, X> f) {
            return Either.this.isRight() ? new Right(f.f(this.value())) : new Left(this.e.left().value());
        }

        public <X> Either<A, X> bind(F<B, Either<A, X>> f) {
            return Either.this.isRight() ? f.f(this.value()) : new Left(this.e.left().value());
        }

        public <X> Either<A, X> sequence(Either<A, X> e) {
            return this.bind(Function.constant(e));
        }

        public <X> Option<Either<X, B>> filter(F<B, Boolean> f) {
            return Either.this.isRight() ? (f.f(this.value()).booleanValue() ? Option.some(new Right(this.value())) : Option.none()) : Option.none();
        }

        public <X> Either<A, X> apply(Either<A, F<B, X>> e) {
            return e.right().bind(new F<F<B, X>, Either<A, X>>(){

                @Override
                public Either<A, X> f(F<B, X> f) {
                    return RightProjection.this.map(f);
                }
            });
        }

        public boolean forall(F<B, Boolean> f) {
            return Either.this.isLeft() || f.f(this.value()) != false;
        }

        public boolean exists(F<B, Boolean> f) {
            return Either.this.isRight() && f.f(this.value()) != false;
        }

        public List<B> toList() {
            return Either.this.isRight() ? List.single(this.value()) : List.nil();
        }

        public Option<B> toOption() {
            return Either.this.isRight() ? Option.some(this.value()) : Option.none();
        }

        public Array<B> toArray() {
            if (Either.this.isRight()) {
                Object[] a = new Object[]{this.value()};
                return Array.mkArray(a);
            }
            return Array.empty();
        }

        public Stream<B> toStream() {
            return Either.this.isRight() ? Stream.single(this.value()) : Stream.nil();
        }

        public Collection<B> toCollection() {
            return this.toList().toCollection();
        }
    }

    public final class LeftProjection<A, B>
    implements Iterable<A> {
        private final Either<A, B> e;

        private LeftProjection(Either<A, B> e) {
            this.e = e;
        }

        @Override
        public Iterator<A> iterator() {
            return this.toCollection().iterator();
        }

        public Either<A, B> either() {
            return this.e;
        }

        public A valueE(P1<String> err) {
            if (this.e.isLeft()) {
                return (A)((Left)this.e).a;
            }
            throw Bottom.error(err._1());
        }

        public A valueE(String err) {
            return this.valueE(P.p(err));
        }

        public A value() {
            return this.valueE(P.p("left.value on Right"));
        }

        public A orValue(P1<A> a) {
            return Either.this.isLeft() ? this.value() : a._1();
        }

        public A orValue(A a) {
            return Either.this.isLeft() ? this.value() : a;
        }

        public A on(F<B, A> f) {
            return Either.this.isLeft() ? this.value() : f.f(this.e.right().value());
        }

        public Unit foreach(F<A, Unit> f) {
            if (Either.this.isLeft()) {
                f.f(this.value());
            }
            return Unit.unit();
        }

        public void foreachDoEffect(Effect1<A> f) {
            if (Either.this.isLeft()) {
                f.f(this.value());
            }
        }

        public <X> Either<X, B> map(F<A, X> f) {
            return Either.this.isLeft() ? new Left(f.f(this.value())) : new Right(this.e.right().value());
        }

        public <X> Either<X, B> bind(F<A, Either<X, B>> f) {
            return Either.this.isLeft() ? f.f(this.value()) : new Right(this.e.right().value());
        }

        public <X> Either<X, B> sequence(Either<X, B> e) {
            return this.bind(Function.constant(e));
        }

        public <X> Option<Either<A, X>> filter(F<A, Boolean> f) {
            return Either.this.isLeft() ? (f.f(this.value()).booleanValue() ? Option.some(new Left(this.value())) : Option.none()) : Option.none();
        }

        public <X> Either<X, B> apply(Either<F<A, X>, B> e) {
            return e.left().bind(new F<F<A, X>, Either<X, B>>(){

                @Override
                public Either<X, B> f(F<A, X> f) {
                    return LeftProjection.this.map(f);
                }
            });
        }

        public boolean forall(F<A, Boolean> f) {
            return Either.this.isRight() || f.f(this.value()) != false;
        }

        public boolean exists(F<A, Boolean> f) {
            return Either.this.isLeft() && f.f(this.value()) != false;
        }

        public List<A> toList() {
            return Either.this.isLeft() ? List.single(this.value()) : List.nil();
        }

        public Option<A> toOption() {
            return Either.this.isLeft() ? Option.some(this.value()) : Option.none();
        }

        public Array<A> toArray() {
            if (Either.this.isLeft()) {
                Object[] a = new Object[]{this.value()};
                return Array.mkArray(a);
            }
            return Array.mkArray(new Object[0]);
        }

        public Stream<A> toStream() {
            return Either.this.isLeft() ? Stream.single(this.value()) : Stream.nil();
        }

        public Collection<A> toCollection() {
            return this.toList().toCollection();
        }
    }

    private static final class Right<A, B>
    extends Either<A, B> {
        private final B b;

        Right(B b) {
            this.b = b;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }
    }

    private static final class Left<A, B>
    extends Either<A, B> {
        private final A a;

        Left(A a) {
            this.a = a;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }
    }
}

