/*
 * Decompiled with CFR 0.152.
 */
package versionsort;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SemanticVersion
implements Comparable<SemanticVersion> {
    private final String original;
    private final List<String> coreParts;
    private final List<String> preReleaseParts;
    private final List<String> postReleaseParts;
    private final boolean isPreRelease;

    public SemanticVersion(String version) {
        this.original = version;
        String[] split = version.split("-", 2);
        String corePart = split[0];
        String extra = split.length > 1 ? split[1] : "";
        String core = corePart.replaceAll("([a-zA-Z].*)", "");
        String post = corePart.length() > core.length() ? corePart.substring(core.length()) : "";
        this.coreParts = Arrays.asList(core.split("\\."));
        this.postReleaseParts = post.isEmpty() ? Collections.emptyList() : Arrays.asList(post.split("\\."));
        this.isPreRelease = !extra.isEmpty();
        this.preReleaseParts = this.isPreRelease ? Arrays.asList(extra.split("\\.")) : Collections.emptyList();
    }

    @Override
    public int compareTo(SemanticVersion other) {
        int cmp;
        int maxCore = Math.max(this.coreParts.size(), other.coreParts.size());
        for (int i = 0; i < maxCore; ++i) {
            int otherPart;
            int thisPart = i < this.coreParts.size() ? this.parsePart(this.coreParts.get(i)) : 0;
            int cmp2 = Integer.compare(thisPart, otherPart = i < other.coreParts.size() ? this.parsePart(other.coreParts.get(i)) : 0);
            if (cmp2 == 0) continue;
            return cmp2;
        }
        if (this.isPreRelease && !other.isPreRelease) {
            return -1;
        }
        if (!this.isPreRelease && other.isPreRelease) {
            return 1;
        }
        if (this.isPreRelease && other.isPreRelease && (cmp = this.compareParts(this.preReleaseParts, other.preReleaseParts)) != 0) {
            return cmp;
        }
        return this.compareParts(this.postReleaseParts, other.postReleaseParts);
    }

    public String toString() {
        return this.original;
    }

    private int compareParts(List<String> a, List<String> b) {
        int max = Math.max(a.size(), b.size());
        for (int i = 0; i < max; ++i) {
            int cmp;
            if (i >= a.size()) {
                return -1;
            }
            if (i >= b.size()) {
                return 1;
            }
            String pa = a.get(i);
            String pb = b.get(i);
            boolean aNum = pa.matches("\\d+");
            boolean bNum = pb.matches("\\d+");
            if (aNum && bNum) {
                cmp = Integer.compare(Integer.parseInt(pa), Integer.parseInt(pb));
                if (cmp == 0) continue;
                return cmp;
            }
            if (aNum) {
                return -1;
            }
            if (bNum) {
                return 1;
            }
            cmp = pa.compareTo(pb);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private int parsePart(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

