/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.jssrc2cpg.passes;

import io.appthreat.jssrc2cpg.Config;
import io.appthreat.jssrc2cpg.astcreation.AstCreator;
import io.appthreat.jssrc2cpg.parser.BabelJsonParser;
import io.appthreat.jssrc2cpg.parser.BabelJsonParser$;
import io.appthreat.jssrc2cpg.passes.AstCreationPass$;
import io.appthreat.jssrc2cpg.passes.Defines$;
import io.appthreat.jssrc2cpg.utils.AstGenRunner;
import io.appthreat.x2cpg.ValidationMode;
import io.appthreat.x2cpg.utils.Report;
import io.appthreat.x2cpg.utils.TimeUtils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class AstCreationPass
extends ConcurrentWriterCpgPass<Tuple2<String, String>> {
    private final AstGenRunner.AstGenRunnerResult astGenRunnerResult;
    private final Config config;
    private final Report report;
    private final ValidationMode withSchemaValidation;
    private final Logger logger;
    private final ConcurrentHashMap<Tuple2<String, String>, Object> usedTypes;

    public static Report $lessinit$greater$default$4() {
        return AstCreationPass$.MODULE$.$lessinit$greater$default$4();
    }

    public AstCreationPass(Cpg cpg, AstGenRunner.AstGenRunnerResult astGenRunnerResult, Config config, Report report, ValidationMode withSchemaValidation) {
        this.astGenRunnerResult = astGenRunnerResult;
        this.config = config;
        this.report = report;
        this.withSchemaValidation = withSchemaValidation;
        super(cpg, ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2(), ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.logger = LoggerFactory.getLogger(AstCreationPass.class);
        this.usedTypes = new ConcurrentHashMap();
    }

    public Tuple2<String, String>[] generateParts() {
        return (Tuple2[])this.astGenRunnerResult.parsedFiles().toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public List<Tuple2<String, String>> allUsedTypes() {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(this.usedTypes.keys()).asScala().filterNot((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String typeName;
                String string = typeName = (String)tuple2._1();
                String string2 = Defines$.MODULE$.Any();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            throw new MatchError((Object)tuple2);
        }).toList();
    }

    public void finish() {
        this.astGenRunnerResult.skippedFiles().foreach((Function1)(JProcedure1 & Serializable)skippedFile -> {
            Tuple2 tuple2 = skippedFile;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rootPath = (String)tuple2._1();
            String fileName = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)rootPath, (Object)fileName);
            String rootPath2 = (String)tuple22._1();
            String fileName2 = (String)tuple22._2();
            Path filePath = Paths.get(rootPath2, fileName2);
            int fileLOC = IOUtils$.MODULE$.readLinesInFile(filePath).size();
            this.report.addReportInfo(fileName2, fileLOC, this.report.addReportInfo$default$3(), this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5());
        });
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder diffGraph, Tuple2<String, String> input) {
        Tuple2 tuple2;
        Tuple2<String, String> tuple22 = input;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        String rootPath = (String)tuple22._1();
        String jsonFilename = (String)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)rootPath, (Object)jsonFilename);
        String rootPath2 = (String)tuple23._1();
        String jsonFilename2 = (String)tuple23._2();
        Tuple2 tuple24 = TimeUtils$.MODULE$.time(() -> this.$anonfun$1(rootPath2, jsonFilename2, diffGraph));
        if (tuple24 == null || (tuple2 = (Tuple2)tuple24._1()) == null) {
            throw new MatchError((Object)tuple24);
        }
        boolean gotCpg = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
        String filename = (String)tuple2._2();
        long duration = BoxesRunTime.unboxToLong((Object)tuple24._2());
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)gotCpg), (Object)filename, (Object)BoxesRunTime.boxToLong((long)duration));
        boolean gotCpg2 = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        String filename2 = (String)tuple3._2();
        long duration2 = BoxesRunTime.unboxToLong((Object)tuple3._3());
        this.report.updateReport(filename2, gotCpg2, duration2);
    }

    private final BatchedUpdate.DiffGraphBuilder $anonfun$1$$anonfun$1(BabelJsonParser.ParseResult parseResult$1, BatchedUpdate.DiffGraphBuilder diffGraph$2) {
        BatchedUpdate.DiffGraphBuilder localDiff = new AstCreator(this.config, parseResult$1, this.usedTypes, this.withSchemaValidation).createAst();
        return diffGraph$2.absorb(localDiff);
    }

    private final Tuple2 $anonfun$1(String rootPath$1, String jsonFilename$1, BatchedUpdate.DiffGraphBuilder diffGraph$1) {
        BabelJsonParser.ParseResult parseResult = BabelJsonParser$.MODULE$.readFile(Paths.get(rootPath$1, new String[0]), Paths.get(jsonFilename$1, new String[0]));
        int fileLOC = IOUtils$.MODULE$.readLinesInFile(Paths.get(parseResult.fullPath(), new String[0])).size();
        this.report.addReportInfo(parseResult.filename(), fileLOC, true, this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5());
        Try try_ = Try$.MODULE$.apply(() -> this.$anonfun$1$$anonfun$1(parseResult, diffGraph$1));
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.warn("Failed to generate a CPG for: '" + parseResult.fullPath() + "'", exception);
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)parseResult.filename());
        }
        if (try_ instanceof Success) {
            this.logger.debug("Generated a CPG for: '" + parseResult.fullPath() + "'");
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)parseResult.filename());
        }
        throw new MatchError((Object)try_);
    }
}

