/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.jssrc2cpg.passes;

import better.files.File;
import better.files.File$;
import io.appthreat.jssrc2cpg.Config;
import io.appthreat.jssrc2cpg.passes.ConfigPass$;
import io.appthreat.jssrc2cpg.passes.Defines$;
import io.appthreat.x2cpg.SourceFiles$;
import io.appthreat.x2cpg.utils.Report;
import io.appthreat.x2cpg.utils.TimeUtils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.NewConfigFile;
import io.shiftleft.codepropertygraph.generated.nodes.NewConfigFile$;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ConfigPass
extends ConcurrentWriterCpgPass<File> {
    private final Config config;
    private final Report report;
    private final Logger logger;
    private final Set<String> allExtensions;
    private final Set<String> selectedExtensions;

    public static Report $lessinit$greater$default$3() {
        return ConfigPass$.MODULE$.$lessinit$greater$default$3();
    }

    public ConfigPass(Cpg cpg, Config config, Report report) {
        this.config = config;
        this.report = report;
        super(cpg, ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2(), ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
        this.allExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json", ".js", ".vue", ".html", ".pug"}));
        this.selectedExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json", ".config.js", ".conf.js", ".vue", ".html", ".pug"}));
    }

    public Set<String> allExtensions() {
        return this.allExtensions;
    }

    public Set<String> selectedExtensions() {
        return this.selectedExtensions;
    }

    public File[] generateParts() {
        return (File[])this.configFiles(this.config, this.allExtensions()).toArray(ClassTag$.MODULE$.apply(File.class));
    }

    public Seq<String> fileContent(File file) {
        return IOUtils$.MODULE$.readLinesInFile(file.path());
    }

    public Seq<File> configFiles(Config config, Set<String> extensions) {
        String string = config.inputPath();
        Option option = SourceFiles$.MODULE$.determine$default$3();
        Option option2 = SourceFiles$.MODULE$.determine$default$4();
        Option option3 = SourceFiles$.MODULE$.determine$default$5();
        return SourceFiles$.MODULE$.determine(string, extensions, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, extensions, option, option2, option3)).filterNot((Function1 & Serializable)_$1 -> _$1.contains(Defines$.MODULE$.NodeModulesFolder())).filter((Function1 & Serializable)f -> this.selectedExtensions().exists((Function1 & Serializable)x$0 -> f.endsWith((String)x$0))).map((Function1 & Serializable)_$2 -> File$.MODULE$.apply(_$2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder diffGraph, File file) {
        String path = File$.MODULE$.apply(this.config.inputPath(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path().toAbsolutePath().relativize(file.path()).toString();
        this.logger.debug("Adding file '" + path + "' as config.");
        Tuple2 tuple2 = TimeUtils$.MODULE$.time(() -> this.$anonfun$1(file, path));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BatchedUpdate.DiffGraphBuilder gotCpg = (BatchedUpdate.DiffGraphBuilder)tuple2._1();
        long duration = BoxesRunTime.unboxToLong((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)gotCpg, (Object)BoxesRunTime.boxToLong((long)duration));
        BatchedUpdate.DiffGraphBuilder gotCpg2 = (BatchedUpdate.DiffGraphBuilder)tuple22._1();
        long duration2 = BoxesRunTime.unboxToLong((Object)tuple22._2());
        diffGraph.absorb(gotCpg2);
        this.report.updateReport(path, true, duration2);
    }

    private final BatchedUpdate.DiffGraphBuilder $anonfun$1(File file$1, String path$1) {
        BatchedUpdate.DiffGraphBuilder localDiff = new BatchedUpdate.DiffGraphBuilder();
        Seq<String> content = this.fileContent(file$1);
        int loc = content.size();
        NewConfigFile configNode = NewConfigFile$.MODULE$.apply().name(path$1).content(content.mkString("\n"));
        this.report.addReportInfo(path$1, loc, true, this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5());
        localDiff.addNode((DetachedNodeData)configNode);
        return localDiff;
    }
}

