/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.jssrc2cpg.preprocessing;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public class EjsPreprocessor {
    private final String CommentTag;
    private final Regex TagGroupsRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(<%[=\\-_#]?)([\\s\\S]*?)([-_#]?%>)"));
    private final Regex ScriptGroupsRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(<script>)([\\s\\S]*?)(</script>)"));
    private final List<String> Tags = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<%#", "<%=", "<%-", "<%_", "-%>", "_%>", "#%>", "%>"}));

    public EjsPreprocessor() {
        this.CommentTag = "<%#";
    }

    private String stripScriptTag(String code) {
        ObjectRef x = ObjectRef.create((Object)code.replaceAll("<script>", "<%      ").replaceAll("</script>", "%>       "));
        this.ScriptGroupsRegex.findAllIn((CharSequence)code).matchData().foreach((Function1)(JProcedure1 & Serializable)ma -> {
            ObjectRef scriptBlock = ObjectRef.create((Object)ma.group(2));
            List matches = this.TagGroupsRegex.findAllIn((CharSequence)((String)scriptBlock.elem)).matchData().toList();
            matches.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Regex.Match match;
                Regex.Match mat = match = x$1;
                String string = mat.group(1);
                String string2 = "<%";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    String string3 = mat.group(3);
                    String string4 = "-%>";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        scriptBlock$1.elem = ((String)scriptBlock$1.elem).replace(mat.toString(), StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), mat.toString().replaceAll("[^\\s]", " ").length()));
                        return;
                    }
                }
            });
            this.Tags.foreach((Function1)(JProcedure1 & Serializable)tag -> {
                scriptBlock$2.elem = ((String)scriptBlock$2.elem).replaceAll((String)tag, StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), tag.length()));
            });
            x$12.elem = ((String)x$12.elem).replace(ma.group(2), (String)scriptBlock.elem);
        });
        return (String)x.elem;
    }

    private boolean needsSemicolon(String code) {
        return !code.trim().endsWith("{") && !code.trim().endsWith("}") && !code.trim().endsWith(";");
    }

    public String preprocess(String code) {
        String codeWithoutScriptTag = this.stripScriptTag(code);
        char[] codeAsCharArray = codeWithoutScriptTag.toCharArray();
        StringBuilder preprocessedCode = new StringBuilder(codeAsCharArray.length);
        List matches = this.TagGroupsRegex.findAllIn((CharSequence)codeWithoutScriptTag).matchData().toList();
        List positions = matches.flatMap((Function1 & Serializable)x$1 -> {
            Regex.Match match;
            Regex.Match ma = match = x$1;
            String string = ma.group(1);
            String string2 = this.CommentTag;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return None$.MODULE$;
            }
            Regex.Match ma2 = match;
            if (ma2.group(2).trim().startsWith("include ")) {
                return None$.MODULE$;
            }
            Regex.Match ma3 = match;
            int start = ma3.start() + ma3.group(1).length();
            int end = ma3.end() - ma3.group(3).length();
            return Option$.MODULE$.apply((Object)new Tuple2.mcII.sp(start, end));
        });
        Object object = Predef$.MODULE$.charArrayOps(codeAsCharArray);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                char c = tuple2._1$mcC$sp();
                char currChar = c;
                if (currChar == '\n' || currChar == '\r') {
                    return preprocessedCode.append(currChar);
                }
                char currChar2 = c;
                int index = tuple2._2$mcI$sp();
                if (positions.exists((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        int start = tuple2._1$mcI$sp();
                        int end = tuple2._2$mcI$sp();
                        return index >= start && index < end;
                    }
                    throw new MatchError((Object)tuple2);
                })) {
                    return preprocessedCode.append(currChar2);
                }
            }
            return preprocessedCode.append(" ");
        });
        ObjectRef codeWithoutSemicolon = ObjectRef.create((Object)preprocessedCode.toString());
        ArrayBuffer alreadyReplaced = ArrayBuffer$.MODULE$.empty();
        matches.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Regex.Match match;
            Regex.Match ma = match = x$1;
            String string = ma.group(1);
            String string2 = this.CommentTag;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return;
            }
            Regex.Match ma2 = match;
            if (ma2.group(2).trim().startsWith("include ")) {
                return;
            }
            Regex.Match ma3 = match;
            if (this.needsSemicolon(ma3.group(2))) {
                int end;
                int start = ma3.start() + ma3.group(1).length();
                if (!alreadyReplaced.contains((Object)new Tuple2.mcII.sp(start, end = ma3.end() - ma3.group(3).length()))) {
                    String replacementCode = ma3.group(2) + ";";
                    codeWithoutSemicolon$1.elem = ((String)codeWithoutSemicolon$1.elem).substring(0, start) + replacementCode + ((String)codeWithoutSemicolon$1.elem).substring(end + 1, ((String)codeWithoutSemicolon$1.elem).length());
                    alreadyReplaced.append((Object)new Tuple2.mcII.sp(start, end));
                    return;
                }
                return;
            }
        });
        return (String)codeWithoutSemicolon.elem;
    }
}

