/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.jssrc2cpg.utils;

import better.files.File;
import better.files.File$;
import io.appthreat.jssrc2cpg.Config;
import io.appthreat.jssrc2cpg.preprocessing.EjsPreprocessor;
import io.appthreat.jssrc2cpg.utils.AstGenRunner$;
import io.appthreat.jssrc2cpg.utils.AstGenRunner$AstGenRunnerResult$;
import io.appthreat.x2cpg.SourceFiles$;
import io.appthreat.x2cpg.utils.ExternalCommand$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.Value$;

public class AstGenRunner {
    private final Config config;
    private final String executableArgs;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AstGenRunner$.class.getDeclaredField("astGenCommand$lzy1"));

    public AstGenRunner(Config config) {
        this.config = config;
        this.executableArgs = !config.tsTypes() ? " --no-tsTypes" : "";
    }

    private List<String> skippedFiles(File in, List<String> astGenOut) {
        List skipped = astGenOut.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(String x) {
                String string = x;
                String out = string;
                if (!out.startsWith("Converted") && !out.startsWith("Retrieving")) {
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                String out = string;
                if (!out.startsWith("Converted") && !out.startsWith("Retrieving")) {
                    String filename = out.substring(0, out.indexOf(" "));
                    return Option$.MODULE$.apply((Object)filename);
                }
                return None$.MODULE$;
            }
        });
        return (List)skipped.flatten(Predef$.MODULE$.$conforms());
    }

    private boolean isIgnoredByUserConfig(String filePath) {
        LazyBoolean lazyBoolean = new LazyBoolean();
        LazyBoolean lazyBoolean2 = new LazyBoolean();
        return this.isInIgnoredFiles$1(lazyBoolean, filePath) || this.isInIgnoredFileRegex$1(lazyBoolean2, filePath);
    }

    private boolean isMinifiedFile(String filePath) {
        String string = filePath;
        String p = string;
        if (AstGenRunner$.io$appthreat$jssrc2cpg$utils$AstGenRunner$$$MinifiedPathRegex.matches((CharSequence)p)) {
            return true;
        }
        String p2 = string;
        File file = File$.MODULE$.apply(p2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (file.exists(file.exists$default$1()) && p2.endsWith(".js")) {
            int longestLineLength;
            Seq lines = IOUtils$.MODULE$.readLinesInFile(File$.MODULE$.apply(filePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path());
            int linesOfCode = lines.size();
            int n = longestLineLength = lines.isEmpty() ? 0 : BoxesRunTime.unboxToInt((Object)((IterableOnceOps)lines.map((Function1 & Serializable)_$1 -> _$1.length())).max((Ordering)Ordering.Int$.MODULE$));
            return longestLineLength >= AstGenRunner$.io$appthreat$jssrc2cpg$utils$AstGenRunner$$$LineLengthThreshold && linesOfCode <= 50;
        }
        return false;
    }

    private boolean isIgnoredByDefault(String filePath) {
        LazyBoolean lazyBoolean = new LazyBoolean();
        LazyBoolean lazyBoolean2 = new LazyBoolean();
        LazyBoolean lazyBoolean3 = new LazyBoolean();
        return AstGenRunner.isIgnored$1(lazyBoolean, filePath) || AstGenRunner.isIgnoredTest$1(lazyBoolean2, filePath) || this.isMinified$1(lazyBoolean3, filePath);
    }

    private boolean isTranspiledFile(String filePath) {
        LazyBoolean lazyBoolean = new LazyBoolean();
        LazyBoolean lazyBoolean2 = new LazyBoolean();
        LazyBoolean lazyBoolean3 = new LazyBoolean();
        LazyBoolean lazyBoolean4 = new LazyBoolean();
        LazyBoolean lazyBoolean5 = new LazyBoolean();
        File file = File$.MODULE$.apply(filePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        return AstGenRunner.isJsFile$1(lazyBoolean, file) && AstGenRunner.hasSourceMap$1(lazyBoolean4, lazyBoolean2, file, lazyBoolean3, filePath) && AstGenRunner.hasFileWithSameName$1(lazyBoolean5, file);
    }

    private List<String> filterFiles(List<String> files, File out) {
        return files.filter((Function1 & Serializable)file -> {
            String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(file), ".json").replace(out.pathAsString(), this.config.inputPath());
            String filePath = string;
            if (AstGenRunner$.io$appthreat$jssrc2cpg$utils$AstGenRunner$$$TypeDefinitionFileExtensions.exists((Function1 & Serializable)x$0 -> filePath.endsWith((String)x$0))) {
                return false;
            }
            String filePath2 = string;
            if (this.isIgnoredByUserConfig(filePath2)) {
                return false;
            }
            String filePath3 = string;
            if (this.isIgnoredByDefault(filePath3)) {
                return false;
            }
            String filePath4 = string;
            return !this.isTranspiledFile(filePath4);
        });
    }

    private File changeExtensionTo(File file, String extension) {
        String newName = file.nameWithoutExtension(false) + "." + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(extension), ".");
        if (file.isRegularFile(file.isRegularFile$default$1())) {
            return file.renameTo(newName);
        }
        if (file.notExists(file.notExists$default$1())) {
            return File$.MODULE$.apply(newName, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        }
        return file;
    }

    private Try<Seq<String>> processEjsFiles(File in, File out, List<String> ejsFiles) {
        List tmpJsFiles = ejsFiles.map((Function1 & Serializable)ejsFilePath -> {
            File ejsFile = File$.MODULE$.apply(ejsFilePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            File maybeTranspiledFile = File$.MODULE$.apply(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(ejsFilePath), ".ejs") + ".js", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            if (this.isTranspiledFile(maybeTranspiledFile.pathAsString())) {
                return maybeTranspiledFile;
            }
            String sourceFileContent = IOUtils$.MODULE$.readEntireFile(ejsFile.path());
            String preprocessContent = new EjsPreprocessor().preprocess(sourceFileContent);
            File file = out.$div(in.relativize(ejsFile).toString()).parent();
            file.createDirectoryIfNotExists(true, file.createDirectoryIfNotExists$default$2(true), file.createDirectoryIfNotExists$default$3(true));
            File file2 = out.$div(in.relativize(ejsFile).toString());
            boolean bl = ejsFile.copyTo$default$2();
            File newEjsFile = ejsFile.copyTo(file2, bl, ejsFile.copyTo$default$3(file2, bl));
            File file3 = this.changeExtensionTo(newEjsFile, ".js");
            File jsFile = file3.writeText(preprocessContent, file3.writeText$default$2(preprocessContent), file3.writeText$default$3(preprocessContent));
            File file4 = newEjsFile.createFile(newEjsFile.createFile$default$1());
            file4.writeText(sourceFileContent, file4.writeText$default$2(sourceFileContent), file4.writeText$default$3(sourceFileContent));
            return jsFile;
        });
        Try result = ExternalCommand$.MODULE$.run(AstGenRunner$.MODULE$.io$appthreat$jssrc2cpg$utils$AstGenRunner$$$astGenCommand() + this.executableArgs + " -t ts -o " + out, out.toString(), ExternalCommand$.MODULE$.run$default$3());
        String string = out.toString();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}));
        Option option = SourceFiles$.MODULE$.determine$default$3();
        Option option2 = SourceFiles$.MODULE$.determine$default$4();
        Option option3 = SourceFiles$.MODULE$.determine$default$5();
        List jsons = SourceFiles$.MODULE$.determine(string, set, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, set, option, option2, option3));
        jsons.foreach((Function1 & Serializable)jsonPath -> {
            File jsonFile = File$.MODULE$.apply(jsonPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            String jsonContent = IOUtils$.MODULE$.readEntireFile(jsonFile.path());
            Value json = ujson.package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(jsonContent), ujson.package$.MODULE$.read$default$2());
            String fileName = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector("fullName")).str();
            String newFileName = StringOps$.MODULE$.patch$extension(Predef$.MODULE$.augmentString(fileName), fileName.lastIndexOf(".js"), ".ejs", 3);
            json.update((Value.Selector)Value.Selector$.MODULE$.StringSelector("relativeName"), (Value)Value$.MODULE$.JsonableString((CharSequence)newFileName));
            json.update((Value.Selector)Value.Selector$.MODULE$.StringSelector("fullName"), (Value)Value$.MODULE$.JsonableString((CharSequence)newFileName));
            String string = json.toString();
            return jsonFile.writeText(string, jsonFile.writeText$default$2(string), jsonFile.writeText$default$3(string));
        });
        tmpJsFiles.foreach((Function1 & Serializable)_$6 -> _$6.delete(_$6.delete$default$1(), _$6.delete$default$2()));
        return result;
    }

    private Try<Seq<String>> ejsFiles(File in, File out) {
        Option option;
        Option option2;
        Option option3;
        String string = in.pathAsString();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".ejs"}));
        List files = SourceFiles$.MODULE$.determine(string, set, option3 = SourceFiles$.MODULE$.determine$default$3(), option2 = SourceFiles$.MODULE$.determine$default$4(), option = SourceFiles$.MODULE$.determine$default$5(), SourceFiles$.MODULE$.determine$default$6(string, set, option3, option2, option));
        if (files.nonEmpty()) {
            return this.processEjsFiles(in, out, (List<String>)files);
        }
        return Success$.MODULE$.apply((Object)package$.MODULE$.Seq().empty());
    }

    private Try<Seq<String>> vueFiles(File in, File out) {
        Option option;
        Option option2;
        Option option3;
        String string = in.pathAsString();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".vue"}));
        List files = SourceFiles$.MODULE$.determine(string, set, option3 = SourceFiles$.MODULE$.determine$default$3(), option2 = SourceFiles$.MODULE$.determine$default$4(), option = SourceFiles$.MODULE$.determine$default$5(), SourceFiles$.MODULE$.determine$default$6(string, set, option3, option2, option));
        if (files.nonEmpty()) {
            return ExternalCommand$.MODULE$.run(AstGenRunner$.MODULE$.io$appthreat$jssrc2cpg$utils$AstGenRunner$$$astGenCommand() + this.executableArgs + " -t vue -o " + out, in.toString(), ExternalCommand$.MODULE$.run$default$3());
        }
        return Success$.MODULE$.apply((Object)package$.MODULE$.Seq().empty());
    }

    private Try<Seq<String>> jsFiles(File in, File out) {
        return ExternalCommand$.MODULE$.run(AstGenRunner$.MODULE$.io$appthreat$jssrc2cpg$utils$AstGenRunner$$$astGenCommand() + this.executableArgs + " -t ts -o " + out, in.toString(), ExternalCommand$.MODULE$.run$default$3());
    }

    private Try<Seq<String>> runAstGenNative(File in, File out) {
        return this.ejsFiles(in, out).flatMap((Function1 & Serializable)ejsResult -> this.vueFiles(in, out).flatMap((Function1 & Serializable)vueResult -> this.jsFiles(in, out).map((Function1 & Serializable)jsResult -> (Seq)((IterableOps)jsResult.$plus$plus((IterableOnce)vueResult)).$plus$plus((IterableOnce)ejsResult))));
    }

    public AstGenRunnerResult execute(File out) {
        File in = File$.MODULE$.apply(this.config.inputPath(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        Try<Seq<String>> try_ = this.runAstGenNative(in, out);
        if (try_ instanceof Success) {
            Seq result = (Seq)((Success)try_).value();
            String string = out.toString();
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}));
            Option option = SourceFiles$.MODULE$.determine$default$3();
            Option option2 = SourceFiles$.MODULE$.determine$default$4();
            Option option3 = SourceFiles$.MODULE$.determine$default$5();
            List<String> parsed = this.filterFiles((List<String>)SourceFiles$.MODULE$.determine(string, set, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, set, option, option2, option3)), out);
            List<String> skipped = this.skippedFiles(in, (List<String>)result.toList());
            return AstGenRunner$AstGenRunnerResult$.MODULE$.apply((List<Tuple2<String, String>>)parsed.map((Function1 & Serializable)_$7 -> Tuple2$.MODULE$.apply((Object)in.toString(), _$7)), (List<Tuple2<String, String>>)skipped.map((Function1 & Serializable)_$8 -> Tuple2$.MODULE$.apply((Object)in.toString(), _$8)));
        }
        if (try_ instanceof Failure) {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.apply(AstGenRunner$AstGenRunnerResult$.MODULE$.$lessinit$greater$default$1(), AstGenRunner$AstGenRunnerResult$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(try_);
    }

    private final boolean isInIgnoredFiles$lzyINIT1$1(LazyBoolean isInIgnoredFiles$lzy1$1, String filePath$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isInIgnoredFiles$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isInIgnoredFiles$lzy1$1.initialized() ? isInIgnoredFiles$lzy1$1.value() : isInIgnoredFiles$lzy1$1.initialize(this.config.ignoredFiles().exists((Function1 & Serializable)x$1 -> {
                String string = x$1;
                String ignorePath = string;
                File file = File$.MODULE$.apply(ignorePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
                if (file.isDirectory(file.isDirectory$default$1())) {
                    return filePath$1.startsWith(ignorePath);
                }
                String ignorePath2 = string;
                String string2 = filePath$1;
                String string3 = ignorePath2;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }));
        }
        return bl;
    }

    private final boolean isInIgnoredFiles$1(LazyBoolean isInIgnoredFiles$lzy1$2, String filePath$3) {
        if (isInIgnoredFiles$lzy1$2.initialized()) {
            return isInIgnoredFiles$lzy1$2.value();
        }
        return this.isInIgnoredFiles$lzyINIT1$1(isInIgnoredFiles$lzy1$2, filePath$3);
    }

    private final boolean isInIgnoredFileRegex$lzyINIT1$1(LazyBoolean isInIgnoredFileRegex$lzy1$1, String filePath$4) {
        boolean bl;
        LazyBoolean lazyBoolean = isInIgnoredFileRegex$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isInIgnoredFileRegex$lzy1$1.initialized() ? isInIgnoredFileRegex$lzy1$1.value() : isInIgnoredFileRegex$lzy1$1.initialize(this.config.ignoredFilesRegex().matches((CharSequence)filePath$4));
        }
        return bl;
    }

    private final boolean isInIgnoredFileRegex$1(LazyBoolean isInIgnoredFileRegex$lzy1$2, String filePath$5) {
        if (isInIgnoredFileRegex$lzy1$2.initialized()) {
            return isInIgnoredFileRegex$lzy1$2.value();
        }
        return this.isInIgnoredFileRegex$lzyINIT1$1(isInIgnoredFileRegex$lzy1$2, filePath$5);
    }

    private static final boolean isIgnored$lzyINIT1$1(LazyBoolean isIgnored$lzy1$1, String filePath$6) {
        boolean bl;
        LazyBoolean lazyBoolean = isIgnored$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isIgnored$lzy1$1.initialized() ? isIgnored$lzy1$1.value() : isIgnored$lzy1$1.initialize(AstGenRunner$.io$appthreat$jssrc2cpg$utils$AstGenRunner$$$IgnoredFilesRegex.exists((Function1 & Serializable)_$2 -> _$2.matches((CharSequence)filePath$6)));
        }
        return bl;
    }

    private static final boolean isIgnored$1(LazyBoolean isIgnored$lzy1$2, String filePath$8) {
        if (isIgnored$lzy1$2.initialized()) {
            return isIgnored$lzy1$2.value();
        }
        return AstGenRunner.isIgnored$lzyINIT1$1(isIgnored$lzy1$2, filePath$8);
    }

    private static final boolean isIgnoredTest$lzyINIT1$1(LazyBoolean isIgnoredTest$lzy1$1, String filePath$9) {
        boolean bl;
        LazyBoolean lazyBoolean = isIgnoredTest$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isIgnoredTest$lzy1$1.initialized() ? isIgnoredTest$lzy1$1.value() : isIgnoredTest$lzy1$1.initialize(AstGenRunner$.io$appthreat$jssrc2cpg$utils$AstGenRunner$$$IgnoredTestsRegex.exists((Function1 & Serializable)_$3 -> _$3.matches((CharSequence)filePath$9)));
        }
        return bl;
    }

    private static final boolean isIgnoredTest$1(LazyBoolean isIgnoredTest$lzy1$2, String filePath$11) {
        if (isIgnoredTest$lzy1$2.initialized()) {
            return isIgnoredTest$lzy1$2.value();
        }
        return AstGenRunner.isIgnoredTest$lzyINIT1$1(isIgnoredTest$lzy1$2, filePath$11);
    }

    private final boolean isMinified$lzyINIT1$1(LazyBoolean isMinified$lzy1$1, String filePath$12) {
        boolean bl;
        LazyBoolean lazyBoolean = isMinified$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isMinified$lzy1$1.initialized() ? isMinified$lzy1$1.value() : isMinified$lzy1$1.initialize(this.isMinifiedFile(filePath$12));
        }
        return bl;
    }

    private final boolean isMinified$1(LazyBoolean isMinified$lzy1$2, String filePath$13) {
        if (isMinified$lzy1$2.initialized()) {
            return isMinified$lzy1$2.value();
        }
        return this.isMinified$lzyINIT1$1(isMinified$lzy1$2, filePath$13);
    }

    private static final boolean isJsFile$lzyINIT1$1(LazyBoolean isJsFile$lzy1$1, File file$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isJsFile$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isJsFile$lzy1$1.initialized() ? isJsFile$lzy1$1.value() : isJsFile$lzy1$1.initialize(file$1.exists(file$1.exists$default$1()) && file$1.extension().contains((Object)".js"));
        }
        return bl;
    }

    private static final boolean isJsFile$1(LazyBoolean isJsFile$lzy1$2, File file$2) {
        if (isJsFile$lzy1$2.initialized()) {
            return isJsFile$lzy1$2.value();
        }
        return AstGenRunner.isJsFile$lzyINIT1$1(isJsFile$lzy1$2, file$2);
    }

    private static final boolean hasSourceMapComment$lzyINIT1$1(LazyBoolean hasSourceMapComment$lzy1$1, File file$3) {
        boolean bl;
        LazyBoolean lazyBoolean = hasSourceMapComment$lzy1$1;
        synchronized (lazyBoolean) {
            bl = hasSourceMapComment$lzy1$1.initialized() ? hasSourceMapComment$lzy1$1.value() : hasSourceMapComment$lzy1$1.initialize(IOUtils$.MODULE$.readLinesInFile(file$3.path()).exists((Function1 & Serializable)_$4 -> _$4.contains("//sourceMappingURL")));
        }
        return bl;
    }

    private static final boolean hasSourceMapComment$1(LazyBoolean hasSourceMapComment$lzy1$2, File file$4) {
        if (hasSourceMapComment$lzy1$2.initialized()) {
            return hasSourceMapComment$lzy1$2.value();
        }
        return AstGenRunner.hasSourceMapComment$lzyINIT1$1(hasSourceMapComment$lzy1$2, file$4);
    }

    private static final boolean hasSourceMapFile$lzyINIT1$1(LazyBoolean hasSourceMapFile$lzy1$1, String filePath$14) {
        boolean bl;
        LazyBoolean lazyBoolean = hasSourceMapFile$lzy1$1;
        synchronized (lazyBoolean) {
            boolean bl2;
            if (hasSourceMapFile$lzy1$1.initialized()) {
                bl2 = hasSourceMapFile$lzy1$1.value();
            } else {
                File file = File$.MODULE$.apply(filePath$14 + ".map", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
                bl2 = hasSourceMapFile$lzy1$1.initialize(file.exists(file.exists$default$1()));
            }
            bl = bl2;
        }
        return bl;
    }

    private static final boolean hasSourceMapFile$1(LazyBoolean hasSourceMapFile$lzy1$2, String filePath$15) {
        if (hasSourceMapFile$lzy1$2.initialized()) {
            return hasSourceMapFile$lzy1$2.value();
        }
        return AstGenRunner.hasSourceMapFile$lzyINIT1$1(hasSourceMapFile$lzy1$2, filePath$15);
    }

    private static final boolean hasSourceMap$lzyINIT1$1(LazyBoolean hasSourceMap$lzy1$1, LazyBoolean hasSourceMapComment$lzy1$3, File file$5, LazyBoolean hasSourceMapFile$lzy1$3, String filePath$16) {
        boolean bl;
        LazyBoolean lazyBoolean = hasSourceMap$lzy1$1;
        synchronized (lazyBoolean) {
            bl = hasSourceMap$lzy1$1.initialized() ? hasSourceMap$lzy1$1.value() : hasSourceMap$lzy1$1.initialize(AstGenRunner.hasSourceMapComment$1(hasSourceMapComment$lzy1$3, file$5) || AstGenRunner.hasSourceMapFile$1(hasSourceMapFile$lzy1$3, filePath$16));
        }
        return bl;
    }

    private static final boolean hasSourceMap$1(LazyBoolean hasSourceMap$lzy1$2, LazyBoolean hasSourceMapComment$lzy1$4, File file$6, LazyBoolean hasSourceMapFile$lzy1$4, String filePath$17) {
        if (hasSourceMap$lzy1$2.initialized()) {
            return hasSourceMap$lzy1$2.value();
        }
        return AstGenRunner.hasSourceMap$lzyINIT1$1(hasSourceMap$lzy1$2, hasSourceMapComment$lzy1$4, file$6, hasSourceMapFile$lzy1$4, filePath$17);
    }

    private static final boolean hasFileWithSameName$lzyINIT1$1(LazyBoolean hasFileWithSameName$lzy1$1, File file$7) {
        boolean bl;
        LazyBoolean lazyBoolean = hasFileWithSameName$lzy1$1;
        synchronized (lazyBoolean) {
            bl = hasFileWithSameName$lzy1$1.initialized() ? hasFileWithSameName$lzy1$1.value() : hasFileWithSameName$lzy1$1.initialize(file$7.siblings().exists((Function1 & Serializable)_$5 -> {
                String string = _$5.nameWithoutExtension(false);
                String string2 = file$7.nameWithoutExtension();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }));
        }
        return bl;
    }

    private static final boolean hasFileWithSameName$1(LazyBoolean hasFileWithSameName$lzy1$2, File file$9) {
        if (hasFileWithSameName$lzy1$2.initialized()) {
            return hasFileWithSameName$lzy1$2.value();
        }
        return AstGenRunner.hasFileWithSameName$lzyINIT1$1(hasFileWithSameName$lzy1$2, file$9);
    }

    public static class AstGenRunnerResult
    implements Product,
    Serializable {
        private final List<Tuple2<String, String>> parsedFiles;
        private final List<Tuple2<String, String>> skippedFiles;

        public static AstGenRunnerResult apply(List<Tuple2<String, String>> list, List<Tuple2<String, String>> list2) {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.apply(list, list2);
        }

        public static AstGenRunnerResult fromProduct(Product product) {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.fromProduct(product);
        }

        public static AstGenRunnerResult unapply(AstGenRunnerResult astGenRunnerResult) {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.unapply(astGenRunnerResult);
        }

        public static List<Tuple2<String, String>> $lessinit$greater$default$1() {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.$lessinit$greater$default$1();
        }

        public static List<Tuple2<String, String>> $lessinit$greater$default$2() {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.$lessinit$greater$default$2();
        }

        public AstGenRunnerResult(List<Tuple2<String, String>> parsedFiles, List<Tuple2<String, String>> skippedFiles) {
            this.parsedFiles = parsedFiles;
            this.skippedFiles = skippedFiles;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AstGenRunnerResult)) return false;
            AstGenRunnerResult astGenRunnerResult = (AstGenRunnerResult)object;
            List<Tuple2<String, String>> list = this.parsedFiles();
            List<Tuple2<String, String>> list2 = astGenRunnerResult.parsedFiles();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List<Tuple2<String, String>> list3 = this.skippedFiles();
            List<Tuple2<String, String>> list4 = astGenRunnerResult.skippedFiles();
            if (list3 == null) {
                if (list4 != null) {
                    return false;
                }
            } else if (!list3.equals(list4)) return false;
            if (!astGenRunnerResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AstGenRunnerResult;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AstGenRunnerResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "parsedFiles";
            }
            if (1 == n2) {
                return "skippedFiles";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Tuple2<String, String>> parsedFiles() {
            return this.parsedFiles;
        }

        public List<Tuple2<String, String>> skippedFiles() {
            return this.skippedFiles;
        }

        public AstGenRunnerResult copy(List<Tuple2<String, String>> parsedFiles, List<Tuple2<String, String>> skippedFiles) {
            return new AstGenRunnerResult(parsedFiles, skippedFiles);
        }

        public List<Tuple2<String, String>> copy$default$1() {
            return this.parsedFiles();
        }

        public List<Tuple2<String, String>> copy$default$2() {
            return this.skippedFiles();
        }

        public List<Tuple2<String, String>> _1() {
            return this.parsedFiles();
        }

        public List<Tuple2<String, String>> _2() {
            return this.skippedFiles();
        }
    }
}

