/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayDeque;
import java.util.Iterator;
import overflowdb.DetachedNodeData;
import overflowdb.DetachedNodeGeneric;
import overflowdb.Edge;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.NodeOrDetachedNode;
import overflowdb.util.IteratorUtils;

public class BatchedUpdate {
    public static final Object[] emptyArray = new Object[0];

    public static AppliedDiff applyDiff(Graph graph, DiffOrBuilder diff) {
        return new DiffGraphApplier(graph, diff, null, null).run();
    }

    public static AppliedDiff applyDiff(Graph graph, DiffOrBuilder diff, KeyPool keyPool, ModificationListener listener) {
        return new DiffGraphApplier(graph, diff, keyPool, listener).run();
    }

    private static class DiffGraphApplier {
        private final DiffOrBuilder diff;
        private final KeyPool keyPool;
        private final ModificationListener listener;
        private final ArrayDeque<DetachedNodeData> deferredInitializers = new ArrayDeque();
        private final Graph graph;
        private int nChanges = 0;

        DiffGraphApplier(Graph graph, DiffOrBuilder diff, KeyPool keyPool, ModificationListener listener) {
            this.diff = diff;
            this.keyPool = keyPool;
            this.listener = listener;
            this.graph = graph;
        }

        AppliedDiff run() {
            try {
                Iterator<Change> it = this.diff.iterator();
                while (it.hasNext()) {
                    Change change = it.next();
                    this.applyChange(change);
                }
            }
            finally {
                if (this.listener != null) {
                    this.listener.finish();
                }
            }
            return new AppliedDiff(this.graph, this.diff, this.listener, this.nChanges);
        }

        private Node mapDetached(DetachedNodeData detachedNode) {
            Object linkedNode = detachedNode.getRefOrId();
            if (linkedNode == null || linkedNode instanceof Long) {
                if (linkedNode == null) {
                    linkedNode = this.keyPool == null ? this.graph.addNode(detachedNode.label(), new Object[0]) : this.graph.addNode(this.keyPool.next(), detachedNode.label(), new Object[0]);
                } else if (linkedNode instanceof Long) {
                    linkedNode = this.graph.addNode((Long)linkedNode, detachedNode.label(), new Object[0]);
                }
                detachedNode.setRefOrId(linkedNode);
                this.deferredInitializers.addLast(detachedNode);
            }
            return (Node)linkedNode;
        }

        private void drainDeferred() {
            while (!this.deferredInitializers.isEmpty()) {
                DetachedNodeData detachedNode = this.deferredInitializers.removeFirst();
                Node actualNode = (Node)detachedNode.getRefOrId();
                Node.initializeFromDetached(actualNode, detachedNode, this::mapDetached);
                ++this.nChanges;
                if (this.listener == null) continue;
                this.listener.onAfterInitNewNode(actualNode);
            }
        }

        private void applyChange(Change change) {
            if (change instanceof DetachedNodeData) {
                this.mapDetached((DetachedNodeData)change);
                this.drainDeferred();
            } else if (change instanceof CreateEdge) {
                Object[] properties;
                ++this.nChanges;
                CreateEdge create = (CreateEdge)change;
                Node src = create.src instanceof DetachedNodeData ? this.mapDetached((DetachedNodeData)create.src) : (Node)create.src;
                Node dst = create.dst instanceof DetachedNodeData ? this.mapDetached((DetachedNodeData)create.dst) : (Node)create.dst;
                this.drainDeferred();
                Object[] objectArray = properties = create.propertiesAndKeys == null ? emptyArray : create.propertiesAndKeys;
                if (this.listener != null) {
                    Edge edge = src.addEdgeInternal(create.label, dst, properties);
                    this.listener.onAfterAddNewEdge(edge);
                } else {
                    src.addEdgeSilentInternal(create.label, dst, properties);
                }
            } else if (change instanceof RemoveEdge) {
                ++this.nChanges;
                RemoveEdge remove = (RemoveEdge)change;
                if (this.listener != null) {
                    this.listener.onBeforeRemoveEdge(remove.edge);
                }
                remove.edge.removeInternal();
            } else if (change instanceof RemoveNode) {
                ++this.nChanges;
                RemoveNode remove = (RemoveNode)change;
                if (this.listener != null) {
                    this.listener.onBeforeRemoveNode(remove.node);
                }
                remove.node.removeInternal();
            } else if (change instanceof SetNodeProperty) {
                ++this.nChanges;
                SetNodeProperty setProp = (SetNodeProperty)change;
                if (this.listener != null) {
                    this.listener.onBeforePropertyChange(setProp.node, setProp.label);
                }
                setProp.node.setPropertyInternal(setProp.label, setProp.value);
                if (this.listener != null) {
                    this.listener.onAfterPropertyChange(setProp.node, setProp.label, setProp.value);
                }
                this.drainDeferred();
            }
        }
    }

    public static interface DiffOrBuilder {
        public int size();

        public Iterator<Change> iterator();
    }

    public static interface KeyPool {
        public long next();
    }

    public static interface ModificationListener {
        public void onAfterInitNewNode(Node var1);

        public void onAfterAddNewEdge(Edge var1);

        public void onBeforePropertyChange(Node var1, String var2);

        public void onAfterPropertyChange(Node var1, String var2, Object var3);

        public void onBeforeRemoveNode(Node var1);

        public void onBeforeRemoveEdge(Edge var1);

        public void finish();
    }

    public static class AppliedDiff {
        public DiffOrBuilder diffGraph;
        private ModificationListener listener;
        private int transitiveModifications;
        private Graph graph;

        AppliedDiff(Graph graph, DiffOrBuilder diffGraph, ModificationListener listener, int transitiveModifications) {
            this.graph = graph;
            this.diffGraph = diffGraph;
            this.listener = listener;
            this.transitiveModifications = transitiveModifications;
        }

        public DiffGraph getDiffGraph() {
            if (this.diffGraph instanceof DiffGraphBuilder) {
                this.diffGraph = ((DiffGraphBuilder)this.diffGraph).build();
            }
            return (DiffGraph)this.diffGraph;
        }

        public ModificationListener getListener() {
            return this.listener;
        }

        public int explicitModifications() {
            return this.diffGraph.size();
        }

        public int transitiveModifications() {
            return this.transitiveModifications;
        }
    }

    public static class SetNodeProperty
    implements Change {
        public String label;
        public Node node;
        public Object value;

        public SetNodeProperty(String label, Node node, Object value) {
            this.label = label;
            this.node = node;
            this.value = value;
        }
    }

    public static class CreateEdge
    implements Change {
        public String label;
        public NodeOrDetachedNode src;
        public NodeOrDetachedNode dst;
        public Object[] propertiesAndKeys;

        public CreateEdge(String label, NodeOrDetachedNode src, NodeOrDetachedNode dst, Object[] propertiesAndKeys) {
            this.label = label;
            this.src = src;
            this.dst = dst;
            this.propertiesAndKeys = propertiesAndKeys;
        }
    }

    public static class RemoveNode
    implements Change {
        public Node node;

        public RemoveNode(Node node) {
            this.node = node;
        }
    }

    public static class CreateNode
    implements Change {
        public String label;
        public Object[] ProprtiesAndKeys;
        public long id;

        public CreateNode(String label) {
            this.label = label;
        }
    }

    private static class RemoveEdge
    implements Change {
        public Edge edge;

        public RemoveEdge(Edge edge) {
            this.edge = edge;
        }
    }

    public static class DiffGraphBuilder
    implements DiffOrBuilder {
        private ArrayDeque<Change> _buffer = new ArrayDeque();

        public DiffGraph build() {
            DiffGraph res = new DiffGraph(this._buffer.toArray(new Change[0]));
            this._buffer = null;
            return res;
        }

        @Override
        public int size() {
            return this._buffer.size();
        }

        @Override
        public Iterator<Change> iterator() {
            return this._buffer.iterator();
        }

        public DiffGraphBuilder absorb(DiffGraphBuilder other) {
            if (this._buffer.size() > other._buffer.size()) {
                this._buffer.addAll(other._buffer);
                other._buffer = null;
            } else {
                ArrayDeque<Change> tmp = this._buffer;
                this._buffer = other._buffer;
                other._buffer = null;
                Iterator<Change> it = tmp.descendingIterator();
                while (it.hasNext()) {
                    Change change = it.next();
                    this._buffer.addFirst(change);
                }
            }
            return this;
        }

        public DiffGraphBuilder addNode(DetachedNodeData node) {
            this._buffer.addLast(node);
            return this;
        }

        public DiffGraphBuilder addNode(String label, Object ... keyvalues) {
            this._buffer.addLast(new DetachedNodeGeneric(label, keyvalues));
            return this;
        }

        public DiffGraphBuilder addEdge(NodeOrDetachedNode src, NodeOrDetachedNode dst, String label) {
            this._buffer.addLast(new CreateEdge(label, src, dst, null));
            return this;
        }

        public DiffGraphBuilder addEdge(NodeOrDetachedNode src, NodeOrDetachedNode dst, String label, Object ... properties) {
            this._buffer.addLast(new CreateEdge(label, src, dst, (Object[])(properties.length > 0 ? properties : null)));
            return this;
        }

        public DiffGraphBuilder setNodeProperty(Node node, String label, Object property) {
            this._buffer.addLast(new SetNodeProperty(label, node, property));
            return this;
        }

        public DiffGraphBuilder removeNode(Node node) {
            this._buffer.addLast(new RemoveNode(node));
            return this;
        }

        public DiffGraphBuilder removeEdge(Edge edge) {
            this._buffer.addLast(new RemoveEdge(edge));
            return this;
        }
    }

    public static class DiffGraph
    implements DiffOrBuilder {
        public final Change[] changes;

        DiffGraph(Change[] changes) {
            this.changes = changes;
        }

        @Override
        public int size() {
            return this.changes.length;
        }

        @Override
        public Iterator<Change> iterator() {
            return new IteratorUtils.ArrayIterator<Change>(this.changes);
        }
    }

    public static interface Change {
    }
}

