/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import overflowdb.Config;
import overflowdb.DetachedNodeData;
import overflowdb.Direction;
import overflowdb.Edge;
import overflowdb.EdgeFactory;
import overflowdb.IndexManager;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.NodeFactory;
import overflowdb.NodeRef;
import overflowdb.ReferenceManager;
import overflowdb.storage.NodeDeserializer;
import overflowdb.storage.NodeSerializer;
import overflowdb.storage.NodesWriter;
import overflowdb.storage.OdbStorage;
import overflowdb.util.IteratorUtils;
import overflowdb.util.MultiIterator;
import overflowdb.util.NodesList;
import overflowdb.util.PropertyHelper;
import overflowdb.util.StringInterner;

public final class Graph
implements AutoCloseable {
    protected final AtomicLong currentId = new AtomicLong(-1L);
    final NodesList nodes = new NodesList();
    public final IndexManager indexManager = new IndexManager(this);
    private final Config config;
    private volatile boolean closed = false;
    protected final Map<String, NodeFactory> nodeFactoryByLabel;
    protected final Map<String, EdgeFactory> edgeFactoryByLabel;
    protected final OdbStorage storage;
    public final NodeSerializer nodeSerializer;
    protected final NodeDeserializer nodeDeserializer;
    protected final StringInterner stringInterner;
    protected final boolean overflowEnabled;
    protected final ReferenceManager referenceManager;
    protected final NodesWriter nodesWriter;

    public static Graph open(Config configuration, List<NodeFactory<?>> nodeFactories, List<EdgeFactory<?>> edgeFactories, Function<Object, Object> convertPropertyForPersistence) {
        HashMap<String, NodeFactory> nodeFactoryByLabel = new HashMap<String, NodeFactory>(nodeFactories.size());
        HashMap<String, EdgeFactory> edgeFactoryByLabel = new HashMap<String, EdgeFactory>(edgeFactories.size());
        nodeFactories.forEach(factory -> nodeFactoryByLabel.put(factory.forLabel(), (NodeFactory)factory));
        edgeFactories.forEach(factory -> edgeFactoryByLabel.put(factory.forLabel(), (EdgeFactory)factory));
        return new Graph(configuration, nodeFactoryByLabel, edgeFactoryByLabel, convertPropertyForPersistence);
    }

    public static Graph open(Config configuration, List<NodeFactory<?>> nodeFactories, List<EdgeFactory<?>> edgeFactories) {
        return Graph.open(configuration, nodeFactories, edgeFactories, Function.identity());
    }

    private Graph(Config config, Map<String, NodeFactory> nodeFactoryByLabel, Map<String, EdgeFactory> edgeFactoryByLabel, Function<Object, Object> convertPropertyForPersistence) {
        this.config = config;
        this.nodeFactoryByLabel = nodeFactoryByLabel;
        this.edgeFactoryByLabel = edgeFactoryByLabel;
        this.stringInterner = new StringInterner();
        this.storage = config.getStorageLocation().isPresent() ? OdbStorage.createWithSpecificLocation(config.getStorageLocation().get().toFile(), this.stringInterner) : OdbStorage.createWithTempFile(this.stringInterner);
        this.nodeDeserializer = new NodeDeserializer(this, nodeFactoryByLabel, config.isSerializationStatsEnabled(), this.storage);
        this.nodeSerializer = new NodeSerializer(config.isSerializationStatsEnabled(), this.storage, convertPropertyForPersistence);
        this.nodesWriter = new NodesWriter(this.nodeSerializer, this.storage);
        config.getStorageLocation().ifPresent(l -> this.initElementCollections(this.storage));
        this.overflowEnabled = config.isOverflowEnabled();
        this.referenceManager = this.overflowEnabled ? (config.getExecutorService().isPresent() ? new ReferenceManager(this.storage, this.nodesWriter, config.getExecutorService().get()) : new ReferenceManager(this.storage, this.nodesWriter)) : null;
    }

    private void initElementCollections(OdbStorage storage) {
        long start = System.currentTimeMillis();
        Set<Map.Entry<Long, byte[]>> serializedNodes = storage.allNodes();
        int serializedNodesCount = serializedNodes.size();
        if (serializedNodesCount > 0) {
            // empty if block
        }
        int importCount = 0;
        long maxId = this.currentId.get();
        for (Map.Entry<Long, byte[]> entry : serializedNodes) {
            try {
                NodeRef nodeRef = this.nodeDeserializer.deserializeRef(entry.getValue());
                this.nodes.add(nodeRef);
                if (++importCount % 131072 == 0) {
                    // empty if block
                }
                if (nodeRef.id <= maxId) continue;
                maxId = nodeRef.id;
            }
            catch (IOException e) {
                throw new RuntimeException("error while initializing vertex from storage: id=" + String.valueOf(entry.getKey()), e);
            }
        }
        this.currentId.set(maxId + 1L);
        this.indexManager.initializeStoredIndices(storage);
        long elapsedMillis = System.currentTimeMillis() - start;
    }

    public Node addNode(String label, Object ... keyValues) {
        return this.addNodeInternal(this.currentId.incrementAndGet(), label, keyValues);
    }

    public Node addNode(long id, String label, Object ... keyValues) {
        long currentIdAfter;
        if (this.nodes.contains(id)) {
            throw new IllegalArgumentException(String.format("Node with id already exists: %s", id));
        }
        long currentIdBefore = this.currentId.get();
        if (!this.currentId.compareAndSet(currentIdBefore, currentIdAfter = Long.max(id, this.currentId.get()))) {
            return this.addNode(id, label, keyValues);
        }
        return this.addNodeInternal(id, label, keyValues);
    }

    private Node addNodeInternal(long id, String label, Object ... keyValues) {
        if (this.isClosed()) {
            throw new AssertionError((Object)"graph is closed - no more mutation allowed");
        }
        NodeRef node = this.createNode(id, label, keyValues);
        this.nodes.add(node);
        return node;
    }

    public DetachedNodeData createDetached(String label) {
        if (!this.nodeFactoryByLabel.containsKey(label)) {
            throw new IllegalArgumentException("No NodeFactory for label=" + label + " available.");
        }
        NodeFactory factory = this.nodeFactoryByLabel.get(label);
        return factory.createDetached();
    }

    private NodeRef createNode(long idValue, String label, Object ... keyValues) {
        if (this.isClosed()) {
            throw new AssertionError((Object)"graph is closed - no more mutation allowed");
        }
        if (!this.nodeFactoryByLabel.containsKey(label)) {
            throw new IllegalArgumentException("No NodeFactory for label=" + label + " available.");
        }
        NodeFactory factory = this.nodeFactoryByLabel.get(label);
        Object node = factory.createNode(this, idValue, null);
        PropertyHelper.attachProperties(node, keyValues);
        this.registerNodeRef(((NodeDb)node).ref);
        return ((NodeDb)node).ref;
    }

    public void applyBackpressureMaybe() {
        if (this.referenceManager != null) {
            this.referenceManager.applyBackpressureMaybe();
        }
    }

    public void registerNodeRef(NodeRef ref) {
        if (this.referenceManager != null && !this.isClosed()) {
            this.referenceManager.registerRef(ref);
        }
    }

    public String toString() {
        return String.format("%s [%d nodes]", this.getClass().getSimpleName(), this.nodeCount());
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            this.closed = true;
            this.shutdownNow();
            this.stringInterner.clear();
        }
    }

    private void shutdownNow() {
        try {
            if (this.config.getStorageLocation().isPresent()) {
                this.indexManager.storeIndexes(this.storage);
                if (this.referenceManager != null) {
                    this.referenceManager.clearAllReferences();
                } else {
                    this.nodes.persistAll(this.nodesWriter);
                }
            }
        }
        finally {
            if (this.referenceManager != null) {
                this.referenceManager.close();
            }
            this.storage.close();
        }
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public int nodeCount(String label) {
        return this.nodes.cardinality(label);
    }

    public Map<String, Integer> nodeCountByLabel() {
        Set<String> nodeLabels = this.nodes.nodeLabels();
        HashMap<String, Integer> counts = new HashMap<String, Integer>(nodeLabels.size());
        for (String label : nodeLabels) {
            counts.put(label, this.nodes.nodesByLabel(label).size());
        }
        return counts;
    }

    public int edgeCount() {
        int edgeCount = 0;
        Iterator<Node> nodes = this.nodes();
        while (nodes.hasNext()) {
            NodeDb node = this.getNodeDb(nodes.next());
            edgeCount += node.outEdgeCount();
        }
        return edgeCount;
    }

    public Map<String, Integer> edgeCountByLabel() {
        TObjectIntHashMap counts = new TObjectIntHashMap();
        this.edges().forEachRemaining(edge -> counts.adjustOrPutValue((Object)edge.label(), 1, 1));
        HashMap<String, Integer> ret = new HashMap<String, Integer>(counts.size());
        TObjectIntIterator iterator = counts.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            ret.put((String)iterator.key(), iterator.value());
        }
        return ret;
    }

    public Iterator<Edge> E() {
        return this.edges();
    }

    public Iterator<Edge> edges() {
        return IteratorUtils.flatMap(this.nodes(), node -> node.outE());
    }

    public Iterator<Edge> edges(String label) {
        return IteratorUtils.flatMap(this.nodes(), node -> node.outE(label));
    }

    public Iterator<Node> V() {
        return this.nodes();
    }

    public final Iterator<Node> nodes() {
        return this.nodes.iterator();
    }

    public Iterator<Node> V(long ... ids) {
        return this.nodes(ids);
    }

    public Node node(long id) {
        return this.nodes.nodeById(id);
    }

    public Iterator<Node> nodes(long ... ids) {
        if (ids.length == 0) {
            return Collections.emptyIterator();
        }
        if (ids.length == 1) {
            return IteratorUtils.from(this.node(ids[0]));
        }
        return IteratorUtils.map(Arrays.stream(ids).iterator(), this::node);
    }

    public Iterator<Node> nodes(String label) {
        return this.nodes.nodesByLabel(label).iterator();
    }

    public Iterator<Node> nodes(String ... labels) {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        for (String label : labels) {
            this.addNodesToMultiIterator(multiIterator, label);
        }
        return multiIterator;
    }

    public Iterator<Node> nodes(Set<String> labels) {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        for (String label : labels) {
            this.addNodesToMultiIterator(multiIterator, label);
        }
        return multiIterator;
    }

    public Iterator<Node> nodes(Predicate<String> labelPredicate) {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        for (String label : this.nodes.nodeLabels()) {
            if (!labelPredicate.test(label)) continue;
            this.addNodesToMultiIterator(multiIterator, label);
        }
        return multiIterator;
    }

    private final void addNodesToMultiIterator(MultiIterator<Node> multiIterator, String label) {
        ArrayList<Node> ret = this.nodes.nodesByLabel(label);
        if (ret != null) {
            multiIterator.addIterator(ret.iterator());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public OdbStorage getStorage() {
        return this.storage;
    }

    public void copyTo(Graph destination) {
        if (destination.nodeCount() > 0) {
            throw new AssertionError((Object)"destination graph must be empty, but isn't");
        }
        this.nodes().forEachRemaining(node -> destination.addNode(node.id(), node.label(), PropertyHelper.toKeyValueArray(node.propertiesMap())));
        this.nodes().forEachRemaining(node -> {
            Object mapped = ((NodeRef)destination.node(node.id())).get();
            node.outE().forEachRemaining(edge -> {
                NodeRef other = (NodeRef)destination.node(edge.inNode().id());
                mapped.storeAdjacentNode(Direction.OUT, edge.label(), other, PropertyHelper.toKeyValueArray(edge.propertiesMap()));
            });
            node.inE().forEachRemaining(edge -> {
                NodeRef other = (NodeRef)destination.node(edge.outNode().id());
                mapped.storeAdjacentNode(Direction.IN, edge.label(), other, PropertyHelper.toKeyValueArray(edge.propertiesMap()));
            });
        });
    }

    public void remove(Node node) {
        NodeRef nodeRef = this.getNodeRef(node);
        this.nodes.remove(nodeRef);
        this.indexManager.removeElement(nodeRef);
        this.storage.removeNode(node.id());
    }

    private NodeRef getNodeRef(Node node) {
        if (node instanceof NodeRef) {
            return (NodeRef)node;
        }
        return ((NodeDb)node).ref;
    }

    private NodeDb getNodeDb(Node node) {
        if (node instanceof NodeDb) {
            return (NodeDb)node;
        }
        return ((NodeRef)node).get();
    }

    public void persistLibraryVersion(String name, String version) {
        this.storage.persistLibraryVersion(name, version);
    }

    public ArrayList<Map<String, String>> getAllLibraryVersions() {
        return this.storage.getAllLibraryVersions();
    }

    public StringInterner getStringInterner() {
        return this.stringInterner;
    }
}

