/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import overflowdb.EdgeLayoutInformation;

public class NodeLayoutInformation {
    public final String label;
    private final Set<String> propertyKeys;
    private final String[] allowedOutEdgeLabels;
    private final String[] allowedInEdgeLabels;
    private final Map<String, Integer> outEdgeToOffsetPosition;
    private final Map<String, Integer> inEdgeToOffsetPosition;
    private final Map<String, HashSet<String>> edgePropertyKeysByLabel;
    private final int[] edgePropertyCountByOffsetPosition;
    private final Map<LabelAndKey, Integer> edgeLabelAndKeyToStrideIndex;

    public NodeLayoutInformation(String label, Set<String> propertyKeys, List<EdgeLayoutInformation> outEdgeLayouts, List<EdgeLayoutInformation> inEdgeLayouts) {
        this.label = label;
        this.propertyKeys = propertyKeys;
        HashSet<EdgeLayoutInformation> allEdgeLayouts = new HashSet<EdgeLayoutInformation>();
        allEdgeLayouts.addAll(outEdgeLayouts);
        allEdgeLayouts.addAll(inEdgeLayouts);
        this.edgePropertyKeysByLabel = this.createEdgePropertyKeysByLabel(allEdgeLayouts);
        this.edgeLabelAndKeyToStrideIndex = this.createEdgeLabelAndKeyToStrideIndex(allEdgeLayouts);
        this.allowedOutEdgeLabels = new String[outEdgeLayouts.size()];
        this.allowedInEdgeLabels = new String[inEdgeLayouts.size()];
        int offsetPosition = 0;
        this.edgePropertyCountByOffsetPosition = new int[outEdgeLayouts.size() + inEdgeLayouts.size()];
        int i = 0;
        this.outEdgeToOffsetPosition = new HashMap<String, Integer>(outEdgeLayouts.size());
        for (EdgeLayoutInformation edgeLayout : outEdgeLayouts) {
            this.edgePropertyCountByOffsetPosition[offsetPosition] = this.edgePropertyKeysByLabel.get(edgeLayout.label).size();
            this.outEdgeToOffsetPosition.put(edgeLayout.label, offsetPosition++);
            this.allowedOutEdgeLabels[i++] = edgeLayout.label;
        }
        i = 0;
        this.inEdgeToOffsetPosition = new HashMap<String, Integer>(inEdgeLayouts.size());
        for (EdgeLayoutInformation edgeLayout : inEdgeLayouts) {
            this.edgePropertyCountByOffsetPosition[offsetPosition] = this.edgePropertyKeysByLabel.get(edgeLayout.label).size();
            this.inEdgeToOffsetPosition.put(edgeLayout.label, offsetPosition++);
            this.allowedInEdgeLabels[i++] = edgeLayout.label;
        }
    }

    private Map<String, HashSet<String>> createEdgePropertyKeysByLabel(Set<EdgeLayoutInformation> allEdgeLayouts) {
        HashMap<String, HashSet<String>> edgePropertyKeysByLabel = new HashMap<String, HashSet<String>>(allEdgeLayouts.size());
        for (EdgeLayoutInformation edgeLayout : allEdgeLayouts) {
            edgePropertyKeysByLabel.put(edgeLayout.label, new HashSet<String>(edgeLayout.propertyKeys));
        }
        return edgePropertyKeysByLabel;
    }

    private Map<LabelAndKey, Integer> createEdgeLabelAndKeyToStrideIndex(Set<EdgeLayoutInformation> allEdgeLayouts) {
        HashMap<LabelAndKey, Integer> edgeLabelAndKeyToStrideIndex = new HashMap<LabelAndKey, Integer>(allEdgeLayouts.size());
        for (EdgeLayoutInformation edgeLayout : allEdgeLayouts) {
            int strideIndex = 1;
            for (String propertyKey : this.sorted(edgeLayout.propertyKeys)) {
                edgeLabelAndKeyToStrideIndex.put(new LabelAndKey(this, edgeLayout.label, propertyKey), strideIndex++);
            }
        }
        return edgeLabelAndKeyToStrideIndex;
    }

    private Iterable<String> sorted(Set<String> propertyKeys) {
        TreeSet<String> sortedSet = new TreeSet<String>(String::compareTo);
        sortedSet.addAll(propertyKeys);
        return sortedSet;
    }

    private SortedSet<EdgeLayoutInformation> sortByLabel(List<EdgeLayoutInformation> outEdgeLayouts) {
        TreeSet<EdgeLayoutInformation> sorted = new TreeSet<EdgeLayoutInformation>(Comparator.comparing(a -> a.label));
        sorted.addAll(outEdgeLayouts);
        return sorted;
    }

    public Set<String> propertyKeys() {
        return this.propertyKeys;
    }

    public String[] allowedOutEdgeLabels() {
        return this.allowedOutEdgeLabels;
    }

    public String[] allowedInEdgeLabels() {
        return this.allowedInEdgeLabels;
    }

    public Set<String> edgePropertyKeys(String edgeLabel) {
        return this.edgePropertyKeysByLabel.get(edgeLabel);
    }

    public int numberOfDifferentAdjacentTypes() {
        return this.outEdgeToOffsetPosition.size() + this.inEdgeToOffsetPosition.size();
    }

    public Integer outEdgeToOffsetPosition(String edgeLabel) {
        return this.outEdgeToOffsetPosition.get(edgeLabel);
    }

    public Integer inEdgeToOffsetPosition(String edgeLabel) {
        return this.inEdgeToOffsetPosition.get(edgeLabel);
    }

    public int getEdgePropertyOffsetRelativeToAdjacentNodeRef(String edgeLabel, String propertyKey) {
        return this.edgeLabelAndKeyToStrideIndex.getOrDefault(new LabelAndKey(this, edgeLabel, propertyKey), -1);
    }

    public final int getEdgePropertyCountByOffsetPos(int offsetPos) {
        return this.edgePropertyCountByOffsetPosition[offsetPos];
    }

    class LabelAndKey {
        final String label;
        final String propertyKey;

        LabelAndKey(NodeLayoutInformation this$0, String label, String propertyKey) {
            this.label = label;
            this.propertyKey = propertyKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabelAndKey that = (LabelAndKey)o;
            return this.label.equals(that.label) && this.propertyKey.equals(that.propertyKey);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.propertyKey);
        }
    }
}

