/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import overflowdb.DetachedNodeData;
import overflowdb.Edge;
import overflowdb.Element;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.Property;
import overflowdb.PropertyKey;

public abstract class NodeRef<N extends NodeDb>
extends Node {
    protected final long id;
    protected final Graph graph;
    private N node;

    public NodeRef(Graph graph, N node) {
        this.graph = graph;
        this.node = node;
        this.id = ((NodeDb)node).ref.id;
    }

    public NodeRef(Graph graph, long id) {
        this.graph = graph;
        this.id = id;
        NodeRef maybeAlreadyExistent = (NodeRef)graph.node(id);
        if (maybeAlreadyExistent != null) {
            this.node = maybeAlreadyExistent.node;
        }
    }

    public boolean isSet() {
        return this.node != null;
    }

    public boolean isCleared() {
        return this.node == null;
    }

    public static void clear(NodeRef ref) {
        ref.node = null;
    }

    protected byte[] serializeWhenDirty() {
        N node = this.node;
        if (node != null && ((NodeDb)node).isDirty()) {
            try {
                return this.graph.nodeSerializer.serialize((NodeDb)node);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected void persist(byte[] data) {
        this.graph.storage.persist(this.id, data);
    }

    public final N get() {
        N ref = this.node;
        if (ref != null) {
            return ref;
        }
        try {
            return this.getSynchronized();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final synchronized N getSynchronized() throws IOException {
        N ref = this.node;
        if (ref != null) {
            return ref;
        }
        N node = this.readFromDisk();
        if (node == null) {
            throw new IllegalStateException("unable to read node from disk; id=" + this.id);
        }
        if (this.node != node) {
            throw new AssertionError((Object)("invalid state after reading node from dist; id=" + this.id));
        }
        this.graph.registerNodeRef(this);
        return node;
    }

    public final Optional<N> getOption() {
        return Optional.ofNullable(this.node);
    }

    public void setNode(N node) {
        this.node = node;
    }

    private final N readFromDisk() throws IOException {
        byte[] bytes = this.graph.storage.getSerializedNode(this.id);
        return (N)this.graph.nodeDeserializer.deserialize(bytes, this);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    protected void removeImpl() {
        ((Element)this.get()).removeInternal();
        NodeRef.clear(this);
    }

    public int hashCode() {
        long tmp = (this.id ^ this.id >>> 33) * 2063233195183692209L;
        return (int)tmp ^ (int)(tmp >>> 32);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NodeRef && this.id == ((NodeRef)obj).id;
    }

    @Override
    protected Edge addEdgeImpl(String label, Node inNode, Object ... keyValues) {
        return ((Node)this.get()).addEdgeInternal(label, inNode, keyValues);
    }

    @Override
    protected Edge addEdgeImpl(String label, Node inNode, Map<String, Object> keyValues) {
        return ((Node)this.get()).addEdgeInternal(label, inNode, keyValues);
    }

    @Override
    protected void addEdgeSilentImpl(String label, Node inNode, Object ... keyValues) {
        ((Node)this.get()).addEdgeSilentInternal(label, inNode, keyValues);
    }

    @Override
    protected void addEdgeSilentImpl(String label, Node inNode, Map<String, Object> keyValues) {
        ((Node)this.get()).addEdgeSilentInternal(label, inNode, keyValues);
    }

    @Override
    public Map<String, Object> propertiesMap() {
        return ((NodeDb)this.get()).propertiesMap();
    }

    @Override
    public Object property(String propertyKey) {
        return ((Element)this.get()).property(propertyKey);
    }

    @Override
    public <A> A property(PropertyKey<A> key) {
        return ((NodeDb)this.get()).property(key);
    }

    @Override
    public <A> Optional<A> propertyOption(PropertyKey<A> key) {
        return ((NodeDb)this.get()).propertyOption(key);
    }

    @Override
    public Optional<Object> propertyOption(String key) {
        return ((NodeDb)this.get()).propertyOption(key);
    }

    @Override
    protected <A> void setPropertyImpl(PropertyKey<A> key, A value) {
        ((Element)this.get()).setPropertyInternal(key, value);
    }

    @Override
    protected void setPropertyImpl(Property<?> property) {
        ((Element)this.get()).setPropertyInternal(property);
    }

    @Override
    protected void setPropertyImpl(String key, Object value) {
        ((Element)this.get()).setPropertyInternal(key, value);
    }

    @Override
    public Set<String> propertyKeys() {
        return ((NodeDb)this.get()).propertyKeys();
    }

    @Override
    protected void removePropertyImpl(String key) {
        ((Element)this.get()).removePropertyInternal(key);
    }

    @Override
    public Iterator<Node> out() {
        return ((NodeDb)this.get()).out();
    }

    @Override
    public Iterator<Node> out(String ... edgeLabels) {
        return ((NodeDb)this.get()).out(edgeLabels);
    }

    @Override
    public Iterator<Node> in() {
        return ((NodeDb)this.get()).in();
    }

    @Override
    public Iterator<Node> in(String ... edgeLabels) {
        return ((NodeDb)this.get()).in(edgeLabels);
    }

    @Override
    public Iterator<Node> both() {
        return ((NodeDb)this.get()).both();
    }

    @Override
    public Iterator<Node> both(String ... edgeLabels) {
        return ((NodeDb)this.get()).both(edgeLabels);
    }

    @Override
    public Iterator<Edge> outE() {
        return ((NodeDb)this.get()).outE();
    }

    @Override
    public Iterator<Edge> outE(String ... edgeLabels) {
        return ((NodeDb)this.get()).outE(edgeLabels);
    }

    @Override
    public Iterator<Edge> inE() {
        return ((NodeDb)this.get()).inE();
    }

    @Override
    public Iterator<Edge> inE(String ... edgeLabels) {
        return ((NodeDb)this.get()).inE(edgeLabels);
    }

    @Override
    public Iterator<Edge> bothE() {
        return ((NodeDb)this.get()).bothE();
    }

    @Override
    public Iterator<Edge> bothE(String ... edgeLabels) {
        return ((NodeDb)this.get()).bothE(edgeLabels);
    }

    @Override
    protected void _initializeFromDetached(DetachedNodeData data, Function<DetachedNodeData, Node> mapper) {
        ((Node)this.get())._initializeFromDetached(data, mapper);
    }

    public String toString() {
        return this.getClass().getName() + "[label=" + this.label() + "; id=" + this.id + "]";
    }
}

