/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import overflowdb.NodeRef;
import overflowdb.storage.NodesWriter;
import overflowdb.storage.OdbStorage;
import overflowdb.util.NamedThreadFactory;

public class ReferenceManager
implements AutoCloseable {
    public final int releaseCount = 100000;
    private AtomicInteger totalReleaseCount = new AtomicInteger(0);
    private final ExecutorService executorService;
    private final boolean shutdownExecutorOnClose;
    private int clearingProcessCount = 0;
    private final Object backPressureSyncObject = new Object();
    private final OdbStorage storage;
    private final NodesWriter nodesWriter;
    private final List<NodeRef> clearableRefs = Collections.synchronizedList(new ArrayList());

    public ReferenceManager(OdbStorage storage, NodesWriter nodesWriter) {
        this.storage = storage;
        this.nodesWriter = nodesWriter;
        this.executorService = Executors.newSingleThreadExecutor(new NamedThreadFactory("overflowdb-reference-manager"));
        this.shutdownExecutorOnClose = true;
    }

    public ReferenceManager(OdbStorage storage, NodesWriter nodesWriter, ExecutorService executorService) {
        this.storage = storage;
        this.nodesWriter = nodesWriter;
        this.executorService = executorService;
        this.shutdownExecutorOnClose = false;
    }

    public void registerRef(NodeRef ref) {
        this.clearableRefs.add(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyBackpressureMaybe() {
        Object object = this.backPressureSyncObject;
        synchronized (object) {
            while (this.clearingProcessCount > 0) {
                try {
                    this.backPressureSyncObject.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void syncClearReferences(int releaseCount) {
        List<NodeRef> refsToClear = this.collectRefsToClear(releaseCount);
        if (!refsToClear.isEmpty()) {
            this.safelyClearReferences(refsToClear);
        }
    }

    private List<NodeRef> collectRefsToClear(int releaseCount) {
        ArrayList<NodeRef> refsToClear = new ArrayList<NodeRef>(releaseCount);
        while (releaseCount > 0 && !this.clearableRefs.isEmpty()) {
            NodeRef ref = this.clearableRefs.remove(0);
            if (ref != null) {
                refsToClear.add(ref);
            }
            --releaseCount;
        }
        return refsToClear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyClearReferences(List<NodeRef> refsToClear) {
        Object object;
        try {
            object = this.backPressureSyncObject;
            synchronized (object) {
                ++this.clearingProcessCount;
            }
            this.nodesWriter.writeAndClearBatched(refsToClear.spliterator(), refsToClear.size());
            this.storage.flush();
        }
        catch (Exception exception) {
            Object object2 = this.backPressureSyncObject;
            synchronized (object2) {
                --this.clearingProcessCount;
                if (this.clearingProcessCount == 0) {
                    this.backPressureSyncObject.notifyAll();
                }
            }
        }
        finally {
            object = this.backPressureSyncObject;
            synchronized (object) {
                --this.clearingProcessCount;
                if (this.clearingProcessCount == 0) {
                    this.backPressureSyncObject.notifyAll();
                }
            }
        }
    }

    public void clearAllReferences() {
        this.nodesWriter.writeAndClearBatched(this.clearableRefs.spliterator(), this.clearableRefs.size());
    }

    @Override
    public void close() {
        if (this.shutdownExecutorOnClose) {
            this.executorService.shutdown();
        }
    }
}

