/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.Value;
import overflowdb.Direction;
import overflowdb.Graph;
import overflowdb.NodeDb;
import overflowdb.NodeFactory;
import overflowdb.NodeRef;
import overflowdb.storage.BookKeeper;
import overflowdb.storage.OdbStorage;
import overflowdb.storage.ValueTypes;
import overflowdb.util.PropertyHelper;
import overflowdb.util.StringInterner;

public class NodeDeserializer
extends BookKeeper {
    protected final Graph graph;
    private final Map<String, NodeFactory> nodeFactoryByLabel;
    private final OdbStorage storage;
    private final StringInterner stringInterner;

    public NodeDeserializer(Graph graph, Map<String, NodeFactory> nodeFactoryByLabel, boolean statsEnabled, OdbStorage storage) {
        super(statsEnabled);
        this.graph = graph;
        this.stringInterner = graph.getStringInterner();
        this.nodeFactoryByLabel = nodeFactoryByLabel;
        this.storage = storage;
    }

    public final NodeDb deserialize(byte[] bytes) throws IOException {
        return this.deserialize(bytes, null);
    }

    public final NodeDb deserialize(byte[] bytes, NodeRef<?> ref) throws IOException {
        long startTimeNanos = this.getStartTimeNanos();
        if (null == bytes) {
            return null;
        }
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
        long id = unpacker.unpackLong();
        int labelStringId = unpacker.unpackInt();
        Object[] properties = this.unpackProperties(unpacker);
        String label = this.storage.reverseLookupStringToIntMapping(labelStringId);
        Object node = this.getNodeFactory(label).createNode(this.graph, id, ref);
        PropertyHelper.attachProperties(node, properties);
        this.deserializeEdges(unpacker, (NodeDb)node, Direction.OUT);
        this.deserializeEdges(unpacker, (NodeDb)node, Direction.IN);
        ((NodeDb)node).markAsClean();
        if (this.statsEnabled) {
            this.recordStatistics(startTimeNanos);
        }
        return node;
    }

    private void deserializeEdges(MessageUnpacker unpacker, NodeDb node, Direction direction) throws IOException {
        int edgeTypesCount = unpacker.unpackInt();
        for (int edgeTypeIdx = 0; edgeTypeIdx < edgeTypesCount; ++edgeTypeIdx) {
            int edgeLabelId = unpacker.unpackInt();
            String edgeLabel = this.storage.reverseLookupStringToIntMapping(edgeLabelId);
            int edgeCount = unpacker.unpackInt();
            for (int edgeIdx = 0; edgeIdx < edgeCount; ++edgeIdx) {
                long adjacentNodeId = unpacker.unpackLong();
                NodeRef adjacentNode = (NodeRef)this.graph.node(adjacentNodeId);
                Object[] edgeProperties = this.unpackProperties(unpacker);
                node.storeAdjacentNode(direction, edgeLabel, adjacentNode, edgeProperties);
            }
        }
    }

    public final NodeRef deserializeRef(byte[] bytes) throws IOException {
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);){
            long id = unpacker.unpackLong();
            int labelStringId = unpacker.unpackInt();
            String label = this.storage.reverseLookupStringToIntMapping(labelStringId);
            NodeRef nodeRef = this.createNodeRef(id, label);
            return nodeRef;
        }
    }

    private final Object[] unpackProperties(MessageUnpacker unpacker) throws IOException {
        int propertyCount = unpacker.unpackMapHeader();
        Object[] res = new Object[propertyCount * 2];
        int resIdx = 0;
        for (int propertyIdx = 0; propertyIdx < propertyCount; ++propertyIdx) {
            int keyId = unpacker.unpackInt();
            String key = this.storage.reverseLookupStringToIntMapping(keyId);
            ImmutableValue unpackedValue = unpacker.unpackValue();
            Object unpackedProperty = this.unpackValue((ArrayValue)unpackedValue.asArrayValue());
            res[resIdx++] = key;
            res[resIdx++] = unpackedProperty;
        }
        return res;
    }

    private final Object unpackValue(ArrayValue packedValueAndType) {
        Iterator iter = packedValueAndType.iterator();
        byte valueTypeId = ((Value)iter.next()).asIntegerValue().asByte();
        Value value = (Value)iter.next();
        switch (ValueTypes.lookup(valueTypeId)) {
            case UNKNOWN: {
                return null;
            }
            case NODE_REF: {
                long id = value.asIntegerValue().asLong();
                return this.graph.node(id);
            }
            case BOOLEAN: {
                return value.asBooleanValue().getBoolean();
            }
            case STRING: {
                return this.stringInterner.intern(value.asStringValue().asString());
            }
            case BYTE: {
                return value.asIntegerValue().asByte();
            }
            case SHORT: {
                return value.asIntegerValue().asShort();
            }
            case INTEGER: {
                return value.asIntegerValue().asInt();
            }
            case LONG: {
                return value.asIntegerValue().asLong();
            }
            case FLOAT: {
                return Float.valueOf(value.asFloatValue().toFloat());
            }
            case DOUBLE: {
                return value.asFloatValue().toDouble();
            }
            case LIST: {
                return this.deserializeList(value.asArrayValue());
            }
            case CHARACTER: {
                return Character.valueOf((char)value.asIntegerValue().asInt());
            }
            case ARRAY_BYTE: {
                return this.deserializeArrayByte(value.asArrayValue());
            }
            case ARRAY_SHORT: {
                return this.deserializeArrayShort(value.asArrayValue());
            }
            case ARRAY_INT: {
                return this.deserializeArrayInt(value.asArrayValue());
            }
            case ARRAY_LONG: {
                return this.deserializeArrayLong(value.asArrayValue());
            }
            case ARRAY_FLOAT: {
                return this.deserializeArrayFloat(value.asArrayValue());
            }
            case ARRAY_DOUBLE: {
                return this.deserializeArrayDouble(value.asArrayValue());
            }
            case ARRAY_CHAR: {
                return this.deserializeArrayChar(value.asArrayValue());
            }
            case ARRAY_BOOL: {
                return this.deserializeArrayBoolean(value.asArrayValue());
            }
            case ARRAY_OBJECT: {
                return this.deserializeArrayObject(value.asArrayValue());
            }
        }
        throw new UnsupportedOperationException("unknown valueTypeId=`" + valueTypeId);
    }

    protected final NodeRef createNodeRef(long id, String label) {
        return this.getNodeFactory(label).createNodeRef(this.graph, id);
    }

    private final NodeFactory getNodeFactory(String label) {
        if (!this.nodeFactoryByLabel.containsKey(label)) {
            throw new AssertionError((Object)String.format("nodeFactory not found for label=%s", label));
        }
        return this.nodeFactoryByLabel.get(label);
    }

    private Object deserializeList(ArrayValue arrayValue) {
        ArrayList<Object> deserializedList = new ArrayList<Object>(arrayValue.size());
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedList.add(this.unpackValue(((Value)valueIterator.next()).asArrayValue()));
        }
        return deserializedList;
    }

    private byte[] deserializeArrayByte(ArrayValue arrayValue) {
        byte[] deserializedArray = new byte[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = ((Value)valueIterator.next()).asIntegerValue().asByte();
        }
        return deserializedArray;
    }

    private short[] deserializeArrayShort(ArrayValue arrayValue) {
        short[] deserializedArray = new short[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = ((Value)valueIterator.next()).asIntegerValue().asShort();
        }
        return deserializedArray;
    }

    private int[] deserializeArrayInt(ArrayValue arrayValue) {
        int[] deserializedArray = new int[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = ((Value)valueIterator.next()).asIntegerValue().asInt();
        }
        return deserializedArray;
    }

    private long[] deserializeArrayLong(ArrayValue arrayValue) {
        long[] deserializedArray = new long[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = ((Value)valueIterator.next()).asIntegerValue().asLong();
        }
        return deserializedArray;
    }

    private float[] deserializeArrayFloat(ArrayValue arrayValue) {
        float[] deserializedArray = new float[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = ((Value)valueIterator.next()).asFloatValue().toFloat();
        }
        return deserializedArray;
    }

    private double[] deserializeArrayDouble(ArrayValue arrayValue) {
        double[] deserializedArray = new double[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = ((Value)valueIterator.next()).asFloatValue().toDouble();
        }
        return deserializedArray;
    }

    private char[] deserializeArrayChar(ArrayValue arrayValue) {
        char[] deserializedArray = new char[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = (char)((Value)valueIterator.next()).asIntegerValue().asInt();
        }
        return deserializedArray;
    }

    private boolean[] deserializeArrayBoolean(ArrayValue arrayValue) {
        boolean[] deserializedArray = new boolean[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = ((Value)valueIterator.next()).asBooleanValue().getBoolean();
        }
        return deserializedArray;
    }

    private Object[] deserializeArrayObject(ArrayValue arrayValue) {
        Object[] deserializedArray = new Object[arrayValue.size()];
        int idx = 0;
        Iterator valueIterator = arrayValue.iterator();
        while (valueIterator.hasNext()) {
            deserializedArray[idx++] = this.unpackValue(((Value)valueIterator.next()).asArrayValue());
        }
        return deserializedArray;
    }
}

