/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import gnu.trove.map.TLongIntMap;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import overflowdb.Node;
import overflowdb.storage.NodesWriter;

public class NodesList {
    private Node[] nodes;
    private int size = 0;
    private TLongIntMap nodeIndexByNodeId;
    private TMap<String, ArrayList<Node>> nodesByLabel;
    private final BitSet emptySlots;
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public NodesList() {
        this(10000);
    }

    public NodesList(int initialCapacity) {
        this.nodes = new Node[initialCapacity];
        this.emptySlots = new BitSet(initialCapacity);
        this.nodeIndexByNodeId = new TLongIntHashMap(initialCapacity);
        this.nodesByLabel = new THashMap(10);
    }

    public synchronized void add(Node node) {
        this.verifyUniqueId(node);
        int index = this.tryClaimEmptySlot();
        if (index == -1) {
            index = this.size;
            this.ensureCapacity(this.size + 1);
        }
        this.nodes[index] = node;
        this.nodeIndexByNodeId.put(node.id(), index);
        if (this.nodesByLabel != null) {
            this.nodesByLabel(node.label()).add(node);
        }
        ++this.size;
    }

    private void verifyUniqueId(Node node) {
        if (this.nodeIndexByNodeId.containsKey(node.id())) {
            Node existingNode = this.nodeById(node.id());
            throw new AssertionError((Object)("different Node with same id already exists in this NodesList: " + String.valueOf(existingNode)));
        }
    }

    private int tryClaimEmptySlot() {
        int nextEmptySlot = this.emptySlots.nextSetBit(0);
        if (nextEmptySlot != -1) {
            this.emptySlots.clear(nextEmptySlot);
        }
        return nextEmptySlot;
    }

    public boolean contains(long id) {
        return this.nodeIndexByNodeId.containsKey(id);
    }

    public Node nodeById(long id) {
        if (this.nodeIndexByNodeId.containsKey(id)) {
            return this.nodes[this.nodeIndexByNodeId.get(id)];
        }
        return null;
    }

    public synchronized void remove(Node node) {
        int index = this.nodeIndexByNodeId.remove(node.id());
        this.nodes[index] = null;
        this.emptySlots.set(index);
        this.nodesByLabel = null;
        --this.size;
        this.compactMaybe();
    }

    public int size() {
        return this.size;
    }

    private TMap<String, ArrayList<Node>> getNodesByLabel() {
        TMap<String, ArrayList<Node>> nodesByLabel = this.nodesByLabel;
        if (nodesByLabel != null) {
            return nodesByLabel;
        }
        this.initialiseNodesByLabel();
        return this.getNodesByLabel();
    }

    private synchronized void initialiseNodesByLabel() {
        if (this.nodesByLabel == null) {
            THashMap tmp = new THashMap();
            for (Node node : this.nodes) {
                if (node == null) continue;
                ArrayList<Node> nodelist = (ArrayList<Node>)tmp.get((Object)node.label());
                if (nodelist == null) {
                    nodelist = new ArrayList<Node>();
                    tmp.put((Object)node.label(), nodelist);
                }
                nodelist.add(node);
            }
            this.nodesByLabel = tmp;
        }
    }

    public ArrayList<Node> nodesByLabel(String label) {
        TMap<String, ArrayList<Node>> nodesByLabel = this.getNodesByLabel();
        ArrayList nodelist = (ArrayList)nodesByLabel.get((Object)label);
        if (nodelist == null) {
            nodelist = new ArrayList();
            nodesByLabel.put((Object)label, nodelist);
        }
        return nodelist;
    }

    public Set<String> nodeLabels() {
        TMap<String, ArrayList<Node>> nodesByLabel = this.getNodesByLabel();
        HashSet<String> ret = new HashSet<String>(nodesByLabel.size());
        nodesByLabel.entrySet().forEach(entry -> {
            if (!((ArrayList)entry.getValue()).isEmpty()) {
                ret.add((String)entry.getKey());
            }
        });
        return ret;
    }

    public synchronized Iterator<Node> iterator() {
        return new NodesIterator(Arrays.copyOf(this.nodes, this.nodes.length));
    }

    private void ensureCapacity(int minCapacity) {
        if (this.nodes.length < minCapacity) {
            this.grow(minCapacity);
        }
    }

    private void compactMaybe() {
        int emptyCount = this.emptySlots.cardinality();
        if (emptyCount > 10000 && emptyCount * 100 / this.nodes.length >= 30) {
            this.compact();
        }
    }

    synchronized void compact() {
        ArrayList<Node> newNodes = new ArrayList<Node>(this.size);
        Iterator<Node> iter = this.iterator();
        while (iter.hasNext()) {
            newNodes.add(iter.next());
        }
        this.nodes = newNodes.toArray(new Node[this.size]);
        this.emptySlots.clear();
        this.nodeIndexByNodeId = new TLongIntHashMap(this.nodes.length);
        for (int idx = 0; idx < this.nodes.length; ++idx) {
            Node node = this.nodes[idx];
            this.nodeIndexByNodeId.put(node.id(), idx);
        }
    }

    private synchronized void grow(int minCapacity) {
        int oldCapacity = this.nodes.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = NodesList.hugeCapacity(minCapacity);
        }
        this.nodes = Arrays.copyOf(this.nodes, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    protected int _elementDataSize() {
        return this.nodes.length;
    }

    public int cardinality(String label) {
        TMap<String, ArrayList<Node>> nodesByLabel = this.getNodesByLabel();
        if (nodesByLabel.containsKey((Object)label)) {
            return ((ArrayList)nodesByLabel.get((Object)label)).size();
        }
        return 0;
    }

    public synchronized void persistAll(NodesWriter nodesWriter) {
        nodesWriter.writeAndClearBatched(Arrays.spliterator(this.nodes), this.nodes.length);
    }

    public static class NodesIterator
    implements Iterator<Node> {
        final Node[] nodes;
        int idx = 0;
        Node nextPeeked = null;

        public NodesIterator(Node[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean hasNext() {
            while (this.nextPeeked == null && this.idx < this.nodes.length) {
                this.nextPeeked = this.nodes[this.idx++];
            }
            return this.nextPeeked != null;
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Node ret = this.nextPeeked;
            this.nextPeeked = null;
            return ret;
        }
    }
}

