/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.dot;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import overflowdb.Edge;
import overflowdb.Node;
import overflowdb.formats.ExportResult;
import overflowdb.formats.ExportResult$;
import overflowdb.formats.Exporter;
import overflowdb.formats.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public final class DotExporter$
implements Exporter,
Serializable {
    public static final DotExporter$ MODULE$ = new DotExporter$();

    private DotExporter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DotExporter$.class);
    }

    @Override
    public String defaultFileExtension() {
        return "dot";
    }

    @Override
    public ExportResult runExport(IterableOnce<Node> nodes, IterableOnce<Edge> edges, Path outputFile) {
        Path outFile = package$.MODULE$.resolveOutputFileSingle(outputFile, "export." + this.defaultFileExtension());
        IntRef nodeCount = IntRef.create((int)0);
        IntRef edgeCount = IntRef.create((int)0);
        Using$.MODULE$.resource((Object)Files.newBufferedWriter(outFile, new OpenOption[0]), (Function1)(JProcedure1 & Serializable)writer -> {
            this.writeLine$1((BufferedWriter)writer, "digraph {");
            nodes.iterator().foreach((Function1)(JProcedure1 & Serializable)node -> {
                ++nodeCount$2.elem;
                this.writeLine$1((BufferedWriter)writer, this.node2Dot((Node)node));
            });
            edges.iterator().foreach((Function1)(JProcedure1 & Serializable)edge -> {
                ++edgeCount$2.elem;
                this.writeLine$1((BufferedWriter)writer, this.edge2Dot((Edge)edge));
            });
            this.writeLine$1((BufferedWriter)writer, "}");
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return ExportResult$.MODULE$.apply(nodeCount.elem, edgeCount.elem, (Seq<Path>)((Seq)((SeqOps)new .colon.colon((Object)outFile, (List)Nil$.MODULE$))), (Option<String>)None$.MODULE$);
    }

    private String node2Dot(Node node) {
        return "  " + node.id() + " [label=" + node.label() + " " + this.properties2Dot(node.propertiesMap()) + "]";
    }

    private String edge2Dot(Edge edge) {
        return "  " + edge.outNode().id() + " -> " + edge.inNode().id() + " [label=" + edge.label() + " " + this.properties2Dot(edge.propertiesMap()) + "]";
    }

    private String properties2Dot(Map<String, Object> properties) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(properties).asScala().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return key + "=" + MODULE$.encodePropertyValue(value);
            }
            throw new MatchError((Object)tuple2);
        })).mkString(" ");
    }

    private String encodePropertyValue(Object value) {
        Object object = value;
        if (object instanceof String) {
            String value2 = (String)object;
            String escaped = value2.replace("\\", "\\\\").replace("\"", "\\\"");
            return "\"" + escaped + "\"";
        }
        Object list = object;
        if (package$.MODULE$.iterableForList().isDefinedAt(list)) {
            String values = ((IterableOnceOps)package$.MODULE$.iterableForList().apply(list)).mkString(";");
            return "\"" + values + "\"";
        }
        Object value3 = object;
        return value3.toString();
    }

    private final void writeLine$1(BufferedWriter writer$1, String line) {
        writer$1.write(line);
        writer$1.newLine();
    }
}

