/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.graphson;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import overflowdb.Edge;
import overflowdb.Element;
import overflowdb.Node;
import overflowdb.NodeRef;
import overflowdb.formats.ExportResult;
import overflowdb.formats.ExportResult$;
import overflowdb.formats.Exporter;
import overflowdb.formats.graphson.GraphSONProtocol$;
import overflowdb.formats.graphson.package;
import overflowdb.formats.graphson.package$BooleanValue$;
import overflowdb.formats.graphson.package$DoubleValue$;
import overflowdb.formats.graphson.package$Edge$;
import overflowdb.formats.graphson.package$FloatValue$;
import overflowdb.formats.graphson.package$GraphSON$;
import overflowdb.formats.graphson.package$GraphSONElements$;
import overflowdb.formats.graphson.package$IntValue$;
import overflowdb.formats.graphson.package$ListValue$;
import overflowdb.formats.graphson.package$LongValue$;
import overflowdb.formats.graphson.package$NodeIdValue$;
import overflowdb.formats.graphson.package$Property$;
import overflowdb.formats.graphson.package$StringValue$;
import overflowdb.formats.graphson.package$Vertex$;
import overflowdb.formats.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import spray.json.JsValue;

public final class GraphSONExporter$
implements Exporter,
Serializable {
    public static final GraphSONExporter$ MODULE$ = new GraphSONExporter$();

    private GraphSONExporter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphSONExporter$.class);
    }

    @Override
    public String defaultFileExtension() {
        return "json";
    }

    @Override
    public ExportResult runExport(IterableOnce<Node> nodes, IterableOnce<Edge> edges, Path outputFile) {
        Path outFile = package$.MODULE$.resolveOutputFileSingle(outputFile, "export." + this.defaultFileExtension());
        AtomicInteger propertyId = new AtomicInteger(0);
        AtomicInteger edgeId = new AtomicInteger(0);
        Seq nodeEntries = nodes.iterator().map((Function1 & Serializable)node -> package$Vertex$.MODULE$.apply(package$LongValue$.MODULE$.apply(node.id(), package$LongValue$.MODULE$.$lessinit$greater$default$2()), node.label(), MODULE$.propertyEntry((Element)node, propertyId, "g:VertexProperty"), package$Vertex$.MODULE$.$lessinit$greater$default$4())).toSeq();
        Seq edgeEntries = edges.iterator().map((Function1 & Serializable)edge -> {
            NodeRef inNode = edge.inNode();
            NodeRef outNode = edge.outNode();
            return package$Edge$.MODULE$.apply(package$LongValue$.MODULE$.apply(Int$.MODULE$.int2long(edgeId.getAndIncrement()), package$LongValue$.MODULE$.$lessinit$greater$default$2()), edge.label(), inNode.label(), outNode.label(), package$LongValue$.MODULE$.apply(inNode.id(), package$LongValue$.MODULE$.$lessinit$greater$default$2()), package$LongValue$.MODULE$.apply(outNode.id(), package$LongValue$.MODULE$.$lessinit$greater$default$2()), MODULE$.propertyEntry((Element)edge, propertyId, "g:Property"), package$Edge$.MODULE$.$lessinit$greater$default$8());
        }).toSeq();
        package.GraphSON graphSON = package$GraphSON$.MODULE$.apply(package$GraphSONElements$.MODULE$.apply((Seq<package.Vertex>)nodeEntries, (Seq<package.Edge>)edgeEntries), package$GraphSON$.MODULE$.$lessinit$greater$default$2());
        JsValue json = spray.json.package$.MODULE$.enrichAny((Object)graphSON).toJson(GraphSONProtocol$.MODULE$.graphSONFormat());
        package$.MODULE$.writeFile(outFile, json.prettyPrint());
        return ExportResult$.MODULE$.apply(nodeEntries.size(), edgeEntries.size(), (Seq<Path>)((Seq)((SeqOps)new .colon.colon((Object)outFile, (List)Nil$.MODULE$))), (Option<String>)Option$.MODULE$.empty());
    }

    public Map<String, package.Property> propertyEntry(Element element, AtomicInteger propertyId, String propertyType) {
        return CollectionConverters$.MODULE$.MapHasAsScala(element.propertiesMap()).asScala().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String propertyName = (String)tuple2._1();
                Object propertyValue = tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)propertyName);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$Property$.MODULE$.apply(package$LongValue$.MODULE$.apply(Int$.MODULE$.int2long(propertyId.getAndIncrement()), package$LongValue$.MODULE$.$lessinit$greater$default$2()), MODULE$.valueEntry(propertyValue), propertyType));
            }
            throw new MatchError((Object)tuple2);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public package.PropertyValue valueEntry(Object propertyValue2) {
        package.PropertyValue propertyValue3;
        Object object = propertyValue2;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object x = object;
            Object object2 = Predef$.MODULE$.genericArrayOps(x);
            propertyValue3 = package$ListValue$.MODULE$.apply((package.PropertyValue[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)propertyValue -> MODULE$.valueEntry(propertyValue), ClassTag$.MODULE$.apply(package.PropertyValue.class)), package$ListValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof Iterable) {
            Iterable x = (Iterable)object;
            propertyValue3 = package$ListValue$.MODULE$.apply((package.PropertyValue[])((IterableOnceOps)x.map((Function1 & Serializable)propertyValue -> MODULE$.valueEntry(propertyValue))).toArray(ClassTag$.MODULE$.apply(package.PropertyValue.class)), package$ListValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof IterableOnce) {
            IterableOnce x = (IterableOnce)object;
            propertyValue3 = package$ListValue$.MODULE$.apply((package.PropertyValue[])x.iterator().map((Function1 & Serializable)propertyValue -> MODULE$.valueEntry(propertyValue)).toArray(ClassTag$.MODULE$.apply(package.PropertyValue.class)), package$ListValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof java.lang.Iterable) {
            java.lang.Iterable x = (java.lang.Iterable)object;
            propertyValue3 = package$ListValue$.MODULE$.apply((package.PropertyValue[])((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(x).asScala().map((Function1 & Serializable)propertyValue -> MODULE$.valueEntry(propertyValue))).toArray(ClassTag$.MODULE$.apply(package.PropertyValue.class)), package$ListValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof Boolean) {
            boolean x = BoxesRunTime.unboxToBoolean((Object)object);
            propertyValue3 = package$BooleanValue$.MODULE$.apply(x, package$BooleanValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof String) {
            String x = (String)object;
            propertyValue3 = package$StringValue$.MODULE$.apply(x, package$StringValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof Double) {
            double x = BoxesRunTime.unboxToDouble((Object)object);
            propertyValue3 = package$DoubleValue$.MODULE$.apply(x, package$DoubleValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof Float) {
            float x = BoxesRunTime.unboxToFloat((Object)object);
            propertyValue3 = package$FloatValue$.MODULE$.apply(x, package$FloatValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof Integer) {
            int x = BoxesRunTime.unboxToInt((Object)object);
            propertyValue3 = package$IntValue$.MODULE$.apply(x, package$IntValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof Long) {
            long x = BoxesRunTime.unboxToLong((Object)object);
            propertyValue3 = package$LongValue$.MODULE$.apply(x, package$LongValue$.MODULE$.$lessinit$greater$default$2());
        } else if (object instanceof Node) {
            Node x = (Node)object;
            propertyValue3 = package$NodeIdValue$.MODULE$.apply(x.id(), package$NodeIdValue$.MODULE$.$lessinit$greater$default$2());
        } else {
            throw new MatchError(object);
        }
        return propertyValue3;
    }
}

