/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.graphson;

import java.io.Serializable;
import java.nio.file.Path;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.formats.Importer;
import overflowdb.formats.graphson.GraphSONProtocol$;
import overflowdb.formats.graphson.package;
import overflowdb.formats.graphson.package$ListValue$;
import overflowdb.formats.graphson.package$NodeIdValue$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public final class GraphSONImporter$
implements Importer,
Serializable {
    public static final GraphSONImporter$ MODULE$ = new GraphSONImporter$();

    private GraphSONImporter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphSONImporter$.class);
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        if (inputFiles.size() != 1) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("input must be exactly one file, but got " + inputFiles.size()));
        }
        Using$.MODULE$.resource((Object)Source$.MODULE$.fromFile(((Path)inputFiles.head()).toFile(), Codec$.MODULE$.fallbackSystemCodec()), (Function1)(JProcedure1 & Serializable)source -> {
            package.GraphSON graphSON = (package.GraphSON)spray.json.package$.MODULE$.enrichString(source.mkString()).parseJson().convertTo(GraphSONProtocol$.MODULE$.graphSONFormat());
            graphSON.$atvalue().vertices().foreach((Function1)(JProcedure1 & Serializable)n -> MODULE$.addNode((package.Vertex)n, graph));
            graphSON.$atvalue().edges().foreach((Function1)(JProcedure1 & Serializable)e -> MODULE$.addEdge((package.Edge)e, graph));
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private void addNode(package.Vertex n, Graph graph) {
        graph.addNode(n.id().$atvalue(), n.label(), (Object[])this.flattenProperties(n.properties(), graph));
    }

    private Object flattenProperties(Map<String, package.Property> m, Graph graph) {
        return ((IterableOnceOps)m.view().mapValues((Function1 & Serializable)v -> {
            package.PropertyValue propertyValue = v.$atvalue();
            if (propertyValue instanceof package.ListValue) {
                package.ListValue listValue = package$ListValue$.MODULE$.unapply((package.ListValue)propertyValue);
                Object[] objectArray = listValue._1();
                String string = listValue._2();
                Object[] value = objectArray;
                Object object = Predef$.MODULE$.refArrayOps(value);
                return ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.$atvalue(), ClassTag$.MODULE$.Any());
            }
            if (propertyValue instanceof package.NodeIdValue) {
                package.NodeIdValue nodeIdValue = package$NodeIdValue$.MODULE$.unapply((package.NodeIdValue)propertyValue);
                long l = nodeIdValue._1();
                String string = nodeIdValue._2();
                long value = l;
                return graph.node(value);
            }
            package.PropertyValue x = propertyValue;
            return x.$atvalue();
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.Any());
    }

    private void addEdge(package.Edge e, Graph graph) {
        Node src = graph.node(e.outV().$atvalue());
        Node tgt = graph.node(e.inV().$atvalue());
        src.addEdge(e.label(), tgt, (Object[])this.flattenProperties(e.properties(), graph));
    }
}

