/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.neo4jcsv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVFormat$;
import com.github.tototoshi.csv.CSVWriter;
import com.github.tototoshi.csv.CSVWriter$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import overflowdb.Edge;
import overflowdb.Node;
import overflowdb.formats.ExportResult;
import overflowdb.formats.ExportResult$;
import overflowdb.formats.Exporter;
import overflowdb.formats.neo4jcsv.ColumnDefinitions;
import overflowdb.formats.neo4jcsv.Neo4jCsvExporter;
import overflowdb.formats.neo4jcsv.Neo4jCsvExporter$CountAndFiles$;
import overflowdb.formats.neo4jcsv.Neo4jCsvExporter$EdgeFilesContext$;
import overflowdb.formats.neo4jcsv.package$;
import overflowdb.formats.neo4jcsv.package$ColumnType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public final class Neo4jCsvExporter$
implements Exporter,
Serializable {
    private static final Neo4jCsvExporter$EdgeFilesContext$ EdgeFilesContext;
    public static final Neo4jCsvExporter$CountAndFiles$ CountAndFiles;
    public static final Neo4jCsvExporter$ MODULE$;

    private Neo4jCsvExporter$() {
    }

    static {
        MODULE$ = new Neo4jCsvExporter$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Neo4jCsvExporter$.class);
    }

    @Override
    public String defaultFileExtension() {
        return "csv";
    }

    @Override
    public ExportResult runExport(IterableOnce<Node> nodes, IterableOnce<Edge> edges, Path outputRootDirectory) {
        Map nodesByLabel = (Map)nodes.iterator().toSeq().groupBy((Function1 & Serializable)_$1 -> _$1.label()).filter((Function1 & Serializable)_$2 -> ((IterableOnceOps)_$2._2()).nonEmpty());
        Neo4jCsvExporter.CountAndFiles countAndFiles = (Neo4jCsvExporter.CountAndFiles)((IterableOnceOps)nodesByLabel.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                Seq nodes = (Seq)tuple2._2();
                return MODULE$.exportNodes((IterableOnce<Node>)nodes, label, outputRootDirectory);
            }
            throw new MatchError((Object)tuple2);
        })).reduce((Function2 & Serializable)(_$3, _$4) -> _$3.plus((Neo4jCsvExporter.CountAndFiles)_$4));
        if (countAndFiles == null) {
            throw new MatchError((Object)countAndFiles);
        }
        Neo4jCsvExporter.CountAndFiles countAndFiles2 = Neo4jCsvExporter$CountAndFiles$.MODULE$.unapply(countAndFiles);
        int n = countAndFiles2._1();
        Seq<Path> seq = countAndFiles2._2();
        int nodeCount = n;
        Seq<Path> nodeFiles = seq;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nodeCount), nodeFiles);
        int nodeCount2 = BoxesRunTime.unboxToInt((Object)tuple2._1());
        Seq nodeFiles2 = (Seq)tuple2._2();
        Neo4jCsvExporter.CountAndFiles countAndFiles3 = this.exportEdges(edges, outputRootDirectory);
        if (countAndFiles3 == null) {
            throw new MatchError((Object)countAndFiles3);
        }
        Neo4jCsvExporter.CountAndFiles countAndFiles4 = Neo4jCsvExporter$CountAndFiles$.MODULE$.unapply(countAndFiles3);
        int n2 = countAndFiles4._1();
        Seq<Path> seq2 = countAndFiles4._2();
        int edgeCount = n2;
        Seq<Path> edgeFiles = seq2;
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)edgeCount), edgeFiles);
        int edgeCount2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        Seq edgeFiles2 = (Seq)tuple22._2();
        Path outputRootAbsolute = outputRootDirectory.toAbsolutePath();
        return ExportResult$.MODULE$.apply(nodeCount2, edgeCount2, (Seq<Path>)((Seq)nodeFiles2.$plus$plus((IterableOnce)edgeFiles2)), (Option<String>)Option$.MODULE$.apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Instructions on how to import the exported files into neo4j:\n           |Prerequisite: ensure you have neo4j community server running (enterprise and desktop may work too)\n           |e.g. download from https://neo4j.com/download-center/#community and start via `bin/neo4j console`\n           |\n           |Then, in a new terminal:\n           |```\n           |cd <neo4j_root>\n           |\n           |# if you have a fresh instance, you must first change the initial password\n           |bin/cypher-shell -u neo4j -p neo4j\n           |# exit the cypher shell\n           |\n           |# copy the data files to the `import` directory, where neo4j will find them\n           |cp " + outputRootAbsolute + "/*" + package$.MODULE$.DataFileSuffix() + ".csv import\n           |\n           |find " + outputRootAbsolute + " -name 'nodes_*_cypher.csv' -exec bin/cypher-shell -u neo4j -p <password> --file {} \\;\n           |find " + outputRootAbsolute + " -name 'edges_*_cypher.csv' -exec bin/cypher-shell -u neo4j -p <password> --file {} \\;\n           |```\n           |"))));
    }

    private Neo4jCsvExporter.CountAndFiles exportNodes(IterableOnce<Node> nodes, String label, Path outputRootDirectory) {
        Path dataFile = outputRootDirectory.resolve("nodes_" + label + package$.MODULE$.DataFileSuffix() + ".csv");
        Path headerFile = outputRootDirectory.resolve("nodes_" + label + package$.MODULE$.HeaderFileSuffix() + ".csv");
        Path cypherFile = outputRootDirectory.resolve("nodes_" + label + package$.MODULE$.CypherFileSuffix() + ".csv");
        ObjectRef columnDefinitions = ObjectRef.create(null);
        IntRef nodeCount = IntRef.create((int)0);
        Using$.MODULE$.resource((Object)CSVWriter$.MODULE$.open(dataFile.toFile(), false, (CSVFormat)CSVFormat$.MODULE$.defaultCSVFormat()), (Function1)(JProcedure1 & Serializable)writer -> nodes.iterator().foreach((Function1)(JProcedure1 & Serializable)node -> {
            if ((ColumnDefinitions)columnDefinitions$2.elem == null) {
                columnDefinitions$2.elem = new ColumnDefinitions((Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)node.propertyKeys()).asScala());
            }
            Seq specialColumns = (Seq)((SeqOps)new .colon.colon((Object)BoxesRunTime.boxToLong((long)node.id()).toString(), (List)new .colon.colon((Object)node.label(), (List)Nil$.MODULE$)));
            Seq<String> propertyValueColumns = ((ColumnDefinitions)columnDefinitions$2.elem).propertyValues((Function1 & Serializable)_$5 -> {
                Optional optional = OptionConverters$.MODULE$.RichOptional(node.propertyOption(_$5));
                return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
            });
            writer.writeRow((Seq)specialColumns.$plus$plus(propertyValueColumns));
            ++nodeCount$2.elem;
        }), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        this.writeSingleLineCsv(headerFile, (Seq<Object>)((Seq)((SeqOps)new .colon.colon((Object)package$ColumnType$.MODULE$.Id(), (List)new .colon.colon((Object)package$ColumnType$.MODULE$.Label(), (List)Nil$.MODULE$))).$plus$plus(((ColumnDefinitions)columnDefinitions.elem).propertiesWithTypes())));
        String cypherPropertyMappings = ((ColumnDefinitions)columnDefinitions.elem).propertiesMappingsForCypher(2).mkString(",\n");
        String cypherQuery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("LOAD CSV FROM 'file:/nodes_" + label + "_data.csv' AS line\n         |CREATE (:" + label + " {\n         |id: toInteger(line[0]),\n         |" + cypherPropertyMappings + "\n         |});\n         |"));
        overflowdb.formats.package$.MODULE$.writeFile(cypherFile, cypherQuery);
        return Neo4jCsvExporter$CountAndFiles$.MODULE$.apply(nodeCount.elem, (Seq<Path>)((Seq)((SeqOps)new .colon.colon((Object)headerFile, (List)new .colon.colon((Object)dataFile, (List)new .colon.colon((Object)cypherFile, (List)Nil$.MODULE$))))));
    }

    private Neo4jCsvExporter.CountAndFiles exportEdges(IterableOnce<Edge> edges, Path outputRootDirectory) {
        scala.collection.mutable.Map edgeFilesContextByLabel = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        IntRef count = IntRef.create((int)0);
        edges.iterator().foreach((Function1)(JProcedure1 & Serializable)edge -> {
            String label = edge.label();
            Neo4jCsvExporter.EdgeFilesContext context = (Neo4jCsvExporter.EdgeFilesContext)edgeFilesContextByLabel.getOrElseUpdate((Object)label, () -> Neo4jCsvExporter$.$anonfun$6(outputRootDirectory, label, edge));
            Seq specialColumns = (Seq)((SeqOps)new .colon.colon((Object)BoxesRunTime.boxToLong((long)edge.outNode().id()).toString(), (List)new .colon.colon((Object)BoxesRunTime.boxToLong((long)edge.inNode().id()).toString(), (List)new .colon.colon((Object)edge.label(), (List)Nil$.MODULE$))));
            Seq<String> propertyValueColumns = context.columnDefinitions().propertyValues((Function1 & Serializable)_$6 -> {
                Optional optional = OptionConverters$.MODULE$.RichOptional(edge.propertyOption(_$6));
                return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
            });
            context.dataFileWriter().writeRow((Seq)specialColumns.$plus$plus(propertyValueColumns));
            ++count$1.elem;
        });
        Seq files = ((IterableOnceOps)edgeFilesContextByLabel.values().flatMap((Function1 & Serializable)x$1 -> {
            Neo4jCsvExporter.EdgeFilesContext edgeFilesContext = x$1;
            if (edgeFilesContext != null) {
                Neo4jCsvExporter.EdgeFilesContext edgeFilesContext2 = Neo4jCsvExporter$EdgeFilesContext$.MODULE$.unapply(edgeFilesContext);
                String string = edgeFilesContext2._1();
                Path path = edgeFilesContext2._2();
                Path path2 = edgeFilesContext2._3();
                Path path3 = edgeFilesContext2._4();
                CSVWriter cSVWriter = edgeFilesContext2._5();
                ColumnDefinitions columnDefinitions = edgeFilesContext2._6();
                String label = string;
                Path headerFile = path;
                Path dataFile = path2;
                Path cypherFile = path3;
                CSVWriter dataFileWriter = cSVWriter;
                ColumnDefinitions columnDefinitions2 = columnDefinitions;
                MODULE$.writeSingleLineCsv(headerFile, (Seq<Object>)((Seq)((SeqOps)new .colon.colon((Object)package$ColumnType$.MODULE$.StartId(), (List)new .colon.colon((Object)package$ColumnType$.MODULE$.EndId(), (List)new .colon.colon((Object)package$ColumnType$.MODULE$.Type(), (List)Nil$.MODULE$)))).$plus$plus(columnDefinitions2.propertiesWithTypes())));
                dataFileWriter.flush();
                dataFileWriter.close();
                String cypherPropertyMappings = columnDefinitions2.propertiesMappingsForCypher(3).mkString(",\n");
                String cypherQuery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("LOAD CSV FROM 'file:/edges_" + label + "_data.csv' AS line\n             |MATCH (a), (b)\n             |WHERE a.id = toInteger(line[0]) AND b.id = toInteger(line[1])\n             |CREATE (a)-[r:" + label + " {" + cypherPropertyMappings + "}]->(b);\n             |"));
                overflowdb.formats.package$.MODULE$.writeFile(cypherFile, cypherQuery);
                return (Seq)((SeqOps)new .colon.colon((Object)headerFile, (List)new .colon.colon((Object)dataFile, (List)new .colon.colon((Object)cypherFile, (List)Nil$.MODULE$))));
            }
            throw new MatchError((Object)edgeFilesContext);
        })).toSeq();
        return Neo4jCsvExporter$CountAndFiles$.MODULE$.apply(count.elem, (Seq<Path>)files);
    }

    private void writeSingleLineCsv(Path outputFile, Seq<Object> entries) {
        Using$.MODULE$.resource((Object)CSVWriter$.MODULE$.open(outputFile.toFile(), false, (CSVFormat)CSVFormat$.MODULE$.defaultCSVFormat()), (Function1)(JProcedure1 & Serializable)writer -> writer.writeRow(entries), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private static final Neo4jCsvExporter.EdgeFilesContext $anonfun$6(Path outputRootDirectory$3, String label$1, Edge edge$1) {
        Path headerFile = outputRootDirectory$3.resolve("edges_" + label$1 + package$.MODULE$.HeaderFileSuffix() + ".csv");
        Path dataFile = outputRootDirectory$3.resolve("edges_" + label$1 + package$.MODULE$.DataFileSuffix() + ".csv");
        Path cypherFile = outputRootDirectory$3.resolve("edges_" + label$1 + package$.MODULE$.CypherFileSuffix() + ".csv");
        CSVWriter dataFileWriter = CSVWriter$.MODULE$.open(dataFile.toFile(), false, (CSVFormat)CSVFormat$.MODULE$.defaultCSVFormat());
        ColumnDefinitions columnDefinitions = new ColumnDefinitions((Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)edge$1.propertyKeys()).asScala());
        return Neo4jCsvExporter$EdgeFilesContext$.MODULE$.apply(label$1, headerFile, dataFile, cypherFile, dataFileWriter, columnDefinitions);
    }
}

