/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.php2atom.parser;

import better.files.File;
import better.files.File$;
import io.appthreat.php2atom.Config;
import io.appthreat.php2atom.parser.Domain;
import io.appthreat.php2atom.parser.Domain$;
import io.appthreat.php2atom.parser.PhpParser$;
import io.appthreat.x2cpg.utils.ExternalCommand$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

public class PhpParser {
    private final String phpParserPath;
    private final String phpIniPath;

    public static String PhpParserBinEnvVar() {
        return PhpParser$.MODULE$.PhpParserBinEnvVar();
    }

    public static Option<PhpParser> getParser(Config config) {
        return PhpParser$.MODULE$.getParser(config);
    }

    public PhpParser(String phpParserPath, String phpIniPath) {
        this.phpParserPath = phpParserPath;
        this.phpIniPath = phpIniPath;
    }

    private String phpParseCommand(String filename) {
        String phpParserCommands = "--with-recovery --resolve-names -P --json-dump";
        String string = this.phpParserPath;
        if ("phpastgen".equals(string)) {
            return this.phpParserPath + " " + phpParserCommands + " " + filename;
        }
        return "php --php-ini " + this.phpIniPath + " " + this.phpParserPath + " " + phpParserCommands + " " + filename;
    }

    public Option<Domain.PhpFile> parseFile(String inputPath, Option<String> phpIniOverride) {
        File inputFile = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        String inputFilePath = inputFile.canonicalPath();
        String inputDirectory = inputFile.parent().canonicalPath();
        String command = this.phpParseCommand(inputFilePath);
        Try try_ = ExternalCommand$.MODULE$.run(command, inputDirectory, true);
        if (try_ instanceof Success) {
            Seq output = (Seq)((Success)try_).value();
            return this.processParserOutput((Seq<String>)output, inputFilePath);
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private Option<Domain.PhpFile> processParserOutput(Seq<String> output, String filename) {
        Option<Value> maybeJson = this.linesToJsonValue(output, filename);
        return maybeJson.flatMap((Function1 & Serializable)_$1 -> this.jsonValueToPhpFile((Value)_$1, filename));
    }

    private Option<Value> linesToJsonValue(Seq<String> lines, String filename) {
        if (lines.exists((Function1 & Serializable)_$2 -> _$2.startsWith("["))) {
            String jsonString = ((IterableOnceOps)lines.dropWhile((Function1 & Serializable)_$3 -> _$3.charAt(0) != '[')).mkString("\n");
            Try try_ = Try$.MODULE$.apply(() -> PhpParser.linesToJsonValue$$anonfun$2(jsonString));
            if (try_ instanceof Success) {
                Option option = (Option)((Success)try_).value();
                if (option instanceof Some) {
                    Value value = (Value)((Some)option).value();
                    return Some$.MODULE$.apply((Object)value);
                }
                if (None$.MODULE$.equals(option)) {
                    return None$.MODULE$;
                }
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                return None$.MODULE$;
            }
            throw new MatchError((Object)try_);
        }
        return None$.MODULE$;
    }

    private Option<Domain.PhpFile> jsonValueToPhpFile(Value json, String filename) {
        Try try_ = Try$.MODULE$.apply(() -> PhpParser.jsonValueToPhpFile$$anonfun$1(json));
        if (try_ instanceof Success) {
            Domain.PhpFile phpFile = (Domain.PhpFile)((Success)try_).value();
            return Some$.MODULE$.apply((Object)phpFile);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private static final Option linesToJsonValue$$anonfun$2(String jsonString$1) {
        return Option$.MODULE$.apply((Object)package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(jsonString$1), package$.MODULE$.read$default$2()));
    }

    private static final Domain.PhpFile jsonValueToPhpFile$$anonfun$1(Value json$1) {
        return Domain$.MODULE$.fromJson(json$1);
    }
}

