/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.Ordering;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.control.parallel.Promise;
import fj.control.parallel.Strategy;
import fj.data.Array;
import fj.data.Either;
import fj.data.Enumerator;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Natural;
import fj.data.Option;
import fj.function.Booleans;
import fj.function.Effect1;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Stream<A>
implements Iterable<A> {
    private Stream() {
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract P1<Stream<A>> tail();

    public final boolean isEmpty() {
        return this instanceof Nil;
    }

    public final boolean isNotEmpty() {
        return this instanceof Cons;
    }

    public final <B> B stream(B nil, F<A, F<P1<Stream<A>>, B>> cons) {
        return this.isEmpty() ? nil : cons.f(this.head()).f(this.tail());
    }

    public final <B> B foldRight(final F<A, F<P1<B>, B>> f, final B b) {
        return this.isEmpty() ? b : f.f(this.head()).f(new P1<B>(){

            @Override
            public B _1() {
                return Stream.this.tail()._1().foldRight(f, b);
            }
        });
    }

    public final <B> B foldRight(F2<A, P1<B>, B> f, B b) {
        return this.foldRight(Function.curry(f), b);
    }

    public final <B> B foldRight1(F<A, F<B, B>> f, B b) {
        return (B)this.foldRight(Function.compose(Function.andThen().f(P1.__1()), f), b);
    }

    public final <B> B foldRight1(F2<A, B, B> f, B b) {
        return this.foldRight1(Function.curry(f), b);
    }

    public final <B> B foldLeft(F<B, F<A, B>> f, B b) {
        B x = b;
        Stream<A> xs = this;
        while (!xs.isEmpty()) {
            x = f.f(x).f(xs.head());
            xs = xs.tail()._1();
        }
        return x;
    }

    public final <B> B foldLeft(F2<B, A, B> f, B b) {
        return this.foldLeft(Function.curry(f), b);
    }

    public final A foldLeft1(F2<A, A, A> f) {
        return this.foldLeft1(Function.curry(f));
    }

    public final A foldLeft1(F<A, F<A, A>> f) {
        if (this.isEmpty()) {
            throw Bottom.error("Undefined: foldLeft1 on empty list");
        }
        return this.tail()._1().foldLeft(f, this.head());
    }

    public final A orHead(P1<A> a) {
        return this.isEmpty() ? a._1() : this.head();
    }

    public final P1<Stream<A>> orTail(P1<Stream<A>> as) {
        return this.isEmpty() ? as : this.tail();
    }

    public final Stream<A> intersperse(final A a) {
        return this.isEmpty() ? this : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return this.prefix(a, Stream.this.tail()._1());
            }

            public Stream<A> prefix(A x, final Stream<A> xs) {
                return xs.isEmpty() ? xs : Stream.cons(x, P.p(Stream.cons(xs.head(), new P1<Stream<A>>(){

                    @Override
                    public Stream<A> _1() {
                        return this.prefix(a, xs.tail()._1());
                    }
                })));
            }
        });
    }

    public final <B> Stream<B> map(final F<A, B> f) {
        return this.isEmpty() ? Stream.nil() : Stream.cons(f.f(this.head()), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Stream.this.tail()._1().map(f);
            }
        });
    }

    public static <A, B> F<F<A, B>, F<Stream<A>, Stream<B>>> map_() {
        return new F<F<A, B>, F<Stream<A>, Stream<B>>>(){

            @Override
            public F<Stream<A>, Stream<B>> f(final F<A, B> f) {
                return new F<Stream<A>, Stream<B>>(){

                    @Override
                    public Stream<B> f(Stream<A> as) {
                        return as.map(f);
                    }
                };
            }
        };
    }

    public final Unit foreach(F<A, Unit> f) {
        Stream<A> xs = this;
        while (xs.isNotEmpty()) {
            f.f(xs.head());
            xs = xs.tail()._1();
        }
        return Unit.unit();
    }

    public final void foreachDoEffect(Effect1<A> f) {
        Stream<A> xs = this;
        while (xs.isNotEmpty()) {
            f.f(xs.head());
            xs = xs.tail()._1();
        }
    }

    public final Stream<A> filter(final F<A, Boolean> f) {
        final Stream<A> as = this.dropWhile(Booleans.not(f));
        return as.isNotEmpty() ? Stream.cons(as.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return as.tail()._1().filter(f);
            }
        }) : as;
    }

    public final Stream<A> append(final Stream<A> as) {
        return this.isEmpty() ? as : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().append(as);
            }
        });
    }

    public final Stream<A> append(final P1<Stream<A>> as) {
        return this.isEmpty() ? as._1() : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().append(as);
            }
        });
    }

    public final Stream<A> minus(Equal<A> eq, Stream<A> xs) {
        return this.removeAll(Function.compose(Monoid.disjunctionMonoid.sumLeftS(), xs.mapM(Function.curry(eq.eq()))));
    }

    public final Stream<A> removeAll(F<A, Boolean> f) {
        return this.filter(Function.compose(Booleans.not, f));
    }

    public static <A, B> F<B, Stream<A>> sequence_(Stream<F<B, A>> fs) {
        return fs.foldRight(new F2<F<B, A>, P1<F<B, Stream<A>>>, F<B, Stream<A>>>(){

            @Override
            public F<B, Stream<A>> f(F<B, A> baf, P1<F<B, Stream<A>>> p1) {
                return Function.bind(baf, p1._1(), Function.curry(new F2<A, Stream<A>, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a, Stream<A> stream) {
                        return Stream.cons(a, P.p(stream));
                    }
                }));
            }
        }, Function.constant(Stream.nil()));
    }

    public final <B, C> F<B, Stream<C>> mapM(F<A, F<B, C>> f) {
        return Stream.sequence_(this.map(f));
    }

    public final <B> Stream<B> bind(F<A, Stream<B>> f) {
        return this.map(f).foldLeft(new F2<Stream<B>, Stream<B>, Stream<B>>(){

            @Override
            public Stream<B> f(Stream<B> accumulator, Stream<B> element) {
                Stream result = accumulator;
                for (Object single : element) {
                    result = result.cons(single);
                }
                return result;
            }
        }, Stream.nil()).reverse();
    }

    public final <B, C> Stream<C> bind(Stream<B> sb, F<A, F<B, C>> f) {
        return sb.apply(this.map(f));
    }

    public final <B, C> Stream<C> bind(Stream<B> sb, F2<A, B, C> f) {
        return this.bind(sb, Function.curry(f));
    }

    public final <B, C, D> Stream<D> bind(Stream<B> sb, Stream<C> sc, F<A, F<B, F<C, D>>> f) {
        return sc.apply(this.bind(sb, f));
    }

    public final <B, C, D, E> Stream<E> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, F<A, F<B, F<C, F<D, E>>>> f) {
        return sd.apply(this.bind(sb, sc, f));
    }

    public final <B, C, D, E, F$> Stream<F$> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return se.apply(this.bind(sb, sc, sd, f));
    }

    public final <B, C, D, E, F$, G> Stream<G> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return sf.apply(this.bind(sb, sc, sd, se, f));
    }

    public final <B, C, D, E, F$, G, H> Stream<H> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, Stream<G> sg, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return sg.apply(this.bind(sb, sc, sd, se, sf, f));
    }

    public final <B, C, D, E, F$, G, H, I> Stream<I> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, Stream<G> sg, Stream<H> sh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return sh.apply(this.bind(sb, sc, sd, se, sf, sg, f));
    }

    public final <B> Stream<B> sequence(Stream<B> bs) {
        F c = Function.constant(bs);
        return this.bind(c);
    }

    public final <B> Stream<B> apply(Stream<F<A, B>> sf) {
        return sf.bind(new F<F<A, B>, Stream<B>>(){

            @Override
            public Stream<B> f(final F<A, B> f) {
                return Stream.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f.f(a);
                    }
                });
            }
        });
    }

    public final Stream<A> interleave(final Stream<A> as) {
        return this.isEmpty() ? as : (as.isEmpty() ? this : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return as.interleave(Stream.this.tail()._1());
            }
        }));
    }

    public final Stream<A> sort(Ord<A> o) {
        return Stream.mergesort(o, this.map(Function.flip(Stream.cons()).f(P.p(Stream.nil()))));
    }

    private static <A> Stream<A> mergesort(Ord<A> o, Stream<Stream<A>> s) {
        if (s.isEmpty()) {
            return Stream.nil();
        }
        Stream<Stream<A>> xss = s;
        while (xss.tail()._1().isNotEmpty()) {
            xss = Stream.mergePairs(o, xss);
        }
        return xss.head();
    }

    private static <A> Stream<Stream<A>> mergePairs(final Ord<A> o, Stream<Stream<A>> s) {
        if (s.isEmpty() || s.tail()._1().isEmpty()) {
            return s;
        }
        final Stream<Stream<A>> t = s.tail()._1();
        return Stream.cons(Stream.merge(o, s.head(), t.head()), new P1<Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> _1() {
                return Stream.mergePairs(o, t.tail()._1());
            }
        });
    }

    private static <A> Stream<A> merge(final Ord<A> o, final Stream<A> xs, final Stream<A> ys) {
        A y;
        if (xs.isEmpty()) {
            return ys;
        }
        if (ys.isEmpty()) {
            return xs;
        }
        A x = xs.head();
        if (o.isGreaterThan(x, y = ys.head())) {
            return Stream.cons(y, new P1<Stream<A>>(){

                @Override
                public Stream<A> _1() {
                    return Stream.merge(o, xs, ys.tail()._1());
                }
            });
        }
        return Stream.cons(x, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.merge(o, xs.tail()._1(), ys);
            }
        });
    }

    public final Stream<A> sort(Ord<A> o, Strategy<Unit> s) {
        return this.qs(o, s).claim();
    }

    private Promise<Stream<A>> qs(Ord<A> o, Strategy<Unit> s) {
        if (this.isEmpty()) {
            return Promise.promise(s, P.p(this));
        }
        F<Boolean, Boolean> id = Function.identity();
        A x = this.head();
        P1<Stream<Stream<A>>> xs = this.tail();
        Promise left = Promise.join(s, xs.map(Stream.flt(o, s, x, id)));
        Promise<Stream<Stream<A>>> right = xs.map(Stream.flt(o, s, x, Booleans.not))._1();
        Monoid<Stream<Stream<A>>> m = Monoid.streamMonoid();
        return right.fmap(m.sum(Stream.single(x))).apply(left.fmap(m.sum()));
    }

    private static <A> F<Stream<A>, Promise<Stream<A>>> qs_(final Ord<A> o, final Strategy<Unit> s) {
        return new F<Stream<A>, Promise<Stream<A>>>(){

            @Override
            public Promise<Stream<A>> f(Stream<A> xs) {
                return xs.qs(o, s);
            }
        };
    }

    private static <A> F<Stream<A>, Promise<Stream<A>>> flt(Ord<A> o, Strategy<Unit> s, A x, F<Boolean, Boolean> f) {
        F<F<F<A, Boolean>, Boolean>, F<Stream<F<A, Boolean>>, Stream<F<A, Boolean>>>> filter = Stream.filter();
        F<A, Boolean> lt = o.isLessThan(x);
        return Function.compose(Stream.qs_(o, s), filter.f(Function.compose(f, lt)));
    }

    public final Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private Stream<A> xs;
                    {
                        this.xs = Stream.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail()._1();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Stream.this.length();
            }
        };
    }

    public static Stream<Integer> range(final int from, final long to) {
        return (long)from >= to ? Stream.nil() : Stream.cons(from, new P1<Stream<Integer>>(){

            @Override
            public Stream<Integer> _1() {
                return Stream.range(from + 1, to);
            }
        });
    }

    public static <A> Stream<A> stream(A ... as) {
        return as.length == 0 ? Stream.nil() : Stream.unfold(P2.tuple(new F2<A[], Integer, Option<P2<A, P2<A[], Integer>>>>(){

            @Override
            public Option<P2<A, P2<A[], Integer>>> f(A[] as, Integer i) {
                return i >= as.length ? Option.none() : Option.some(P.p(as[i], P.p(as, i + 1)));
            }
        }), P.p(as, 0));
    }

    public static <A> Stream<A> forever(Enumerator<A> e, A from) {
        return Stream.forever(e, from, 1L);
    }

    public static <A> Stream<A> forever(final Enumerator<A> e, final A from, final long step) {
        return Stream.cons(from, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return e.plus(from, step).map(new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.forever(e, a, step);
                    }
                }).orSome(Stream.nil());
            }
        });
    }

    public static <A> Stream<A> range(Enumerator<A> e, A from, A to) {
        return Stream.range(e, from, to, 1L);
    }

    public static <A> Stream<A> range(final Enumerator<A> e, final A from, final A to, final long step) {
        final Ordering o = e.order().compare(from, to);
        return o == Ordering.EQ || step > 0L && o == Ordering.GT || step < 0L && o == Ordering.LT ? Stream.single(from) : Stream.cons(from, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.join(e.plus(from, step).filter(new F<A, Boolean>(){

                    @Override
                    public Boolean f(A a) {
                        return !(o != Ordering.LT ? e.order().isGreaterThan(to, a) : e.order().isLessThan(to, a));
                    }
                }).map(new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.range(e, a, to, step);
                    }
                }).toStream());
            }
        });
    }

    public static Stream<Integer> range(final int from) {
        return Stream.cons(from, new P1<Stream<Integer>>(){

            @Override
            public Stream<Integer> _1() {
                return Stream.range(from + 1);
            }
        });
    }

    public static <A> F<F<A, Boolean>, F<Stream<A>, Stream<A>>> filter() {
        return Function.curry(new F2<F<A, Boolean>, Stream<A>, Stream<A>>(){

            @Override
            public Stream<A> f(F<A, Boolean> f, Stream<A> as) {
                return as.filter(f);
            }
        });
    }

    public final <B> Stream<B> zapp(final Stream<F<A, B>> fs) {
        return fs.isEmpty() || this.isEmpty() ? Stream.nil() : Stream.cons(fs.head().f(this.head()), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Stream.this.tail()._1().zapp(fs.tail()._1());
            }
        });
    }

    public final <B, C> Stream<C> zipWith(Stream<B> bs, F<A, F<B, C>> f) {
        return bs.zapp(this.zapp(Stream.repeat(f)));
    }

    public final <B, C> Stream<C> zipWith(Stream<B> bs, F2<A, B, C> f) {
        return this.zipWith(bs, Function.curry(f));
    }

    public final <B, C> F<Stream<B>, Stream<C>> zipWith(final F<A, F<B, C>> f) {
        return new F<Stream<B>, Stream<C>>(){

            @Override
            public Stream<C> f(Stream<B> stream) {
                return Stream.this.zipWith(stream, f);
            }
        };
    }

    public final <B> Stream<P2<A, B>> zip(Stream<B> bs) {
        F __2 = P.p2();
        return this.zipWith(bs, __2);
    }

    public final Stream<P2<A, Integer>> zipIndex() {
        return this.zipWith(Stream.range(0), new F2<A, Integer, P2<A, Integer>>(){

            @Override
            public P2<A, Integer> f(A a, Integer i) {
                return P.p(a, i);
            }
        });
    }

    public final <X> Either<X, A> toEither(P1<X> x) {
        return this.isEmpty() ? Either.left(x._1()) : Either.right(this.head());
    }

    public final Option<A> toOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public final List<A> toList() {
        List<A> as = List.nil();
        Stream<A> x = this;
        while (!x.isEmpty()) {
            as = as.snoc(x.head());
            x = x.tail()._1();
        }
        return as;
    }

    public final Array<A> toArray() {
        int l = this.length();
        Object[] a = new Object[l];
        Stream<A> x = this;
        for (int i = 0; i < l; ++i) {
            a[i] = x.head();
            x = x.tail()._1();
        }
        return Array.mkArray(a);
    }

    public final Array<A> toArray(Class<A[]> c) {
        Object[] a = (Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), this.length());
        int i = 0;
        for (A x : this) {
            a[i] = x;
            ++i;
        }
        return Array.array(a);
    }

    public final A[] array(Class<A[]> c) {
        return this.toArray(c).array(c);
    }

    public final Stream<A> cons(A a) {
        return new Cons<A>(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this;
            }
        });
    }

    public static String asString(Stream<Character> cs) {
        return LazyString.fromStream(cs).toString();
    }

    public static Stream<Character> fromString(String s) {
        return LazyString.str(s).toStream();
    }

    public final Stream<A> snoc(A a) {
        return this.snoc(P.p(a));
    }

    public final Stream<A> snoc(final P1<A> a) {
        return this.append(new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.single(a._1());
            }
        });
    }

    public final Stream<A> take(final int n) {
        return n <= 0 || this.isEmpty() ? Stream.nil() : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().take(n - 1);
            }
        });
    }

    public final Stream<A> drop(int i) {
        Stream<A> xs = this;
        for (int c = 0; xs.isNotEmpty() && c < i; ++c) {
            xs = xs.tail()._1();
        }
        return xs;
    }

    public final Stream<A> takeWhile(final F<A, Boolean> f) {
        return this.isEmpty() ? this : (f.f(this.head()) != false ? Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().takeWhile(f);
            }
        }) : Stream.nil());
    }

    public final Stream<A> dropWhile(F<A, Boolean> f) {
        Stream<A> as = this;
        while (!as.isEmpty() && f.f(as.head()).booleanValue()) {
            as = as.tail()._1();
        }
        return as;
    }

    public final P2<Stream<A>, Stream<A>> span(final F<A, Boolean> p) {
        if (this.isEmpty()) {
            return P.p(this, this);
        }
        if (p.f(this.head()).booleanValue()) {
            final P1 yszs = new P1<P2<Stream<A>, Stream<A>>>(){

                @Override
                public P2<Stream<A>, Stream<A>> _1() {
                    return Stream.this.tail()._1().span(p);
                }
            };
            return new P2<Stream<A>, Stream<A>>(){

                @Override
                public Stream<A> _1() {
                    return Stream.cons(Stream.this.head(), yszs.map(P2.__1()));
                }

                @Override
                public Stream<A> _2() {
                    return (Stream)((P2)yszs._1())._2();
                }
            };
        }
        return P.p(Stream.nil(), this);
    }

    public final Stream<A> replace(final F<A, Boolean> p, final A a) {
        if (this.isEmpty()) {
            return Stream.nil();
        }
        final P2<Stream<A>, Stream<A>> s = this.span(p);
        return s._1().append(Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return ((Stream)s._2()).tail()._1().replace(p, a);
            }
        }));
    }

    public final P2<Stream<A>, Stream<A>> split(F<A, Boolean> p) {
        return this.span(Function.compose(Booleans.not, p));
    }

    public final Stream<A> reverse() {
        return this.foldLeft(new F<Stream<A>, F<A, Stream<A>>>(){

            @Override
            public F<A, Stream<A>> f(final Stream<A> as) {
                return new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.cons(a, new P1<Stream<A>>(){

                            @Override
                            public Stream<A> _1() {
                                return as;
                            }
                        });
                    }
                };
            }
        }, Stream.nil());
    }

    public final A last() {
        return this.reverse().head();
    }

    public final int length() {
        Stream<A> xs = this;
        int i = 0;
        while (!xs.isEmpty()) {
            xs = xs.tail()._1();
            ++i;
        }
        return i;
    }

    public final A index(int i) {
        if (i < 0) {
            throw Bottom.error("index " + i + " out of range on stream");
        }
        Stream<A> xs = this;
        for (int c = 0; c < i; ++c) {
            if (xs.isEmpty()) {
                throw Bottom.error("index " + i + " out of range on stream");
            }
            xs = xs.tail()._1();
        }
        if (xs.isEmpty()) {
            throw Bottom.error("index " + i + " out of range on stream");
        }
        return xs.head();
    }

    public final boolean forall(F<A, Boolean> f) {
        return this.isEmpty() || f.f(this.head()) != false && this.tail()._1().forall(f);
    }

    public final boolean exists(F<A, Boolean> f) {
        return this.dropWhile(Booleans.not(f)).isNotEmpty();
    }

    public final Option<A> find(F<A, Boolean> f) {
        Stream<A> as = this;
        while (as.isNotEmpty()) {
            if (f.f(as.head()).booleanValue()) {
                return Option.some(as.head());
            }
            as = as.tail()._1();
        }
        return Option.none();
    }

    public final <B> Stream<B> cobind(F<Stream<A>, B> k) {
        return this.substreams().map(k);
    }

    public final Stream<Stream<A>> tails() {
        return this.isEmpty() ? Stream.nil() : Stream.cons(this, new P1<Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> _1() {
                return Stream.this.tail()._1().tails();
            }
        });
    }

    public final Stream<Stream<A>> inits() {
        Stream<Stream<Stream<A>>> nil = Stream.cons(Stream.nil(), new P1<Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> _1() {
                return Stream.nil();
            }
        });
        return this.isEmpty() ? nil : nil.append(new P1<Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> _1() {
                return Stream.this.tail()._1().inits().map(Stream.cons_().f(Stream.this.head()));
            }
        });
    }

    public final Stream<Stream<A>> substreams() {
        return this.tails().bind(new F<Stream<A>, Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> f(Stream<A> stream) {
                return stream.inits();
            }
        });
    }

    public final Option<Integer> indexOf(final F<A, Boolean> p) {
        return this.zipIndex().find(new F<P2<A, Integer>, Boolean>(){

            @Override
            public Boolean f(P2<A, Integer> p2) {
                return (Boolean)p.f(p2._1());
            }
        }).map(P2.__2());
    }

    public final <B> Stream<B> sequenceW(final Stream<F<Stream<A>, B>> fs) {
        return fs.isEmpty() ? Stream.nil() : Stream.cons(fs.head().f(this), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Stream.this.sequenceW(fs.tail()._1());
            }
        });
    }

    public final F<Integer, A> toFunction() {
        return new F<Integer, A>(){

            @Override
            public A f(Integer i) {
                return Stream.this.index(i);
            }
        };
    }

    public static <A> Stream<A> fromFunction(F<Natural, A> f) {
        return Stream.fromFunction(Enumerator.naturalEnumerator, f, Natural.ZERO);
    }

    public static <A, B> Stream<A> fromFunction(final Enumerator<B> e, final F<B, A> f, final B i) {
        return Stream.cons(f.f(i), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                Option<Object> s = e.successor(i);
                return s.isSome() ? Stream.fromFunction(e, f, s.some()) : Stream.nil();
            }
        });
    }

    public static <A, B> P2<Stream<A>, Stream<B>> unzip(Stream<P2<A, B>> xs) {
        return xs.foldRight(new F2<P2<A, B>, P1<P2<Stream<A>, Stream<B>>>, P2<Stream<A>, Stream<B>>>(){

            @Override
            public P2<Stream<A>, Stream<B>> f(P2<A, B> p, P1<P2<Stream<A>, Stream<B>>> ps) {
                P2 pp = ps._1();
                return P.p(Stream.cons(p._1(), P.p(pp._1())), Stream.cons(p._2(), P.p(pp._2())));
            }
        }, P.p(Stream.nil(), Stream.nil()));
    }

    public static <A, B, C> F<Stream<A>, F<Stream<B>, F<F<A, F<B, C>>, Stream<C>>>> zipWith() {
        return Function.curry(new F3<Stream<A>, Stream<B>, F<A, F<B, C>>, Stream<C>>(){

            @Override
            public Stream<C> f(Stream<A> as, Stream<B> bs, F<A, F<B, C>> f) {
                return as.zipWith(bs, f);
            }
        });
    }

    public static <A> F<A, F<P1<Stream<A>>, Stream<A>>> cons() {
        return new F<A, F<P1<Stream<A>>, Stream<A>>>(){

            @Override
            public F<P1<Stream<A>>, Stream<A>> f(final A a) {
                return new F<P1<Stream<A>>, Stream<A>>(){

                    @Override
                    public Stream<A> f(P1<Stream<A>> list) {
                        return Stream.cons(a, list);
                    }
                };
            }
        };
    }

    public static <A> F<A, F<Stream<A>, Stream<A>>> cons_() {
        return Function.curry(new F2<A, Stream<A>, Stream<A>>(){

            @Override
            public Stream<A> f(A a, Stream<A> as) {
                return as.cons(a);
            }
        });
    }

    public static <A> Stream<A> nil() {
        return new Nil();
    }

    public static <A> P1<Stream<A>> nil_() {
        return new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return new Nil();
            }
        };
    }

    public static <A> F<Stream<A>, Boolean> isEmpty_() {
        return new F<Stream<A>, Boolean>(){

            @Override
            public Boolean f(Stream<A> as) {
                return as.isEmpty();
            }
        };
    }

    public static <A> F<Stream<A>, Boolean> isNotEmpty_() {
        return new F<Stream<A>, Boolean>(){

            @Override
            public Boolean f(Stream<A> as) {
                return as.isNotEmpty();
            }
        };
    }

    public static <A> Stream<A> single(A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.nil();
            }
        });
    }

    public static <A> F<A, Stream<A>> single() {
        return new F<A, Stream<A>>(){

            @Override
            public Stream<A> f(A a) {
                return Stream.single(a);
            }
        };
    }

    public static <A> Stream<A> cons(A head, P1<Stream<A>> tail) {
        return new Cons<A>(head, tail);
    }

    public static <A> Stream<A> join(Stream<Stream<A>> o) {
        return Monoid.streamMonoid().sumRight(o);
    }

    public static <A> F<Stream<Stream<A>>, Stream<A>> join() {
        return new F<Stream<Stream<A>>, Stream<A>>(){

            @Override
            public Stream<A> f(Stream<Stream<A>> as) {
                return Stream.join(as);
            }
        };
    }

    public static <A, B> Stream<A> unfold(final F<B, Option<P2<A, B>>> f, B b) {
        Option<P2<A, B>> o = f.f(b);
        if (o.isNone()) {
            return Stream.nil();
        }
        final P2<A, B> p = o.some();
        return Stream.cons(p._1(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.unfold(f, p._2());
            }
        });
    }

    public static <A> Stream<A> iterateWhile(final F<A, A> f, final F<A, Boolean> p, A a) {
        return Stream.unfold(new F<A, Option<P2<A, A>>>(){

            @Override
            public Option<P2<A, A>> f(final A o) {
                return Option.iif(new F<P2<A, A>, Boolean>(){

                    @Override
                    public Boolean f(P2<A, A> p2) {
                        return (Boolean)p.f(o);
                    }
                }, P.p(o, f.f(o)));
            }
        }, a);
    }

    public static <A> Stream<A> iterableStream(Iterable<A> i) {
        final class Util {
            Util() {
            }

            public <A> Stream<A> iteratorStream(final Iterator<A> i) {
                if (i.hasNext()) {
                    A a = i.next();
                    return Stream.cons(a, new P1<Stream<A>>(){

                        @Override
                        public Stream<A> _1() {
                            return this.iteratorStream(i);
                        }
                    });
                }
                return Stream.nil();
            }
        }
        return new Util().iteratorStream(i.iterator());
    }

    public static <A> Stream<A> repeat(final A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.repeat(a);
            }
        });
    }

    public static <A> Stream<A> cycle(final Stream<A> as) {
        if (as.isEmpty()) {
            throw Bottom.error("cycle on empty list");
        }
        return as.append(new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.cycle(as);
            }
        });
    }

    public static <A> Stream<A> iterate(final F<A, A> f, final A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.iterate(f, f.f(a));
            }
        });
    }

    public static <A> F<F<A, A>, F<A, Stream<A>>> iterate() {
        return Function.curry(new F2<F<A, A>, A, Stream<A>>(){

            @Override
            public Stream<A> f(F<A, A> f, A a) {
                return Stream.iterate(f, a);
            }
        });
    }

    public static <A, B> F<F<A, Stream<B>>, F<Stream<A>, Stream<B>>> bind_() {
        return Function.curry(new F2<F<A, Stream<B>>, Stream<A>, Stream<B>>(){

            @Override
            public Stream<B> f(F<A, Stream<B>> f, Stream<A> as) {
                return as.bind(f);
            }
        });
    }

    public static <A, B> F<F<A, F<P1<B>, B>>, F<B, F<Stream<A>, B>>> foldRight() {
        return Function.curry(new F3<F<A, F<P1<B>, B>>, B, Stream<A>, B>(){

            @Override
            public B f(F<A, F<P1<B>, B>> f, B b, Stream<A> as) {
                return as.foldRight(f, b);
            }
        });
    }

    private static final class Cons<A>
    extends Stream<A> {
        private final A head;
        private final P1<Stream<A>> tail;

        Cons(A head, P1<Stream<A>> tail) {
            this.head = head;
            this.tail = tail.memo();
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public P1<Stream<A>> tail() {
            return this.tail;
        }
    }

    private static final class Nil<A>
    extends Stream<A> {
        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty stream");
        }

        @Override
        public P1<Stream<A>> tail() {
            throw Bottom.error("tail on empty stream");
        }
    }
}

