/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.immutable;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Hashing$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.OldHashSet;
import scala.collection.immutable.OldHashSet$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.parallel.BucketCombiner;
import scala.collection.parallel.Task;
import scala.collection.parallel.immutable.HashSetCombiner$;
import scala.collection.parallel.immutable.ParHashSet;
import scala.collection.parallel.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class HashSetCombiner<T>
extends BucketCombiner<T, ParHashSet<T>, Object, HashSetCombiner<T>> {
    private final OldHashSet emptyTrie = OldHashSet$.MODULE$.empty();

    public static <T> HashSetCombiner<T> apply() {
        return HashSetCombiner$.MODULE$.apply();
    }

    public static int rootbits() {
        return HashSetCombiner$.MODULE$.rootbits();
    }

    public static int rootsize() {
        return HashSetCombiner$.MODULE$.rootsize();
    }

    public HashSetCombiner() {
        super(HashSetCombiner$.MODULE$.rootsize());
    }

    public OldHashSet<T> emptyTrie() {
        return this.emptyTrie;
    }

    public HashSetCombiner addOne(T elem) {
        this.sz_$eq(this.sz() + 1);
        int hc = Hashing$.MODULE$.computeHash(elem);
        int pos = hc & 0x1F;
        if (this.buckets()[pos] == null) {
            this.buckets()[pos] = new UnrolledBuffer(ClassTag$.MODULE$.Any());
        }
        this.buckets()[pos].$plus$eq(elem);
        return this;
    }

    public ParHashSet<T> result() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.buckets());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$1 -> _$1 != null));
        UnrolledBuffer.Unrolled[] bucks = (UnrolledBuffer.Unrolled[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$2 -> _$2.headPtr(), ClassTag$.MODULE$.apply(UnrolledBuffer.Unrolled.class));
        Object[] root = new OldHashSet[bucks.length];
        this.combinerTaskSupport().executeAndWaitResult(new CreateTrie(this, (UnrolledBuffer.Unrolled<Object>[])bucks, (OldHashSet<T>[])root, 0, bucks.length));
        int bitmap = 0;
        for (int i = 0; i < HashSetCombiner$.MODULE$.rootsize(); ++i) {
            if (this.buckets()[i] == null) continue;
            bitmap |= 1 << i;
        }
        Object object3 = Predef$.MODULE$.refArrayOps(root);
        int sz = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldLeft$extension(object3, (Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(_$3, _$4) -> HashSetCombiner.$anonfun$3(BoxesRunTime.unboxToInt((Object)_$3), (OldHashSet)_$4)));
        if (sz == 0) {
            return new ParHashSet();
        }
        if (sz == 1) {
            return new ParHashSet(root[0]);
        }
        OldHashSet.HashTrieSet trie = new OldHashSet.HashTrieSet(bitmap, (OldHashSet<A>[])root, sz);
        return new ParHashSet(trie);
    }

    private static final /* synthetic */ int $anonfun$3(int _$3, OldHashSet _$4) {
        return _$3 + _$4.size();
    }

    public class CreateTrie
    implements Task<BoxedUnit, CreateTrie> {
        private volatile Throwable throwable;
        private final UnrolledBuffer.Unrolled<Object>[] bucks;
        private final OldHashSet<T>[] root;
        private final int offset;
        private final int howmany;
        private final /* synthetic */ HashSetCombiner $outer;

        public CreateTrie(HashSetCombiner $outer, UnrolledBuffer.Unrolled<Object>[] bucks, OldHashSet<T>[] root, int offset, int howmany) {
            this.bucks = bucks;
            this.root = root;
            this.offset = offset;
            this.howmany = howmany;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Task.$init$(this);
            BoxedUnit result = BoxedUnit.UNIT;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public void throwable_$eq(Throwable x$1) {
            this.throwable = x$1;
        }

        @Override
        public void result() {
            return (void)BoxedUnit.UNIT;
        }

        @Override
        public void result_$eq(BoxedUnit x$1) {
        }

        @Override
        public void leaf(Option<BoxedUnit> prev) {
            int until = this.offset + this.howmany;
            for (int i = this.offset; i < until; ++i) {
                this.root[i] = this.createTrie(this.bucks[i]);
            }
        }

        private OldHashSet<T> createTrie(UnrolledBuffer.Unrolled<Object> elems) {
            OldHashSet<Object> trie = OldHashSet$.MODULE$.empty();
            int i = 0;
            for (UnrolledBuffer.Unrolled unrolled = elems; unrolled != null; unrolled = unrolled.next()) {
                Object[] chunkarr = (Object[])unrolled.array();
                int chunksz = unrolled.size();
                while (i < chunksz) {
                    Object v = chunkarr[i];
                    int hc = Hashing$.MODULE$.computeHash(v);
                    trie = trie.updated0(v, hc, HashSetCombiner$.MODULE$.rootbits());
                    ++i;
                }
                i = 0;
            }
            return trie;
        }

        @Override
        public Seq<Task<BoxedUnit, CreateTrie>> split() {
            int fp = this.howmany / 2;
            return (Seq)new .colon.colon((Object)new CreateTrie(this.$outer, this.bucks, this.root, this.offset, fp), (List)new .colon.colon((Object)new CreateTrie(this.$outer, this.bucks, this.root, this.offset + fp, this.howmany - fp), (List)Nil$.MODULE$));
        }

        @Override
        public boolean shouldSplitFurther() {
            return this.howmany > package$.MODULE$.thresholdFromSize(this.root.length, this.$outer.combinerTaskSupport().parallelismLevel());
        }

        public final /* synthetic */ HashSetCombiner scala$collection$parallel$immutable$HashSetCombiner$CreateTrie$$$outer() {
            return this.$outer;
        }
    }
}

