/*
 * Decompiled with CFR 0.152.
 */
package polyglot.lex;

import java_cup.runtime.Symbol;
import polyglot.util.Position;

public abstract class Token {
    Position position;
    int symbol;

    public Token(Position position, int symbol) {
        this.position = position;
        this.symbol = symbol;
    }

    public Position getPosition() {
        return this.position;
    }

    public Symbol symbol() {
        return new Symbol(this.symbol, (Object)this);
    }

    protected static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\t': {
                    sb.append("\\t");
                    continue block5;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                default: {
                    if (s.charAt(i) < ' ' || s.charAt(i) > '~' && s.charAt(i) < '\u00ff') {
                        sb.append("\\" + Integer.toOctalString(s.charAt(i)));
                        continue block5;
                    }
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }
}

