/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.cache;

import com.github.javaparser.resolution.cache.CacheStats;
import com.google.common.math.LongMath;
import java.util.Arrays;

public class DefaultCacheStats
implements CacheStats {
    private final long hitCount;
    private final long missCount;
    private final long loadSuccessCount;
    private final long loadExceptionCount;
    private final long totalLoadTime;
    private final long evictionCount;

    public DefaultCacheStats() {
        this.hitCount = 0L;
        this.missCount = 0L;
        this.loadSuccessCount = 0L;
        this.loadExceptionCount = 0L;
        this.totalLoadTime = 0L;
        this.evictionCount = 0L;
    }

    public DefaultCacheStats(long hitCount, long missCount, long loadSuccessCount, long loadExceptionCount, long totalLoadTime, long evictionCount) {
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.loadSuccessCount = loadSuccessCount;
        this.loadExceptionCount = loadExceptionCount;
        this.totalLoadTime = totalLoadTime;
        this.evictionCount = evictionCount;
    }

    public long requestCount() {
        return LongMath.saturatedAdd((long)this.hitCount, (long)this.missCount);
    }

    public long hitCount() {
        return this.hitCount;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public long loadCount() {
        return LongMath.saturatedAdd((long)this.loadSuccessCount, (long)this.loadExceptionCount);
    }

    public long loadSuccessCount() {
        return this.loadSuccessCount;
    }

    public long loadExceptionCount() {
        return this.loadExceptionCount;
    }

    public double loadExceptionRate() {
        long totalLoadCount = LongMath.saturatedAdd((long)this.loadSuccessCount, (long)this.loadExceptionCount);
        return totalLoadCount == 0L ? 0.0 : (double)this.loadExceptionCount / (double)totalLoadCount;
    }

    public long totalLoadTime() {
        return this.totalLoadTime;
    }

    public double averageLoadPenalty() {
        long totalLoadCount = LongMath.saturatedAdd((long)this.loadSuccessCount, (long)this.loadExceptionCount);
        return totalLoadCount == 0L ? 0.0 : (double)this.totalLoadTime / (double)totalLoadCount;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public CacheStats minus(CacheStats other) {
        return new DefaultCacheStats(Math.max(0L, LongMath.saturatedSubtract((long)this.hitCount, (long)other.hitCount())), Math.max(0L, LongMath.saturatedSubtract((long)this.missCount, (long)other.missCount())), Math.max(0L, LongMath.saturatedSubtract((long)this.loadSuccessCount, (long)other.loadSuccessCount())), Math.max(0L, LongMath.saturatedSubtract((long)this.loadExceptionCount, (long)other.loadExceptionCount())), Math.max(0L, LongMath.saturatedSubtract((long)this.totalLoadTime, (long)other.totalLoadTime())), Math.max(0L, LongMath.saturatedSubtract((long)this.evictionCount, (long)other.evictionCount())));
    }

    public CacheStats plus(CacheStats other) {
        return new DefaultCacheStats(LongMath.saturatedAdd((long)this.hitCount, (long)other.hitCount()), LongMath.saturatedAdd((long)this.missCount, (long)other.missCount()), LongMath.saturatedAdd((long)this.loadSuccessCount, (long)other.loadSuccessCount()), LongMath.saturatedAdd((long)this.loadExceptionCount, (long)other.loadExceptionCount()), LongMath.saturatedAdd((long)this.totalLoadTime, (long)other.totalLoadTime()), LongMath.saturatedAdd((long)this.evictionCount, (long)other.evictionCount()));
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.hitCount, this.missCount, this.loadSuccessCount, this.loadExceptionCount, this.totalLoadTime, this.evictionCount});
    }

    public boolean equals(Object object) {
        if (object instanceof CacheStats) {
            CacheStats other = (CacheStats)object;
            return this.hitCount == other.hitCount() && this.missCount == other.missCount() && this.loadSuccessCount == other.loadSuccessCount() && this.loadExceptionCount == other.loadExceptionCount() && this.totalLoadTime == other.totalLoadTime() && this.evictionCount == other.evictionCount();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(": ");
        return sb.append("hitCount").append(this.hitCount).append(",").append("missCount").append(this.missCount).append(",").append("loadSuccessCount").append(this.loadSuccessCount).append(",").append("loadExceptionCount").append(this.loadExceptionCount).append(",").append("totalLoadTime").append(this.totalLoadTime).append(",").append("evictionCount").append(this.evictionCount).append(",").toString();
    }
}

