/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javassist.ClassPool;
import javassist.NotFoundException;

public class JarTypeSolver
implements TypeSolver {
    private static final String CLASS_EXTENSION = ".class";
    private final ClassPool classPool = new ClassPool();
    private final Map<String, String> knownClasses = new HashMap<String, String>();
    private TypeSolver parent;

    @Deprecated
    public static JarTypeSolver getJarTypeSolver(String pathToJar) throws IOException {
        return new JarTypeSolver(pathToJar);
    }

    private static String convertEntryPathToClassName(String entryPath) {
        if (!entryPath.endsWith(CLASS_EXTENSION)) {
            throw new IllegalArgumentException(String.format("The entry path should end with %s", CLASS_EXTENSION));
        }
        String className = entryPath.substring(0, entryPath.length() - CLASS_EXTENSION.length());
        className = className.replace('/', '.');
        className = className.replace('$', '.');
        return className;
    }

    private static String convertEntryPathToClassPoolName(String entryPath) {
        if (!entryPath.endsWith(CLASS_EXTENSION)) {
            throw new IllegalArgumentException(String.format("The entry path should end with %s", CLASS_EXTENSION));
        }
        String className = entryPath.substring(0, entryPath.length() - CLASS_EXTENSION.length());
        return className.replace('/', '.');
    }

    public JarTypeSolver(Path pathToJarOrClassFileHierarchy) throws IOException {
        this(pathToJarOrClassFileHierarchy.toFile());
    }

    public JarTypeSolver(File pathToJarOrClassFileHierarchy) throws IOException {
        this(pathToJarOrClassFileHierarchy.getAbsolutePath());
    }

    public JarTypeSolver(String pathToJarOrClassFileHierarchy) throws IOException {
        this.addPathToJar(pathToJarOrClassFileHierarchy);
    }

    public JarTypeSolver(InputStream jarInputStream) throws IOException {
        this.addPathToJar(this.dumpToTempFile(jarInputStream).getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File dumpToTempFile(InputStream inputStream) throws IOException {
        File tempFile = File.createTempFile("jar_file_from_input_stream", ".jar");
        tempFile.deleteOnExit();
        byte[] buffer = new byte[8192];
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, bytesRead);
            }
        }
        finally {
            inputStream.close();
        }
        return tempFile;
    }

    private void addPathToJar(String pathToJarOrClassFileHierarchy) throws IOException {
        try {
            this.classPool.appendClassPath(pathToJarOrClassFileHierarchy);
            this.registerKnownClassesFor(pathToJarOrClassFileHierarchy);
        }
        catch (NotFoundException e) {
            FileNotFoundException jarNotFound = new FileNotFoundException(e.getMessage());
            jarNotFound.initCause(e);
            throw jarNotFound;
        }
    }

    private void registerKnownClassesFor(String pathToJarOrClassFileHierarchy) throws IOException {
        Path jarOrClassFileHierarchy = Paths.get(pathToJarOrClassFileHierarchy, new String[0]);
        if (Files.isDirectory(jarOrClassFileHierarchy, new LinkOption[0])) {
            try (Stream<Path> classFiles = Files.walk(jarOrClassFileHierarchy, new FileVisitOption[0]);){
                classFiles.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(CLASS_EXTENSION)).forEach(pathToClassFile -> {
                    String packagePrefix = JarTypeSolver.convertPathToPackagePrefix(jarOrClassFileHierarchy, pathToClassFile);
                    String classFileName = pathToClassFile.getFileName().toString();
                    String classNameWithDollars = classFileName.substring(0, classFileName.length() - CLASS_EXTENSION.length());
                    String classPoolName = packagePrefix + classNameWithDollars;
                    String qualifiedName = packagePrefix + classNameWithDollars.replace('$', '.');
                    if (qualifiedName.equals(classPoolName)) {
                        this.knownClasses.put(qualifiedName, qualifiedName);
                    } else {
                        this.knownClasses.put(qualifiedName, classPoolName);
                    }
                });
            }
        }
        if (Files.isRegularFile(jarOrClassFileHierarchy, new LinkOption[0])) {
            try (JarFile jarFile = new JarFile(pathToJarOrClassFileHierarchy);){
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    String classPoolName;
                    JarEntry entry = jarEntries.nextElement();
                    if (entry.isDirectory() || !entry.getName().endsWith(CLASS_EXTENSION)) continue;
                    String qualifiedName = JarTypeSolver.convertEntryPathToClassName(entry.getName());
                    if (qualifiedName.equals(classPoolName = JarTypeSolver.convertEntryPathToClassPoolName(entry.getName()))) {
                        this.knownClasses.put(qualifiedName, qualifiedName);
                        continue;
                    }
                    this.knownClasses.put(qualifiedName, classPoolName);
                }
            }
        }
    }

    private static String convertPathToPackagePrefix(Path pathToClassFileHierarchy, Path pathToClassFile) {
        Path packagePath = pathToClassFileHierarchy.relativize(pathToClassFile).getParent();
        StringBuilder packagePrefixBuilder = new StringBuilder();
        if (packagePath != null) {
            for (Path component : packagePath) {
                packagePrefixBuilder.append(component.toString()).append('.');
            }
        }
        return packagePrefixBuilder.toString();
    }

    public Set<String> getKnownClasses() {
        return this.knownClasses.keySet();
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        Objects.requireNonNull(parent);
        if (this.parent != null) {
            throw new IllegalStateException("This TypeSolver already has a parent.");
        }
        if (parent == this) {
            throw new IllegalStateException("The parent of this TypeSolver cannot be itself.");
        }
        this.parent = parent;
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        String storedKey = this.knownClasses.get(name);
        if (storedKey == null) {
            return SymbolReference.unsolved();
        }
        try {
            return SymbolReference.solved((ResolvedDeclaration)JavassistFactory.toTypeDeclaration(this.classPool.get(storedKey), this.getRoot()));
        }
        catch (NotFoundException e) {
            throw new IllegalStateException(String.format("Unable to get class with name %s from class pool.This was not suppose to happen, please report at https://github.com/javaparser/javaparser/issues", storedKey));
        }
    }

    public ResolvedReferenceTypeDeclaration solveType(String name) throws UnsolvedSymbolException {
        SymbolReference<ResolvedReferenceTypeDeclaration> ref = this.tryToSolveType(name);
        if (ref.isSolved()) {
            return (ResolvedReferenceTypeDeclaration)ref.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }
}

