/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.Disposable;
import better.files.Disposable$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public class Dispose<A> {
    private final Object resource;
    private final Disposable<A> disposer;
    private final AtomicBoolean isDisposed;

    public Dispose(A resource, Disposable<A> disposer) {
        this.resource = resource;
        this.disposer = disposer;
        this.isDisposed = new AtomicBoolean(false);
    }

    public A resource() {
        return (A)this.resource;
    }

    public AtomicBoolean isDisposed() {
        return this.isDisposed;
    }

    public void disposeOnce() {
        if (!this.isDisposed().getAndSet(true)) {
            this.disposer.dispose(this.resource());
            return;
        }
    }

    public Nothing$ disposeOnceAndThrow(Throwable e1) {
        try {
            this.disposeOnce();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e2 = throwable3 = (Throwable)option.get();
                e1.addSuppressed(e2);
            }
            if (throwable2 != null) {
                Throwable e2 = throwable2;
                e2.addSuppressed(e1);
                throw e2;
            }
            throw throwable;
        }
        throw e1;
    }

    public <U> Dispose<A> withAdditionalDisposeTask(Function0<U> f) {
        return new Dispose<A>(this.resource(), Disposable$.MODULE$.apply((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.withAdditionalDisposeTask$$anonfun$1(f);
            return BoxedUnit.UNIT;
        }));
    }

    public <B> B apply(Function1<A, B> f) {
        Object object;
        try {
            try {
                object = f.apply(this.resource());
            }
            catch (Throwable e1) {
                throw this.disposeOnceAndThrow(e1);
            }
        }
        finally {
            this.disposeOnce();
        }
        return (B)object;
    }

    public A get() {
        return (A)this.apply((Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    public <U> void foreach(Function1<A, U> f) {
        U u = this.apply(f);
    }

    public <B> Dispose<B> map(Function1<A, B> f) {
        return new Dispose<Object>(f.apply(this.resource()), Disposable$.MODULE$.apply((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.map$$anonfun$1();
            return BoxedUnit.UNIT;
        }));
    }

    public Dispose withFilter(Function1<A, Object> f) {
        if (!BoxesRunTime.unboxToBoolean((Object)f.apply(this.resource()))) {
            this.disposeOnce();
        }
        return this;
    }

    public <B, F> Object flatMap(Function1<A, Object> f, FlatMap<F> fv) {
        return fv.apply(this, f);
    }

    private final void withAdditionalDisposeTask$$anonfun$1(Function0 f$1) {
        try {
            this.disposeOnce();
        }
        finally {
            Object object = f$1.apply();
        }
    }

    private final void map$$anonfun$1() {
        this.disposeOnce();
    }

    public static interface FlatMap<F> {
        public <A, B> Object apply(Dispose<A> var1, Function1<A, F> var2);
    }
}

