/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.Dsl;
import better.files.File;
import better.files.File$;
import better.files.File$CopyOptions$;
import better.files.package$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ModuleSerializationProxy;

public final class Dsl$
implements Serializable {
    private static final Function1 $u002E$u002E;
    private static final Function1 $u002E;
    public static final Dsl$ MODULE$;

    private Dsl$() {
    }

    static {
        MODULE$ = new Dsl$();
        $u002E$u002E = (Function1 & Serializable)_$1 -> _$1.parent();
        $u002E = (Function1 & Serializable)x -> (File)Predef$.MODULE$.identity(x);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Dsl$.class);
    }

    public File $tilde() {
        return File$.MODULE$.home();
    }

    public File pwd() {
        return File$.MODULE$.currentWorkingDirectory();
    }

    public File cwd() {
        return this.pwd();
    }

    public Function1<File, File> $u002E$u002E() {
        return $u002E$u002E;
    }

    public Function1<File, File> $u002E() {
        return $u002E;
    }

    public final Dsl.SymbolicOperations SymbolicOperations(File file) {
        return new Dsl.SymbolicOperations(file);
    }

    public File cp(File from, File to) {
        if (to.isDirectory(to.isDirectory$default$1())) {
            return from.copyToDirectory(to, from.copyToDirectory$default$2(to), from.copyToDirectory$default$3(to));
        }
        return from.copyTo(to, true, from.copyTo$default$3(to, true));
    }

    public File mv(File from, File to) {
        if (to.isDirectory(to.isDirectory$default$1())) {
            return from.moveToDirectory(to, from.moveToDirectory$default$2(to));
        }
        return from.moveTo(to, File$CopyOptions$.MODULE$.apply(true));
    }

    public File rm(File file) {
        return file.delete(true, file.delete$default$2());
    }

    public File del(File file) {
        return this.rm(file);
    }

    public File ln(File file1, File file2) {
        boolean bl = file1.linkTo$default$2();
        return file1.linkTo(file2, bl, file1.linkTo$default$3(file2, bl));
    }

    public File ln_s(File file1, File file2) {
        return file1.symbolicLinkTo(file2, file1.symbolicLinkTo$default$2(file2));
    }

    public Seq<Iterator<Object>> cat(Seq<File> files) {
        return (Seq)files.map((Function1 & Serializable)_$2 -> _$2.bytes());
    }

    public Iterator<File> ls(File file) {
        return file.list();
    }

    public Iterator<File> dir(File file) {
        return this.ls(file);
    }

    public Iterator<File> ls_r(File file) {
        return file.listRecursively(file.listRecursively$default$1());
    }

    public File touch(File file) {
        Instant instant = file.touch$default$1();
        return file.touch(instant, file.touch$default$2(instant), file.touch$default$3(instant));
    }

    public File mkdir(File file) {
        return file.createDirectory(file.createDirectory$default$1());
    }

    public String md5(File file) {
        return file.md5();
    }

    public String sha1(File file) {
        return file.sha1();
    }

    public String sha256(File file) {
        return file.sha256();
    }

    public String sha512(File file) {
        return file.sha512();
    }

    public File mkdirs(File file) {
        return file.createDirectories(file.createDirectories$default$1(), file.createDirectories$default$2());
    }

    public File chown(String owner, File file) {
        return file.setOwner(owner);
    }

    public File chgrp(String group, File file) {
        return file.setGroup(group, file.setGroup$default$2(group));
    }

    public File chmod(String permissions, File file) {
        return file.setPermissions((Set<PosixFilePermission>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(PosixFilePermissions.fromString(permissions)).asScala()).toSet());
    }

    public File chmod_$plus(PosixFilePermission permission, File file) {
        return file.addPermission(permission, file.addPermission$default$2(permission));
    }

    public File chmod_$minus(PosixFilePermission permission, File file) {
        return file.removePermission(permission, file.removePermission$default$2(permission));
    }

    public PosixFileAttributes stat(File file) {
        return file.posixAttributes(file.posixAttributes$default$1());
    }

    public File unzip(File zipFile, File destination, Charset charset) {
        return zipFile.unzipTo(destination, zipFile.unzipTo$default$2(), charset);
    }

    public Charset unzip$default$3(File zipFile, File destination) {
        return package$.MODULE$.DefaultCharset();
    }

    public File zip(Seq<File> files, File destination, int compressionLevel, Charset charset) {
        return destination.zipIn((Iterator<File>)files.iterator(), compressionLevel, charset);
    }

    public int zip$default$3(Seq<File> files) {
        return -1;
    }

    public Charset zip$default$4(Seq<File> files, File destination, int compressionLevel) {
        return package$.MODULE$.DefaultCharset();
    }

    public File ungzip(File gzipFile, File destination) {
        return gzipFile.unGzipTo(destination, gzipFile.unGzipTo$default$2(), gzipFile.unGzipTo$default$3());
    }

    public File gzip(File file, File destination) {
        return file.gzipTo(destination, file.gzipTo$default$2(), file.gzipTo$default$3(), file.gzipTo$default$4());
    }
}

