/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.c2cpg.parser;

import io.appthreat.c2cpg.parser.CdtParser$;
import io.appthreat.c2cpg.parser.HeaderFileFinder;
import java.io.Serializable;
import java.nio.file.Paths;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Option$;

public class CustomFileContentProvider
extends InternalFileContentProvider {
    private final HeaderFileFinder headerFileFinder;
    private final Logger logger;

    public CustomFileContentProvider(HeaderFileFinder headerFileFinder) {
        this.headerFileFinder = headerFileFinder;
        this.logger = LoggerFactory.getLogger(CustomFileContentProvider.class);
    }

    private InternalFileContent loadContent(String path) {
        Option<String> maybeFullPath = !this.getInclusionExists(path) ? this.headerFileFinder.find(path) : Option$.MODULE$.apply((Object)path);
        return (InternalFileContent)maybeFullPath.map((Function1 & Serializable)foundPath -> {
            this.logger.debug("Loading header file '" + foundPath + "'");
            return (InternalFileContent)CdtParser$.MODULE$.readFileAsFileContent(Paths.get(foundPath, new String[0]));
        }).getOrElse(() -> this.loadContent$$anonfun$2(path));
    }

    public InternalFileContent getContentForInclusion(String path, IMacroDictionary macroDictionary) {
        return this.loadContent(path);
    }

    public InternalFileContent getContentForInclusion(IIndexFileLocation ifl, String astPath) {
        return this.loadContent(astPath);
    }

    private final InternalFileContent loadContent$$anonfun$2(String path$1) {
        this.logger.debug("Cannot find header file for '" + path$1 + "'");
        return null;
    }
}

