/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.c2cpg.passes;

import io.appthreat.c2cpg.Config;
import io.appthreat.c2cpg.astcreation.AstCreator;
import io.appthreat.c2cpg.parser.CdtParser;
import io.appthreat.c2cpg.parser.FileDefaults$;
import io.appthreat.c2cpg.passes.AstCreationPass$;
import io.appthreat.x2cpg.SourceFiles$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import overflowdb.BatchedUpdate;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public class AstCreationPass
extends ConcurrentWriterCpgPass<String> {
    private final Config config;
    private final FiniteDuration timeoutDuration;
    private final FiniteDuration parseTimeoutDuration;
    private final ConcurrentHashMap<String, int[]> file2OffsetTable;
    private final CdtParser parser;
    private final List<Regex> DefaultIgnoredFolders;

    public static FiniteDuration $lessinit$greater$default$3() {
        return AstCreationPass$.MODULE$.$lessinit$greater$default$3();
    }

    public static FiniteDuration $lessinit$greater$default$4() {
        return AstCreationPass$.MODULE$.$lessinit$greater$default$4();
    }

    public AstCreationPass(Cpg cpg, Config config, FiniteDuration timeoutDuration, FiniteDuration parseTimeoutDuration) {
        this.config = config;
        this.timeoutDuration = timeoutDuration;
        this.parseTimeoutDuration = parseTimeoutDuration;
        super(cpg, ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2(), ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.file2OffsetTable = new ConcurrentHashMap();
        this.parser = new CdtParser(config);
        String EscapedFileSeparator = Pattern.quote(File.separator);
        this.DefaultIgnoredFolders = (List)new .colon.colon((Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\..*")), (List)new .colon.colon((Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(.*[" + EscapedFileSeparator + "])?tests?[" + EscapedFileSeparator + "].*")), (List)new .colon.colon((Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(.*[" + EscapedFileSeparator + "])?CMakeFiles[" + EscapedFileSeparator + "].*")), (List)Nil$.MODULE$)));
    }

    public String[] generateParts() {
        String string = this.config.inputPath();
        Set set = (Set)FileDefaults$.MODULE$.SOURCE_FILE_EXTENSIONS().$plus$plus(FileDefaults$.MODULE$.HEADER_FILE_EXTENSIONS());
        Option option = Option$.MODULE$.apply(this.DefaultIgnoredFolders);
        Option option2 = Option$.MODULE$.apply((Object)this.config.ignoredFilesRegex());
        Option option3 = Option$.MODULE$.apply((Object)this.config.ignoredFiles());
        return (String[])((IterableOnceOps)SourceFiles$.MODULE$.determine(string, set, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, set, option, option2, option3)).sortWith((Function2 & Serializable)(_$1, _$2) -> _$1.compareToIgnoreCase((String)_$2) > 0)).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder diffGraph, String filename) {
        Path path = Paths.get(filename, new String[0]).toAbsolutePath();
        String relPath = SourceFiles$.MODULE$.toRelativePath(path.toString(), this.config.inputPath());
        ExecutorService computationExecutor = Executors.newVirtualThreadPerTaskExecutor();
        try {
            try {
                IASTTranslationUnit iASTTranslationUnit;
                Option parseResult;
                Future<Option> parseFuture = computationExecutor.submit(() -> this.parser.parse(path));
                Option option = parseResult = this.runWithTimeout(parseFuture, this.parseTimeoutDuration, computationExecutor);
                if (option instanceof Some && (iASTTranslationUnit = (IASTTranslationUnit)((Some)option).value()) != null) {
                    IASTTranslationUnit translationUnit = iASTTranslationUnit;
                    Future<BatchedUpdate.DiffGraphBuilder> astFuture = computationExecutor.submit(() -> new AstCreator(relPath, this.config, translationUnit, this.file2OffsetTable, this.config.schemaValidation()).createAst());
                    BatchedUpdate.DiffGraphBuilder localDiff = this.runWithTimeout(astFuture, this.timeoutDuration, computationExecutor);
                    diffGraph.absorb(localDiff);
                } else if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
            }
            catch (TimeoutException e) {
                Predef$.MODULE$.println((Object)("Timeout occurred during processing for file: " + filename + ": " + e.getMessage()));
            }
            catch (Throwable e) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace());
                Predef$.MODULE$.println((Object)("Exception occurred during processing for file: " + filename + ": " + e.getMessage() + " - " + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object, 40)).mkString("\n")));
                throw e;
            }
        }
        catch (Throwable throwable) {
            computationExecutor.shutdown();
            try {
                if (!computationExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    computationExecutor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                computationExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        computationExecutor.shutdown();
        try {
            if (!computationExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                computationExecutor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            computationExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private <T> T runWithTimeout(Future<T> future, FiniteDuration timeout, ExecutorService executor) {
        T t;
        try {
            t = future.get(timeout.toMinutes(), TimeUnit.MINUTES);
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            throw new TimeoutException("Operation timed out after " + timeout);
        }
        return t;
    }
}

