/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.c2cpg.utils;

import io.appthreat.c2cpg.Config;
import io.appthreat.c2cpg.utils.ExternalCommand$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Success;
import scala.util.Try;

public final class IncludeAutoDiscovery$
implements Serializable {
    private static final Logger logger;
    private static final String GCC_VERSION_COMMAND;
    private static final String GCC_CPP_INCLUDE_COMMAND;
    private static final String GCC_C_INCLUDE_COMMAND;
    private static final String CLANG_VERSION_COMMAND;
    private static final String CLANG_CPP_INCLUDE_COMMAND;
    private static final String CLANG_C_INCLUDE_COMMAND;
    private static Option<Object> isGccAvailable;
    private static Set<Path> systemIncludePathsC_GCC;
    private static Set<Path> systemIncludePathsCPP_GCC;
    private static Option<Object> isClangAvailable;
    private static Set<Path> systemIncludePathsC_Clang;
    private static Set<Path> systemIncludePathsCPP_Clang;
    public static final IncludeAutoDiscovery$ MODULE$;

    private IncludeAutoDiscovery$() {
    }

    static {
        MODULE$ = new IncludeAutoDiscovery$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        boolean IS_WIN = Properties$.MODULE$.isWin();
        GCC_VERSION_COMMAND = "gcc --version";
        GCC_CPP_INCLUDE_COMMAND = IS_WIN ? "gcc -xc++ -E -v . -o nul" : "gcc -xc++ -E -v /dev/null -o /dev/null";
        GCC_C_INCLUDE_COMMAND = IS_WIN ? "gcc -xc -E -v . -o nul" : "gcc -xc -E -v /dev/null -o /dev/null";
        CLANG_VERSION_COMMAND = "clang --version";
        CLANG_CPP_INCLUDE_COMMAND = IS_WIN ? "clang -xc++ -E -v . -o nul" : "clang -xc++ -E -v /dev/null -o /dev/null";
        CLANG_C_INCLUDE_COMMAND = IS_WIN ? "clang -xc -E -v . -o nul" : "clang -xc -E -v /dev/null -o /dev/null";
        isGccAvailable = None$.MODULE$;
        systemIncludePathsC_GCC = Predef$.MODULE$.Set().empty();
        systemIncludePathsCPP_GCC = Predef$.MODULE$.Set().empty();
        isClangAvailable = None$.MODULE$;
        systemIncludePathsC_Clang = Predef$.MODULE$.Set().empty();
        systemIncludePathsCPP_Clang = Predef$.MODULE$.Set().empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IncludeAutoDiscovery$.class);
    }

    public String GCC_VERSION_COMMAND() {
        return GCC_VERSION_COMMAND;
    }

    public String CLANG_VERSION_COMMAND() {
        return CLANG_VERSION_COMMAND;
    }

    private boolean checkForGcc() {
        Try<Seq<String>> try_ = ExternalCommand$.MODULE$.run(this.GCC_VERSION_COMMAND());
        if (try_ instanceof Success) {
            Seq result = (Seq)((Success)try_).value();
            logger.debug("GCC is available: " + result.mkString(System.lineSeparator()));
            return true;
        }
        logger.warn("GCC is not installed. Discovery of system include paths will not be available.");
        return false;
    }

    public boolean gccAvailable() {
        Option<Object> option = isGccAvailable;
        if (option instanceof Some) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            return value;
        }
        if (None$.MODULE$.equals(option)) {
            isGccAvailable = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.checkForGcc()));
            return BoxesRunTime.unboxToBoolean((Object)isGccAvailable.get());
        }
        throw new MatchError(option);
    }

    private Set<Path> extractPaths(Seq<String> output) {
        int startIndex = output.indexWhere((Function1 & Serializable)_$1 -> _$1.contains("#include <...> search starts here:"));
        if (startIndex == -1) {
            logger.warn("Could not find start marker for include paths in compiler output.");
            return Predef$.MODULE$.Set().empty();
        }
        int endIndex = output.indexWhere((Function1 & Serializable)_$2 -> _$2.startsWith("End of search list."), startIndex + 1);
        if (endIndex == -1) {
            logger.warn("Could not find end marker for include paths in compiler output.");
            return Predef$.MODULE$.Set().empty();
        }
        return ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)output.slice(startIndex + 1, endIndex)).map((Function1 & Serializable)_$3 -> _$3.trim())).filter((Function1 & Serializable)_$4 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$4)))).map((Function1 & Serializable)p -> Paths.get(p, new String[0]).toAbsolutePath())).toSet();
    }

    private Set<Path> discoverPathsGCC(String command) {
        Try<Seq<String>> try_ = ExternalCommand$.MODULE$.run(command);
        if (try_ instanceof Success) {
            Seq output = (Seq)((Success)try_).value();
            return this.extractPaths((Seq<String>)output);
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            logger.warn("Unable to discover system include paths with GCC. Running '" + command + "' failed.", exception);
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError(try_);
    }

    private boolean checkForClang() {
        Try<Seq<String>> try_ = ExternalCommand$.MODULE$.run(this.CLANG_VERSION_COMMAND());
        if (try_ instanceof Success) {
            Seq result = (Seq)((Success)try_).value();
            logger.debug("Clang is available: " + result.mkString(System.lineSeparator()));
            return true;
        }
        logger.warn("Clang is not installed. Discovery of system include paths will not be available.");
        return false;
    }

    private boolean isClangAvailableCheck() {
        Option<Object> option = isClangAvailable;
        if (option instanceof Some) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            return value;
        }
        if (None$.MODULE$.equals(option)) {
            isClangAvailable = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.checkForClang()));
            return BoxesRunTime.unboxToBoolean((Object)isClangAvailable.get());
        }
        throw new MatchError(option);
    }

    private Set<Path> discoverPathsClang(String command) {
        Try<Seq<String>> try_ = ExternalCommand$.MODULE$.run(command);
        if (try_ instanceof Success) {
            Seq output = (Seq)((Success)try_).value();
            return this.extractPaths((Seq<String>)output);
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            logger.warn("Unable to discover system include paths with Clang. Running '" + command + "' failed.", exception);
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError(try_);
    }

    public Set<Path> discoverIncludePathsC_GCC(Config config) {
        if (config.includePathsAutoDiscovery() && systemIncludePathsC_GCC.nonEmpty()) {
            return systemIncludePathsC_GCC;
        }
        if (config.includePathsAutoDiscovery() && systemIncludePathsC_GCC.isEmpty() && this.gccAvailable()) {
            Set<Path> includePathsC = this.discoverPathsGCC(GCC_C_INCLUDE_COMMAND);
            if (includePathsC.nonEmpty()) {
                logger.debug("Using the following GCC C system include paths:" + includePathsC.mkString(System.lineSeparator() + "- ", System.lineSeparator() + "- ", System.lineSeparator()));
            }
            systemIncludePathsC_GCC = includePathsC;
            return includePathsC;
        }
        return Predef$.MODULE$.Set().empty();
    }

    public Set<Path> discoverIncludePathsCPP_GCC(Config config) {
        if (config.includePathsAutoDiscovery() && systemIncludePathsCPP_GCC.nonEmpty()) {
            return systemIncludePathsCPP_GCC;
        }
        if (config.includePathsAutoDiscovery() && systemIncludePathsCPP_GCC.isEmpty() && this.gccAvailable()) {
            Set<Path> includePathsCPP = this.discoverPathsGCC(GCC_CPP_INCLUDE_COMMAND);
            if (includePathsCPP.nonEmpty()) {
                logger.debug("Using the following GCC CPP system include paths:" + includePathsCPP.mkString(System.lineSeparator() + "- ", System.lineSeparator() + "- ", System.lineSeparator()));
            }
            systemIncludePathsCPP_GCC = includePathsCPP;
            return includePathsCPP;
        }
        return Predef$.MODULE$.Set().empty();
    }

    public Set<Path> discoverIncludePathsC_Clang(Config config) {
        if (config.includePathsAutoDiscovery() && systemIncludePathsC_Clang.nonEmpty()) {
            return systemIncludePathsC_Clang;
        }
        if (config.includePathsAutoDiscovery() && systemIncludePathsC_Clang.isEmpty() && this.isClangAvailableCheck()) {
            Set<Path> includePathsC = this.discoverPathsClang(CLANG_C_INCLUDE_COMMAND);
            if (includePathsC.nonEmpty()) {
                logger.debug("Using the following Clang C system include paths:" + includePathsC.mkString(System.lineSeparator() + "- ", System.lineSeparator() + "- ", System.lineSeparator()));
            }
            systemIncludePathsC_Clang = includePathsC;
            return includePathsC;
        }
        return Predef$.MODULE$.Set().empty();
    }

    public Set<Path> discoverIncludePathsCPP_Clang(Config config) {
        if (config.includePathsAutoDiscovery() && systemIncludePathsCPP_Clang.nonEmpty()) {
            return systemIncludePathsCPP_Clang;
        }
        if (config.includePathsAutoDiscovery() && systemIncludePathsCPP_Clang.isEmpty() && this.isClangAvailableCheck()) {
            Set<Path> includePathsCPP = this.discoverPathsClang(CLANG_CPP_INCLUDE_COMMAND);
            if (includePathsCPP.nonEmpty()) {
                logger.debug("Using the following Clang CPP system include paths:" + includePathsCPP.mkString(System.lineSeparator() + "- ", System.lineSeparator() + "- ", System.lineSeparator()));
            }
            systemIncludePathsCPP_Clang = includePathsCPP;
            return includePathsCPP;
        }
        return Predef$.MODULE$.Set().empty();
    }

    public Set<Path> discoverIncludePathsC(Config config) {
        return (Set)this.discoverIncludePathsC_GCC(config).$plus$plus(this.discoverIncludePathsC_Clang(config));
    }

    public Set<Path> discoverIncludePathsCPP(Config config) {
        return (Set)this.discoverIncludePathsCPP_GCC(config).$plus$plus(this.discoverIncludePathsCPP_Clang(config));
    }
}

