/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft;

import com.google.protobuf.GeneratedMessageV3;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class SerializedCpg
implements AutoCloseable {
    private FileSystem zipFileSystem;
    private int counter = 0;

    public SerializedCpg() {
    }

    public SerializedCpg(String filename) {
        this();
        this.initZipFilesystem(filename);
    }

    public boolean isEmpty() {
        return this.zipFileSystem == null;
    }

    private void initZipFilesystem(String filename) throws IOException, URISyntaxException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("create", "true");
        env.put("useTempFile", Boolean.TRUE);
        URI fileUri = new File(filename).toURI();
        URI outputUri = new URI("jar:" + fileUri.getScheme(), null, fileUri.getPath(), null);
        this.zipFileSystem = FileSystems.newFileSystem(outputUri, env);
    }

    public void addOverlay(GeneratedMessageV3 overlay, String name) throws IOException {
        if (!this.isEmpty()) {
            Path pathInZip = this.zipFileSystem.getPath(this.counter + "_" + name, new String[0]);
            ++this.counter;
            OutputStream outputStream = Files.newOutputStream(pathInZip, new OpenOption[0]);
            overlay.writeTo(outputStream);
            outputStream.close();
            return;
        }
    }

    public void addOverlay(Iterator<GeneratedMessageV3> overlays, String name) throws IOException {
        overlays.zipWithIndex().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                GeneratedMessageV3 overlay = (GeneratedMessageV3)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.addOverlay(overlay, name + "_" + i);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public void close() throws IOException {
        if (!this.isEmpty()) {
            this.zipFileSystem.close();
            return;
        }
    }
}

