/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.cpgloading;

import com.google.protobuf.GeneratedMessageV3;
import io.shiftleft.codepropertygraph.cpgloading.ProtoToCpg;
import io.shiftleft.codepropertygraph.cpgloading.TmpEdge;
import io.shiftleft.codepropertygraph.cpgloading.ZipArchive;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.proto.cpg.Cpg;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import overflowdb.Config;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

public final class ProtoCpgLoader$
implements Serializable {
    public static final ProtoCpgLoader$ MODULE$ = new ProtoCpgLoader$();

    private ProtoCpgLoader$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProtoCpgLoader$.class);
    }

    public Cpg loadFromProtoZip(String fileName, Config overflowDbConfig) {
        return (Cpg)this.measureAndReport(() -> ProtoCpgLoader$.loadFromProtoZip$$anonfun$1(overflowDbConfig, fileName));
    }

    public Config loadFromProtoZip$default$2() {
        return Config.withoutOverflow();
    }

    public Cpg loadFromListOfProtos(Seq<Cpg.CpgStruct> cpgs, Config overflowDbConfig) {
        ProtoToCpg builder = new ProtoToCpg(overflowDbConfig);
        cpgs.foreach((Function1)(JProcedure1 & Serializable)cpg -> builder.addNodes(cpg.getNodeList()));
        cpgs.foreach((Function1)(JProcedure1 & Serializable)cpg -> CollectionConverters$.MODULE$.ListHasAsScala(cpg.getEdgeList()).asScala().foreach((Function1)(JProcedure1 & Serializable)edge -> builder.addEdge(edge.getDst(), edge.getSrc(), edge.getType(), (Iterable<Cpg.CpgStruct.Edge.Property>)CollectionConverters$.MODULE$.ListHasAsScala(edge.getPropertyList()).asScala())));
        return builder.build();
    }

    public Cpg loadFromListOfProtos(List<Cpg.CpgStruct> cpgs, Config overflowDbConfig) {
        return this.loadFromListOfProtos((Seq<Cpg.CpgStruct>)CollectionConverters$.MODULE$.ListHasAsScala(cpgs).asScala().toSeq(), overflowDbConfig);
    }

    public Try<Iterator<Cpg.CpgOverlay>> loadOverlays(String fileName) {
        return this.loadOverlays(fileName, (Function1 & Serializable)x$0 -> Cpg.CpgOverlay.parseFrom((InputStream)x$0));
    }

    private <T extends GeneratedMessageV3> Try<Iterator<T>> loadOverlays(String fileName, Function1<InputStream, T> f) {
        return Using$.MODULE$.apply(() -> ProtoCpgLoader$.loadOverlays$$anonfun$2(fileName), (Function1 & Serializable)zip -> ((IterableOnce)((IterableOps)zip.entries().sortWith((Function2 & Serializable)(a, b) -> MODULE$.compareOverlayPath((Path)a, (Path)b))).map((Function1 & Serializable)path -> {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            return (GeneratedMessageV3)f.apply((Object)is);
        })).iterator(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private boolean compareOverlayPath(Path a, Path b) {
        String[] file1Split = a.toString().replace("/", "").split("_");
        String[] file2Split = b.toString().replace("/", "").split("_");
        if (file1Split.length < 2 || file2Split.length < 2) {
            return StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(a.toString()), b.toString());
        }
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(file1Split[0])) < StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(file2Split[0]));
    }

    private Cpg.CpgStruct getNextProtoCpgFromStream(InputStream inputStream) {
        return Cpg.CpgStruct.parseFrom((InputStream)inputStream);
    }

    private <A> A measureAndReport(Function0<A> f) {
        long start = System.currentTimeMillis();
        Object result = f.apply();
        return (A)result;
    }

    private static final Cpg loadFromProtoZip$$anonfun$1(Config overflowDbConfig$1, String fileName$1) {
        ProtoToCpg builder = new ProtoToCpg(overflowDbConfig$1);
        Try try_ = Using.Manager$.MODULE$.apply((Function1)(JProcedure1 & Serializable)use -> {
            ArrayDeque edges = ArrayDeque$.MODULE$.empty();
            ((ZipArchive)use.apply((Object)new ZipArchive(fileName$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$)).entries().foreach((Function1)(JProcedure1 & Serializable)entry -> {
                InputStream inputStream = (InputStream)use.apply((Object)Files.newInputStream(entry, new OpenOption[0]), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Cpg.CpgStruct cpgStruct = MODULE$.getNextProtoCpgFromStream(inputStream);
                builder.addNodes(cpgStruct.getNodeList());
                CollectionConverters$.MODULE$.ListHasAsScala(cpgStruct.getEdgeList()).asScala().foreach((Function1 & Serializable)edge -> (ArrayDeque)edges.append((Object)new TmpEdge((Cpg.CpgStruct.Edge)edge)));
            });
            while (edges.nonEmpty()) {
                TmpEdge edge = (TmpEdge)edges.removeHead(edges.removeHead$default$1());
                builder.addEdge(edge.dst(), edge.src(), Cpg.CpgStruct$.Edge$.EdgeType.forNumber((int)edge.typ()), (Iterable<Cpg.CpgStruct.Edge.Property>)edge.properties());
            }
        });
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            throw exception;
        }
        if (try_ instanceof Success) {
            return builder.build();
        }
        throw new MatchError((Object)try_);
    }

    private static final ZipArchive loadOverlays$$anonfun$2(String fileName$3) {
        return new ZipArchive(fileName$3);
    }
}

