/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.cpgloading;

import io.shiftleft.codepropertygraph.Cpg$;
import io.shiftleft.codepropertygraph.cpgloading.NodeFilter;
import io.shiftleft.codepropertygraph.cpgloading.ProtoToCpg$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.proto.cpg.Cpg;
import io.shiftleft.utils.StringInterner;
import io.shiftleft.utils.StringInterner$;
import java.io.Serializable;
import java.util.Collection;
import java.util.NoSuchElementException;
import overflowdb.Config;
import overflowdb.Graph;
import overflowdb.GraphSugar$;
import overflowdb.Node;
import overflowdb.NodeSugar$;
import overflowdb.Property;
import overflowdb.package$;
import scala.Function1;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;

public class ProtoToCpg {
    private final NodeFilter nodeFilter = new NodeFilter();
    private final Graph odbGraph;
    private final StringInterner interner;

    public static Property<Object> toProperty(Tuple2<String, Cpg.PropertyValue> tuple2, StringInterner stringInterner) {
        return ProtoToCpg$.MODULE$.toProperty(tuple2, stringInterner);
    }

    public static Config $lessinit$greater$default$1() {
        return ProtoToCpg$.MODULE$.$lessinit$greater$default$1();
    }

    public ProtoToCpg(Config overflowConfig) {
        this.odbGraph = Cpg$.MODULE$.withConfig(overflowConfig).graph();
        this.interner = StringInterner$.MODULE$.makeStrongInterner(StringInterner$.MODULE$.makeStrongInterner$default$1(), StringInterner$.MODULE$.makeStrongInterner$default$2());
    }

    public Graph graph() {
        return this.odbGraph;
    }

    public void addNodes(Collection<Cpg.CpgStruct.Node> nodes) {
        this.addNodes((Iterable<Cpg.CpgStruct.Node>)CollectionConverters$.MODULE$.CollectionHasAsScala(nodes).asScala());
    }

    public void addNodes(Iterable<Cpg.CpgStruct.Node> nodes) {
        ((IterableOnceOps)nodes.filter((Function1 & Serializable)protoNode -> this.nodeFilter.filterNode((Cpg.CpgStruct.Node)protoNode))).foreach((Function1 & Serializable)node -> this.addNodeToOdb((Cpg.CpgStruct.Node)node));
    }

    private Node addNodeToOdb(Cpg.CpgStruct.Node node) {
        Node node2;
        Seq properties = (Seq)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(node.getPropertyList()).asScala().toSeq().map((Function1 & Serializable)prop -> Tuple2$.MODULE$.apply((Object)prop.getName().name(), (Object)prop.getValue()))).map((Function1 & Serializable)keyValue -> ProtoToCpg$.MODULE$.toProperty((Tuple2<String, Cpg.PropertyValue>)keyValue, this.interner));
        try {
            if (node.getKey() == -1L) {
                throw new IllegalArgumentException("node has illegal key -1. Something is wrong with the cpg.");
            }
            node2 = GraphSugar$.MODULE$.$plus$extension(package$.MODULE$.toGraphSugar(this.odbGraph), node.getType().name(), node.getKey(), properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to insert a node. proto:\n" + node, e);
        }
        return node2;
    }

    public void addEdge(long dst, long src, Cpg.CpgStruct$.Edge$.EdgeType typ, Iterable<Cpg.CpgStruct.Edge.Property> properties) {
        Node srcNode = this.findNodeById(src, typ);
        Node dstNode = this.findNodeById(dst, typ);
        Seq propertyPairs = (Seq)((IterableOps)properties.toSeq().map((Function1 & Serializable)prop -> Tuple2$.MODULE$.apply((Object)prop.getName().name(), (Object)prop.getValue()))).map((Function1 & Serializable)keyValue -> ProtoToCpg$.MODULE$.toProperty((Tuple2<String, Cpg.PropertyValue>)keyValue, this.interner));
        try {
            NodeSugar$.MODULE$.$minus$minus$minus$extension(package$.MODULE$.toNodeSugar(srcNode), typ.name(), propertyPairs).$minus$minus$greater(dstNode);
        }
        catch (IllegalArgumentException e) {
            String context = "label=" + typ.name() + ", srcNodeId=" + src + ", dstNodeId=" + dst + ", srcNode=" + srcNode + ", dstNode=" + dstNode;
        }
    }

    public Cpg build() {
        return new Cpg(this.odbGraph);
    }

    private Node findNodeById(long nodeId, Cpg.CpgStruct$.Edge$.EdgeType typ) {
        if (nodeId == -1L) {
            throw new IllegalArgumentException("Illegal src|dst node ID -1 on edge of type " + typ.name());
        }
        return (Node)GraphSugar$.MODULE$.nodeOption$extension(package$.MODULE$.toGraphSugar(this.odbGraph), nodeId).getOrElse(() -> ProtoToCpg.findNodeById$$anonfun$1(nodeId, typ));
    }

    private static final Node findNodeById$$anonfun$1(long nodeId$1, Cpg.CpgStruct$.Edge$.EdgeType typ$1) {
        throw new NoSuchElementException("Couldn't find src|dst node " + nodeId$1 + " for edge of type " + typ$1.name());
    }
}

