/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.utils;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

public final class IOUtils$
implements Serializable {
    private static final Pattern surrogatePattern;
    private static final Set<Object> boms;
    public static final IOUtils$ MODULE$;

    private IOUtils$() {
    }

    static {
        MODULE$ = new IOUtils$();
        surrogatePattern = Pattern.compile("[^\u0000-\uffff]");
        boms = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'\uefbb', '\ufeff', '\ufffe'}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IOUtils$.class);
    }

    private CharsetDecoder createDecoder() {
        return Codec$.MODULE$.UTF8().decoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private void skipBOMIfPresent(Reader reader) {
        reader.mark(1);
        char[] possibleBOM = new char[1];
        reader.read(possibleBOM);
        if (!boms.contains((Object)BoxesRunTime.boxToCharacter((char)possibleBOM[0]))) {
            reader.reset();
            return;
        }
    }

    private String replaceUnpairedSurrogates(String input) {
        Matcher matches = surrogatePattern.matcher(input);
        if (matches.find()) {
            int size = matches.end() - matches.start();
            return matches.replaceAll(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("?"), size));
        }
        return input;
    }

    private Seq<String> contentFromBufferedSource(BufferedSource bufferedSource) {
        BufferedReader reader = bufferedSource.bufferedReader();
        this.skipBOMIfPresent(reader);
        return CollectionConverters$.MODULE$.IteratorHasAsScala(reader.lines().iterator()).asScala().map((Function1 & Serializable)input -> MODULE$.replaceUnpairedSurrogates((String)input)).toSeq();
    }

    private String contentStringFromBufferedSource(BufferedSource bufferedSource) {
        BufferedReader reader = bufferedSource.bufferedReader();
        StringBuilder stringBuilder = new StringBuilder();
        int bufferSize = 1024;
        boolean productive = true;
        this.skipBOMIfPresent(reader);
        while (productive) {
            char[] buffer = new char[bufferSize];
            int read = reader.read(buffer);
            productive = read > 0;
            if (!productive) continue;
            stringBuilder.appendAll(buffer, 0, read);
        }
        return this.replaceUnpairedSurrogates(stringBuilder.toString());
    }

    public Seq<String> readLinesInFile(Path path) {
        return (Seq)Using$.MODULE$.resource((Object)Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.decoder2codec(this.createDecoder())), (Function1 & Serializable)bufferedSource -> MODULE$.contentFromBufferedSource((BufferedSource)bufferedSource), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public String readEntireFile(Path path) {
        return (String)Using$.MODULE$.resource((Object)Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.decoder2codec(this.createDecoder())), (Function1 & Serializable)bufferedSource -> MODULE$.contentStringFromBufferedSource((BufferedSource)bufferedSource), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }
}

