/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.jimple2cpg.passes;

import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Identifier;
import io.shiftleft.codepropertygraph.generated.nodes.Literal;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.traversal.CallTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.ExpressionTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.IdentifierTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.MethodTraversalExtGen$;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import io.shiftleft.semanticcpg.language.nodemethods.CallMethods$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.language.types.expressions.generalizations.AstNodeTraversal$;
import java.io.Serializable;
import overflowdb.BatchedUpdate;
import overflowdb.Element;
import overflowdb.Node;
import overflowdb.traversal.NodeOps$;
import overflowdb.traversal.NodeTraversal$;
import overflowdb.traversal.TraversalLogicExt$;
import overflowdb.traversal.TraversalSugarExt$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public class ReflectionTypeInferencePass
extends ConcurrentWriterCpgPass<Call> {
    private final Cpg cpg;
    private final Map<String, Option<String>> invokeTypeCache;
    private final scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, List<Method>>> methodIndex;

    public ReflectionTypeInferencePass(Cpg cpg) {
        this.cpg = cpg;
        super(cpg, ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2(), ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.invokeTypeCache = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        Iterator iterator = package$.MODULE$.toTraversalSugarExt((IterableOnce)package$.MODULE$.toNodeTypeStarters(cpg).method());
        this.methodIndex = TraversalSugarExt$.MODULE$.groupBy$extension(iterator, (Function1 & Serializable)_$1 -> _$1.astParentFullName()).view().mapValues((Function1 & Serializable)_$2 -> _$2.groupBy((Function1 & Serializable)_$3 -> _$3.name()).view().mapValues((Function1 & Serializable)_$4 -> _$4.toList()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Call[] generateParts() {
        Iterator iterator = package$.MODULE$.toCallTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).call());
        Iterator iterator2 = package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.name$extension(iterator, "invoke"));
        Object object = Predef$.MODULE$.refArrayOps((Object[])TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$5 -> {
            Iterator iterator = package$.MODULE$.toCallTraversalExtGen((IterableOnce)_$5);
            return CallTraversalExtGen$.MODULE$.methodFullName$extension(iterator, ".*java.lang.reflect.Method.*");
        }).toArray(ClassTag$.MODULE$.apply(Call.class)));
        Iterator iterator3 = package$.MODULE$.toCallTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).call());
        Iterator iterator4 = package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.name$extension(iterator3, "getMethod"));
        Call[] parts = (Call[])ArrayOps$.MODULE$.$plus$plus$extension(object, TraversalLogicExt$.MODULE$.where$extension(iterator4, (Function1 & Serializable)_$6 -> {
            Iterator iterator = package$.MODULE$.toCallTraversalExtGen((IterableOnce)_$6);
            return CallTraversalExtGen$.MODULE$.methodFullName$extension(iterator, ".*java.lang.Class.*getMethod.*");
        }).toArray(ClassTag$.MODULE$.apply(Call.class)), ClassTag$.MODULE$.apply(Call.class));
        return parts;
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder diffGraph, Call call) {
        String string = call.name();
        if ("getMethod".equals(string) && call.methodFullName().contains("java.lang.Class") && call.methodFullName().contains("getMethod")) {
            this.handleInvokeCall(diffGraph, call);
            return;
        }
        if ("invoke".equals(string) && call.methodFullName().contains("java.lang.reflect.Method")) {
            this.handleInvokeCall(diffGraph, call);
            return;
        }
    }

    private void handleInvokeCall(BatchedUpdate.DiffGraphBuilder diffGraph, Call invokeCall) {
        String cacheKey = this.createCacheKey(invokeCall);
        Option cachedResult = this.invokeTypeCache.get((Object)cacheKey);
        Option resolvedTypeOpt = (Option)cachedResult.getOrElse(() -> this.$anonfun$3(invokeCall, cacheKey));
        Option option = resolvedTypeOpt;
        if (option instanceof Some) {
            String refinedType = (String)((Some)option).value();
            diffGraph.setNodeProperty((Node)invokeCall, "TYPE_FULL_NAME", (Object)refinedType);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private String createCacheKey(Call invokeCall) {
        String argTypes = CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(invokeCall)).map((Function1 & Serializable)arg -> Option$.MODULE$.apply(((Element)arg).property("TYPE_FULL_NAME")).getOrElse(ReflectionTypeInferencePass::$anonfun$4$$anonfun$1)).mkString(":");
        return invokeCall.id() + ":" + argTypes;
    }

    private Option<String> inferInvokeReturnType(Call invokeCall) {
        Option methodReceiverOpt;
        Option option;
        Iterator iterator = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(invokeCall)));
        if (AstNodeTraversal$.MODULE$.isLiteral$extension(iterator).nonEmpty()) {
            Iterator iterator2 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(invokeCall)));
            Iterator iterator3 = package$.MODULE$.toTraversalSugarExt((IterableOnce)AstNodeTraversal$.MODULE$.isLiteral$extension(iterator2));
            option = TraversalSugarExt$.MODULE$.headOption$extension(iterator3);
        } else {
            Iterator iterator4 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(invokeCall)));
            Iterator iterator5 = package$.MODULE$.toIdentifierTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isIdentifier$extension(iterator4));
            Iterator iterator6 = package$.MODULE$.toTraversalSugarExt((IterableOnce)IdentifierTraversalExtGen$.MODULE$.typeFullName$extension(iterator5, "java.lang.reflect.Method"));
            option = TraversalSugarExt$.MODULE$.headOption$extension(iterator6);
        }
        Option option2 = methodReceiverOpt = option;
        if (option2 instanceof Some) {
            Expression expression = (Expression)((Some)option2).value();
            if (expression instanceof Literal) {
                Literal methodName = (Literal)expression;
                Iterator iterator7 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).method());
                if (MethodTraversalExtGen$.MODULE$.name$extension(iterator7, methodName.code().replaceAll("\"", "")).size() == 1) {
                    Iterator iterator8 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).method());
                    Iterator iterator9 = package$.MODULE$.toTraversalSugarExt((IterableOnce)MethodTraversalExtGen$.MODULE$.name$extension(iterator8, methodName.code().replaceAll("\"", "")));
                    return Some$.MODULE$.apply((Object)((Method)TraversalSugarExt$.MODULE$.head$extension(iterator9)).methodReturn().typeFullName());
                }
            }
            Expression methodReceiver = expression;
            List invokeArgs = CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(invokeCall)).filter((Function1 & Serializable)_$7 -> _$7.argumentIndex() > 0).toList();
            Option<String> result = this.findMethodViaGetArguments(invokeCall, methodReceiver, (List<Object>)invokeArgs);
            return result;
        }
        if (None$.MODULE$.equals(option2)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option2);
    }

    private Option<String> findMethodViaGetArguments(Call invokeCall, Object methodReceiver, List<Object> invokeArgs) {
        Object object = methodReceiver;
        if (object instanceof Literal) {
            Literal receiverId = (Literal)object;
            Iterator iterator = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).method());
            if (MethodTraversalExtGen$.MODULE$.name$extension(iterator, receiverId.code().replaceAll("\"", "")).size() == 1) {
                Iterator iterator2 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).method());
                Iterator iterator3 = package$.MODULE$.toTraversalSugarExt((IterableOnce)MethodTraversalExtGen$.MODULE$.name$extension(iterator2, receiverId.code().replaceAll("\"", "")));
                return Some$.MODULE$.apply((Object)((Method)TraversalSugarExt$.MODULE$.head$extension(iterator3)).fullName());
            }
        }
        if (object instanceof Identifier) {
            Identifier receiverId = (Identifier)object;
            Identifier identifier = (Identifier)package$.MODULE$.toNodeOps((Node)receiverId);
            Iterator iterator = package$.MODULE$.toNodeTraversal((IterableOnce)NodeOps$.MODULE$.start$extension((Node)identifier));
            Iterator iterator4 = package$.MODULE$.toTraversalSugarExt((IterableOnce)NodeTraversal$.MODULE$.in$extension(iterator, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"REF"})));
            List definingEdges = TraversalSugarExt$.MODULE$.l$extension(iterator4);
            Option definingAssignmentOpt = definingEdges.collectFirst((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Node x) {
                    Node node = x;
                    if (node instanceof Call) {
                        Call call = (Call)node;
                        String string = call.name();
                        String string2 = "<operator>.assignment";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Node x, Function1 function1) {
                    Node node = x;
                    if (node instanceof Call) {
                        Call call = (Call)node;
                        String string = call.name();
                        String string2 = "<operator>.assignment";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            return call;
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            Option option = definingAssignmentOpt;
            if (option instanceof Some) {
                Call assignmentCall = (Call)((Some)option).value();
                Iterator iterator5 = package$.MODULE$.toExpressionTraversalExtGen((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(assignmentCall)));
                Iterator iterator6 = package$.MODULE$.toTraversalSugarExt((IterableOnce)ExpressionTraversalExtGen$.MODULE$.order$extension(iterator5, 2));
                Option rhsNodeOpt = TraversalSugarExt$.MODULE$.headOption$extension(iterator6);
                Option rhsCallOpt = rhsNodeOpt.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Expression x) {
                        Expression expression = x;
                        if (expression instanceof Call) {
                            Call c = (Call)expression;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Expression x, Function1 function1) {
                        Expression expression = x;
                        if (expression instanceof Call) {
                            Call c = (Call)expression;
                            return c;
                        }
                        return function1.apply((Object)x);
                    }
                });
                Option option2 = rhsCallOpt;
                if (option2 instanceof Some) {
                    Call getMethodCall = (Call)((Some)option2).value();
                    String string = getMethodCall.name();
                    String string2 = "getMethod";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        List getMethodArgs = CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(getMethodCall)).filter((Function1 & Serializable)_$8 -> _$8.argumentIndex() > 0).toList();
                        if (getMethodArgs.nonEmpty()) {
                            Literal nameArg;
                            Expression expression;
                            Option methodNameArgOpt = getMethodArgs.headOption();
                            Option option3 = methodNameArgOpt;
                            if (option3 instanceof Some && (expression = (Expression)((Some)option3).value()) instanceof Literal && (nameArg = (Literal)expression).code().startsWith("\"") && nameArg.code().endsWith("\"")) {
                                String methodName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(nameArg.code()), "\"")), "\"");
                                Iterator iterator7 = package$.MODULE$.toExpressionTraversalExtGen((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(getMethodCall)));
                                Iterator iterator8 = package$.MODULE$.toTraversalSugarExt((IterableOnce)ExpressionTraversalExtGen$.MODULE$.order$extension(iterator7, 0));
                                Option classReceiverOpt = TraversalSugarExt$.MODULE$.headOption$extension(iterator8);
                                Option option4 = classReceiverOpt;
                                if (option4 instanceof Some) {
                                    Expression expression2 = (Expression)((Some)option4).value();
                                    if (expression2 instanceof Identifier) {
                                        Identifier clazzId = (Identifier)expression2;
                                        String clazzType = clazzId.typeFullName();
                                        String className = this.extractClassNameFromType(clazzType);
                                        Option<String> signature = this.findMethodSignature(className, methodName);
                                        return signature;
                                    }
                                    if (expression2 instanceof Call) {
                                        Call clazzCall = (Call)expression2;
                                        String string3 = clazzCall.name();
                                        String string4 = "forName";
                                        if (!(string3 != null ? !string3.equals(string4) : string4 != null) && clazzCall.methodFullName().contains("java.lang.Class")) {
                                            Literal classNameLiteral;
                                            Expression expression3;
                                            List forNameArgs = CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(clazzCall)).filter((Function1 & Serializable)_$9 -> _$9.argumentIndex() > 0).toList();
                                            Option option5 = forNameArgs.headOption();
                                            if (option5 instanceof Some && (expression3 = (Expression)((Some)option5).value()) instanceof Literal && (classNameLiteral = (Literal)expression3).code().startsWith("\"")) {
                                                String className = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(classNameLiteral.code()), "\"")), "\"");
                                                Option<String> signature = this.findMethodSignature(className, methodName);
                                                return signature;
                                            }
                                            return None$.MODULE$;
                                        }
                                        return None$.MODULE$;
                                    }
                                }
                                return None$.MODULE$;
                            }
                            return None$.MODULE$;
                        }
                        return None$.MODULE$;
                    }
                }
                return None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        }
        return None$.MODULE$;
    }

    private String extractClassNameFromType(String classType) {
        String innerPart;
        String result = classType.startsWith("java.lang.Class<") ? ((innerPart = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(classType), "java.lang.Class<")), ">")).endsWith("[]") ? StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(innerPart), "[]") : innerPart) : classType;
        return result;
    }

    private Option<String> findMethodSignature(String className, String methodName) {
        Option classEntryOpt = this.methodIndex.get((Object)className);
        Option methodsOpt = classEntryOpt.flatMap((Function1 & Serializable)_$10 -> _$10.get((Object)methodName));
        Option option = methodsOpt;
        if (option instanceof Some) {
            List methods = (List)((Some)option).value();
            if (methods.length() == 1) {
                String returnType = ((Method)methods.head()).methodReturn().typeFullName();
                return Some$.MODULE$.apply((Object)returnType);
            }
            if (methods.length() > 1) {
                String returnType = ((Method)methods.head()).methodReturn().typeFullName();
                return Some$.MODULE$.apply((Object)returnType);
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private final Option $anonfun$3(Call invokeCall$1, String cacheKey$1) {
        Option<String> result = this.inferInvokeReturnType(invokeCall$1);
        this.invokeTypeCache.put((Object)cacheKey$1, result);
        return result;
    }

    private static final Object $anonfun$4$$anonfun$1() {
        return "UNKNOWN";
    }
}

