/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.jimple2cpg.util;

import better.files.File;
import io.appthreat.jimple2cpg.util.ProgramHandlingUtil$;
import io.appthreat.jimple2cpg.util.ProgramHandlingUtil$ClassFile$;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left$;

public final class ProgramHandlingUtil {
    public static Tuple2<List<ClassFile>, Option<String>> extractClassesInPackageLayout(File file, File file2, Function1<Entry, Object> function1, Function1<Entry, Object> function12, boolean bl, boolean bl2) {
        return ProgramHandlingUtil$.MODULE$.extractClassesInPackageLayout(file, file2, function1, function12, bl, bl2);
    }

    public static class ClassFile {
        private final File file;
        private final Option<String> packagePath;
        private final Option<String> sourceArchivePath;
        private final Option<String> fullyQualifiedClassName;

        public ClassFile(File file, Option<String> packagePath, Option<String> sourceArchivePath) {
            this.file = file;
            this.packagePath = packagePath;
            this.sourceArchivePath = sourceArchivePath;
            Option components = packagePath.map((Function1 & Serializable)_$9 -> _$9.split("/"));
            this.fullyQualifiedClassName = components.map((Function1 & Serializable)_$10 -> Predef$.MODULE$.wrapRefArray((Object[])_$10).mkString("."));
        }

        public File file() {
            return this.file;
        }

        public Option<String> packagePath() {
            return this.packagePath;
        }

        public Option<String> sourceArchivePath() {
            return this.sourceArchivePath;
        }

        public ClassFile(File file, Option<String> sourceArchivePath) {
            this(file, ProgramHandlingUtil$ClassFile$.MODULE$.io$appthreat$jimple2cpg$util$ProgramHandlingUtil$ClassFile$$$getPackagePathFromByteCode(file), sourceArchivePath);
        }

        public Option<String> fullyQualifiedClassName() {
            return this.fullyQualifiedClassName;
        }

        public Option<ClassFile> copyToPackageLayoutIn(File destDir) {
            return this.packagePath().map((Function1 & Serializable)path -> {
                File destClass = destDir.$div(path + ".class");
                File file = destClass.parent();
                file.createDirectories(file.createDirectories$default$1(), file.createDirectories$default$2());
                return new ClassFile(this.file().copyTo(destClass, this.file().copyTo$default$2(), File.CopyOptions$.MODULE$.apply(true)), this.packagePath(), this.sourceArchivePath());
            }).orElse(ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$ClassFile$$_$copyToPackageLayoutIn$$anonfun$2);
        }
    }

    public static class Entry {
        private final Either<File, ZipEntry> entry;

        public Entry(Either<File, ZipEntry> entry) {
            this.entry = entry;
        }

        public Entry(File file) {
            this((Either<File, ZipEntry>)Left$.MODULE$.apply((Object)file));
        }

        public Entry(ZipEntry entry) {
            this((Either<File, ZipEntry>)package$.MODULE$.Right().apply((Object)entry));
        }

        private File file() {
            return (File)this.entry.fold(ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$Entry$$_$file$$anonfun$1, ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$Entry$$_$file$$anonfun$2);
        }

        public String name() {
            return this.file().name();
        }

        public Option<String> extension() {
            return this.file().extension();
        }

        public boolean isDirectory() {
            return BoxesRunTime.unboxToBoolean((Object)this.entry.fold(ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$Entry$$_$isDirectory$$anonfun$1, ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$Entry$$_$isDirectory$$anonfun$2));
        }

        public boolean maybeRegularFile() {
            return BoxesRunTime.unboxToBoolean((Object)this.entry.fold(ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$Entry$$_$maybeRegularFile$$anonfun$1, ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$Entry$$_$maybeRegularFile$$anonfun$2));
        }

        public boolean isZipSlip() {
            return BoxesRunTime.unboxToBoolean((Object)this.entry.fold(ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$Entry$$_$isZipSlip$$anonfun$1, ProgramHandlingUtil$::io$appthreat$jimple2cpg$util$ProgramHandlingUtil$Entry$$_$isZipSlip$$anonfun$2));
        }
    }
}

