/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayDeque;
import java.util.Iterator;
import overflowdb.DetachedNodeData;
import overflowdb.DetachedNodeGeneric;
import overflowdb.Edge;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.NodeOrDetachedNode;
import overflowdb.util.IteratorUtils;

public class BatchedUpdate {
    public static final Object[] emptyArray = new Object[0];

    public static AppliedDiff applyDiff(Graph graph, DiffOrBuilder diffOrBuilder) {
        return new DiffGraphApplier(graph, diffOrBuilder, null, null).run();
    }

    public static AppliedDiff applyDiff(Graph graph, DiffOrBuilder diffOrBuilder, KeyPool keyPool, ModificationListener modificationListener) {
        return new DiffGraphApplier(graph, diffOrBuilder, keyPool, modificationListener).run();
    }

    private static class DiffGraphApplier {
        private final DiffOrBuilder diff;
        private final KeyPool keyPool;
        private final ModificationListener listener;
        private final ArrayDeque<DetachedNodeData> deferredInitializers = new ArrayDeque();
        private final Graph graph;
        private int nChanges = 0;

        DiffGraphApplier(Graph graph, DiffOrBuilder diffOrBuilder, KeyPool keyPool, ModificationListener modificationListener) {
            this.diff = diffOrBuilder;
            this.keyPool = keyPool;
            this.listener = modificationListener;
            this.graph = graph;
        }

        AppliedDiff run() {
            try {
                Iterator<Change> iterator = this.diff.iterator();
                while (iterator.hasNext()) {
                    Change change = iterator.next();
                    this.applyChange(change);
                }
            }
            finally {
                if (this.listener != null) {
                    this.listener.finish();
                }
            }
            return new AppliedDiff(this.graph, this.diff, this.listener, this.nChanges);
        }

        private Node mapDetached(DetachedNodeData detachedNodeData) {
            Object object = detachedNodeData.getRefOrId();
            if (object == null || object instanceof Long) {
                object = object == null ? (this.keyPool == null ? this.graph.addNode(detachedNodeData.label(), new Object[0]) : this.graph.addNode(this.keyPool.next(), detachedNodeData.label(), new Object[0])) : this.graph.addNode((Long)object, detachedNodeData.label(), new Object[0]);
                detachedNodeData.setRefOrId(object);
                this.deferredInitializers.addLast(detachedNodeData);
            }
            return (Node)object;
        }

        private void drainDeferred() {
            while (!this.deferredInitializers.isEmpty()) {
                DetachedNodeData detachedNodeData = this.deferredInitializers.removeFirst();
                Node node = (Node)detachedNodeData.getRefOrId();
                Node.initializeFromDetached(node, detachedNodeData, this::mapDetached);
                ++this.nChanges;
                if (this.listener == null) continue;
                this.listener.onAfterInitNewNode(node);
            }
        }

        private void applyChange(Change change) {
            if (change instanceof DetachedNodeData) {
                this.mapDetached((DetachedNodeData)change);
                this.drainDeferred();
            } else if (change instanceof CreateEdge) {
                Object[] objectArray;
                CreateEdge createEdge = (CreateEdge)change;
                ++this.nChanges;
                Node node = createEdge.src instanceof DetachedNodeData ? this.mapDetached((DetachedNodeData)createEdge.src) : (Node)createEdge.src;
                Node node2 = createEdge.dst instanceof DetachedNodeData ? this.mapDetached((DetachedNodeData)createEdge.dst) : (Node)createEdge.dst;
                this.drainDeferred();
                Object[] objectArray2 = objectArray = createEdge.propertiesAndKeys == null ? emptyArray : createEdge.propertiesAndKeys;
                if (this.listener != null) {
                    Edge edge = node.addEdgeInternal(createEdge.label, node2, objectArray);
                    this.listener.onAfterAddNewEdge(edge);
                } else {
                    node.addEdgeSilentInternal(createEdge.label, node2, objectArray);
                }
            } else if (change instanceof RemoveEdge) {
                RemoveEdge removeEdge = (RemoveEdge)change;
                ++this.nChanges;
                if (this.listener != null) {
                    this.listener.onBeforeRemoveEdge(removeEdge.edge);
                }
                removeEdge.edge.removeInternal();
            } else if (change instanceof RemoveNode) {
                RemoveNode removeNode = (RemoveNode)change;
                ++this.nChanges;
                if (this.listener != null) {
                    this.listener.onBeforeRemoveNode(removeNode.node);
                }
                removeNode.node.removeInternal();
            } else if (change instanceof SetNodeProperty) {
                SetNodeProperty setNodeProperty = (SetNodeProperty)change;
                ++this.nChanges;
                if (this.listener != null) {
                    this.listener.onBeforePropertyChange(setNodeProperty.node, setNodeProperty.label);
                }
                setNodeProperty.node.setPropertyInternal(setNodeProperty.label, setNodeProperty.value);
                if (this.listener != null) {
                    this.listener.onAfterPropertyChange(setNodeProperty.node, setNodeProperty.label, setNodeProperty.value);
                }
                this.drainDeferred();
            }
        }
    }

    public static interface DiffOrBuilder {
        public int size();

        public Iterator<Change> iterator();
    }

    public static interface KeyPool {
        public long next();
    }

    public static interface ModificationListener {
        public void onAfterInitNewNode(Node var1);

        public void onAfterAddNewEdge(Edge var1);

        public void onBeforePropertyChange(Node var1, String var2);

        public void onAfterPropertyChange(Node var1, String var2, Object var3);

        public void onBeforeRemoveNode(Node var1);

        public void onBeforeRemoveEdge(Edge var1);

        public void finish();
    }

    public static class AppliedDiff {
        public DiffOrBuilder diffGraph;
        private final ModificationListener listener;
        private final int transitiveModifications;
        private final Graph graph;

        AppliedDiff(Graph graph, DiffOrBuilder diffOrBuilder, ModificationListener modificationListener, int n) {
            this.graph = graph;
            this.diffGraph = diffOrBuilder;
            this.listener = modificationListener;
            this.transitiveModifications = n;
        }

        public DiffGraph getDiffGraph() {
            if (this.diffGraph instanceof DiffGraphBuilder) {
                this.diffGraph = ((DiffGraphBuilder)this.diffGraph).build();
            }
            return (DiffGraph)this.diffGraph;
        }

        public ModificationListener getListener() {
            return this.listener;
        }

        public int explicitModifications() {
            return this.diffGraph.size();
        }

        public int transitiveModifications() {
            return this.transitiveModifications;
        }
    }

    public static class SetNodeProperty
    implements Change {
        public String label;
        public Node node;
        public Object value;

        public SetNodeProperty(String string, Node node, Object object) {
            this.label = string;
            this.node = node;
            this.value = object;
        }
    }

    public static class CreateEdge
    implements Change {
        public String label;
        public NodeOrDetachedNode src;
        public NodeOrDetachedNode dst;
        public Object[] propertiesAndKeys;

        public CreateEdge(String string, NodeOrDetachedNode nodeOrDetachedNode, NodeOrDetachedNode nodeOrDetachedNode2, Object[] objectArray) {
            this.label = string;
            this.src = nodeOrDetachedNode;
            this.dst = nodeOrDetachedNode2;
            this.propertiesAndKeys = objectArray;
        }
    }

    public static class RemoveNode
    implements Change {
        public Node node;

        public RemoveNode(Node node) {
            this.node = node;
        }
    }

    public static class CreateNode
    implements Change {
        public String label;
        public Object[] ProprtiesAndKeys;
        public long id;

        public CreateNode(String string) {
            this.label = string;
        }
    }

    private static class RemoveEdge
    implements Change {
        public Edge edge;

        public RemoveEdge(Edge edge) {
            this.edge = edge;
        }
    }

    public static class DiffGraphBuilder
    implements DiffOrBuilder {
        private ArrayDeque<Change> _buffer = new ArrayDeque();

        public DiffGraph build() {
            DiffGraph diffGraph = new DiffGraph(this._buffer.toArray(new Change[0]));
            this._buffer = null;
            return diffGraph;
        }

        @Override
        public int size() {
            return this._buffer.size();
        }

        @Override
        public Iterator<Change> iterator() {
            return this._buffer.iterator();
        }

        public DiffGraphBuilder absorb(DiffGraphBuilder diffGraphBuilder) {
            if (this._buffer.size() > diffGraphBuilder._buffer.size()) {
                this._buffer.addAll(diffGraphBuilder._buffer);
                diffGraphBuilder._buffer = null;
            } else {
                ArrayDeque<Change> arrayDeque = this._buffer;
                this._buffer = diffGraphBuilder._buffer;
                diffGraphBuilder._buffer = null;
                Iterator<Change> iterator = arrayDeque.descendingIterator();
                while (iterator.hasNext()) {
                    Change change = iterator.next();
                    this._buffer.addFirst(change);
                }
            }
            return this;
        }

        public DiffGraphBuilder addNode(DetachedNodeData detachedNodeData) {
            this._buffer.addLast(detachedNodeData);
            return this;
        }

        public DiffGraphBuilder addNode(String string, Object ... objectArray) {
            this._buffer.addLast(new DetachedNodeGeneric(string, objectArray));
            return this;
        }

        public DiffGraphBuilder addEdge(NodeOrDetachedNode nodeOrDetachedNode, NodeOrDetachedNode nodeOrDetachedNode2, String string) {
            this._buffer.addLast(new CreateEdge(string, nodeOrDetachedNode, nodeOrDetachedNode2, null));
            return this;
        }

        public DiffGraphBuilder addEdge(NodeOrDetachedNode nodeOrDetachedNode, NodeOrDetachedNode nodeOrDetachedNode2, String string, Object ... objectArray) {
            this._buffer.addLast(new CreateEdge(string, nodeOrDetachedNode, nodeOrDetachedNode2, (Object[])(objectArray.length > 0 ? objectArray : null)));
            return this;
        }

        public DiffGraphBuilder setNodeProperty(Node node, String string, Object object) {
            this._buffer.addLast(new SetNodeProperty(string, node, object));
            return this;
        }

        public DiffGraphBuilder removeNode(Node node) {
            this._buffer.addLast(new RemoveNode(node));
            return this;
        }

        public DiffGraphBuilder removeEdge(Edge edge) {
            this._buffer.addLast(new RemoveEdge(edge));
            return this;
        }
    }

    public static class DiffGraph
    implements DiffOrBuilder {
        public final Change[] changes;

        DiffGraph(Change[] changeArray) {
            this.changes = changeArray;
        }

        @Override
        public int size() {
            return this.changes.length;
        }

        @Override
        public Iterator<Change> iterator() {
            return new IteratorUtils.ArrayIterator<Change>(this.changes);
        }
    }

    public static interface Change {
    }
}

