/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class Config {
    private boolean overflowEnabled = true;
    private int heapPercentageThreshold = 80;
    private Optional<Path> storageLocation = Optional.empty();
    private boolean serializationStatsEnabled = false;
    private Optional<ExecutorService> executorService = Optional.empty();
    private FileSystemType fileSystemType = FileSystemType.DEFAULT;
    private static Optional<Integer> compressionRatio = Optional.empty();
    private static final int defaultCompressionRatio = 20;
    private static final int defaultCacheSize = 131072;
    private static final int defaultPageSplitSize = 65536;
    private Optional<Integer> cacheSize = Optional.empty();
    private Optional<Integer> pageSplitSize = Optional.empty();

    public static Config withDefaults() {
        return new Config().withCacheSize(131072).withPageSplitSize(65536);
    }

    public static Config withoutOverflow() {
        return Config.withDefaults().disableOverflow();
    }

    public Config disableOverflow() {
        this.overflowEnabled = false;
        return this;
    }

    public Config withHeapPercentageThreshold(int n) {
        this.heapPercentageThreshold = n;
        return this;
    }

    public Config withStorageLocation(Path path) {
        this.storageLocation = Optional.ofNullable(path);
        return this;
    }

    public Config withStorageLocation(String string) {
        return this.withStorageLocation(Paths.get(string, new String[0]));
    }

    public Config withSerializationStatsEnabled() {
        this.serializationStatsEnabled = true;
        return this;
    }

    public Config withFileSystemType(FileSystemType fileSystemType) {
        this.fileSystemType = fileSystemType;
        return this;
    }

    public Config withCompressionRatio(int n) {
        compressionRatio = Optional.of(n);
        return this;
    }

    public Config withCacheSize(int n) {
        this.cacheSize = Optional.of(n);
        return this;
    }

    public Config withPageSplitSize(int n) {
        this.pageSplitSize = Optional.of(n);
        return this;
    }

    public boolean isOverflowEnabled() {
        return this.overflowEnabled;
    }

    public int getHeapPercentageThreshold() {
        return this.heapPercentageThreshold;
    }

    public Optional<Path> getStorageLocation() {
        return this.storageLocation;
    }

    public boolean isSerializationStatsEnabled() {
        return this.serializationStatsEnabled;
    }

    public Config withExecutorService(ExecutorService executorService) {
        this.executorService = Optional.ofNullable(executorService);
        return this;
    }

    public Optional<ExecutorService> getExecutorService() {
        return this.executorService;
    }

    public FileSystemType getFileSystemType() {
        return this.fileSystemType;
    }

    public Optional<Integer> getCompressionRatio() {
        return compressionRatio;
    }

    public Optional<Integer> getCacheSize() {
        return this.cacheSize;
    }

    public Optional<Integer> getPageSplitSize() {
        return this.pageSplitSize;
    }

    public static enum FileSystemType {
        DEFAULT(""),
        FILE("file:"),
        NIO_MAPPED("nioMapped:"),
        ASYNC("async:"),
        SPLIT("split:"),
        MEM("mem:"),
        MEM_LZF("memLZF:"),
        NIO_MEMFS("nioMemFS:"),
        NIO_MEMLZF("nioMemLZF:");

        private final String prefix;

        private FileSystemType(String string2) {
            this.prefix = string2;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String applyPrefix(String string) {
            if (this == DEFAULT) {
                return string;
            }
            Object object = this.prefix;
            if (this == NIO_MEMLZF && compressionRatio.isPresent()) {
                object = "nioMemLZF:" + String.valueOf(compressionRatio.get()) + ":";
            }
            return (String)object + string;
        }
    }
}

