/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import overflowdb.Direction;
import overflowdb.Element;
import overflowdb.Graph;
import overflowdb.NodeDb;
import overflowdb.NodeRef;
import overflowdb.Property;
import overflowdb.PropertyKey;
import overflowdb.util.IteratorUtils;

public abstract class Edge
extends Element {
    private final Graph graph;
    private final String label;
    private final NodeRef<?> outNode;
    private final NodeRef<?> inNode;
    private int outBlockOffset = -1;
    private int inBlockOffset = -1;
    private final Set<String> specificKeys;
    private boolean removed = false;
    private static final int UNINITIALIZED_BLOCK_OFFSET = -1;

    public Edge(Graph graph, String string, NodeRef<?> nodeRef, NodeRef<?> nodeRef2, Set<String> set) {
        this.graph = graph;
        this.label = string;
        this.outNode = nodeRef;
        this.inNode = nodeRef2;
        this.specificKeys = set;
        graph.applyBackpressureMaybe();
    }

    public NodeRef<?> outNode() {
        return this.outNode;
    }

    public NodeRef<?> inNode() {
        return this.inNode;
    }

    public Iterator<NodeRef<?>> bothNodes() {
        return IteratorUtils.from(this.outNode, this.inNode);
    }

    public int getOutBlockOffset() {
        return this.outBlockOffset;
    }

    public void setOutBlockOffset(int n) {
        this.outBlockOffset = n;
    }

    public int getInBlockOffset() {
        return this.inBlockOffset;
    }

    public void setInBlockOffset(int n) {
        this.inBlockOffset = n;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    protected void setPropertyImpl(String string, Object object) {
        if (this.inBlockOffset != -1) {
            if (this.outBlockOffset == -1) {
                this.initializeOutFromInOffset();
            }
        } else if (this.outBlockOffset != -1) {
            if (this.inBlockOffset == -1) {
                this.initializeInFromOutOffset();
            }
        } else {
            throw new RuntimeException("Cannot set property. In and out block offset uninitialized.");
        }
        ((NodeDb)this.inNode.get()).setEdgeProperty(Direction.IN, this.label, string, (Object)object, this.inBlockOffset);
        ((NodeDb)this.outNode.get()).setEdgeProperty(Direction.OUT, this.label, string, (Object)object, this.outBlockOffset);
    }

    @Override
    public Set<String> propertyKeys() {
        return this.specificKeys;
    }

    @Override
    protected void removePropertyImpl(String string) {
        ((NodeDb)this.inNode.get()).removeEdgeProperty(Direction.IN, this.label, string, this.inBlockOffset);
        ((NodeDb)this.outNode.get()).removeEdgeProperty(Direction.OUT, this.label, string, this.outBlockOffset);
    }

    @Override
    protected void removeImpl() {
        this.fixupBlockOffsets();
        ((NodeDb)this.outNode.get()).removeEdge(Direction.OUT, this.label(), this.outBlockOffset);
        ((NodeDb)this.inNode.get()).removeEdge(Direction.IN, this.label(), this.inBlockOffset);
    }

    @Override
    public Map<String, Object> propertiesMap() {
        Map<String, Object> map;
        if (this.inBlockOffset != -1) {
            map = ((NodeDb)this.inNode.get()).edgePropertyMap(Direction.IN, this, this.getInBlockOffset());
        } else if (this.outBlockOffset != -1) {
            map = ((NodeDb)this.outNode.get()).edgePropertyMap(Direction.OUT, this, this.getOutBlockOffset());
        } else {
            throw new RuntimeException("Cannot get properties. In and out block offset uninitialized.");
        }
        for (String string : this.propertyKeys()) {
            Object object;
            if (map.containsKey(string) || (object = this.propertyDefaultValue(string)) == null) continue;
            map.put(string, this.propertyDefaultValue(string));
        }
        return map;
    }

    @Override
    public Object property(String string) {
        Object p;
        if (this.inBlockOffset != -1) {
            p = ((NodeDb)this.inNode.get()).edgeProperty(Direction.IN, this, this.inBlockOffset, string);
        } else if (this.outBlockOffset != -1) {
            p = ((NodeDb)this.outNode.get()).edgeProperty(Direction.OUT, this, this.outBlockOffset, string);
        } else {
            throw new RuntimeException("Cannot get property. In and out block offset unitialized.");
        }
        return p != null ? p : this.propertyDefaultValue(string);
    }

    @Override
    public <A> A property(PropertyKey<A> propertyKey) {
        return (A)this.property(propertyKey.name);
    }

    @Override
    public <A> Optional<A> propertyOption(PropertyKey<A> propertyKey) {
        return Optional.ofNullable(this.property(propertyKey));
    }

    @Override
    public Optional<Object> propertyOption(String string) {
        return Optional.ofNullable(this.property(string));
    }

    @Override
    protected <A> void setPropertyImpl(PropertyKey<A> propertyKey, A a) {
        this.setProperty(propertyKey.name, a);
    }

    @Override
    protected void setPropertyImpl(Property<?> property) {
        this.setProperty(property.key.name, property.value);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)object;
        this.fixupBlockOffsetsIfNecessary(edge);
        return !(this.inNode.id() != edge.inNode.id() || this.outNode.id() != edge.outNode.id() || !this.label.equals(edge.label) || this.inBlockOffset != -1 && edge.inBlockOffset != -1 && this.inBlockOffset != edge.inBlockOffset || this.outBlockOffset != -1 && edge.outBlockOffset != -1 && this.outBlockOffset != edge.outBlockOffset);
    }

    public int hashCode() {
        return Objects.hash(this.inNode.id(), this.outNode.id(), this.label);
    }

    private void fixupBlockOffsetsIfNecessary(Edge edge) {
        if (!(this.inBlockOffset != -1 && edge.inBlockOffset != -1 || this.outBlockOffset != -1 && edge.outBlockOffset != -1)) {
            this.fixupBlockOffsets();
        }
    }

    private void fixupBlockOffsets() {
        if (this.inBlockOffset == -1) {
            this.initializeInFromOutOffset();
        }
        if (this.outBlockOffset == -1) {
            this.initializeOutFromInOffset();
        }
    }

    private void initializeInFromOutOffset() {
        int n = ((NodeDb)this.outNode.get()).blockOffsetToOccurrence(Direction.OUT, this.label(), this.inNode, this.outBlockOffset);
        this.inBlockOffset = ((NodeDb)this.inNode.get()).occurrenceToBlockOffset(Direction.IN, this.label(), this.outNode, n);
    }

    private void initializeOutFromInOffset() {
        int n = ((NodeDb)this.inNode.get()).blockOffsetToOccurrence(Direction.IN, this.label(), this.outNode, this.inBlockOffset);
        this.outBlockOffset = ((NodeDb)this.outNode.get()).occurrenceToBlockOffset(Direction.OUT, this.label(), this.inNode, n);
    }
}

