/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import overflowdb.Config;
import overflowdb.DetachedNodeData;
import overflowdb.Direction;
import overflowdb.Edge;
import overflowdb.EdgeFactory;
import overflowdb.IndexManager;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.NodeFactory;
import overflowdb.NodeRef;
import overflowdb.ReferenceManager;
import overflowdb.storage.NodeDeserializer;
import overflowdb.storage.NodeSerializer;
import overflowdb.storage.NodesWriter;
import overflowdb.storage.OdbStorage;
import overflowdb.util.IteratorUtils;
import overflowdb.util.MultiIterator;
import overflowdb.util.NodesList;
import overflowdb.util.PropertyHelper;
import overflowdb.util.StringInterner;

public final class Graph
implements AutoCloseable {
    private final AtomicLong currentId = new AtomicLong(-1L);
    final NodesList nodes = new NodesList();
    public final IndexManager indexManager = new IndexManager(this);
    private final Config config;
    private volatile boolean closed = false;
    private final Map<String, NodeFactory<?>> nodeFactoryByLabel;
    final Map<String, EdgeFactory<?>> edgeFactoryByLabel;
    final OdbStorage storage;
    public final NodeSerializer nodeSerializer;
    final NodeDeserializer nodeDeserializer;
    private final StringInterner stringInterner;
    private final boolean overflowEnabled;
    private final ReferenceManager referenceManager;
    private final NodesWriter nodesWriter;

    public static Graph open(Config config, List<NodeFactory<?>> list, List<EdgeFactory<?>> list2, Function<Object, Object> function) {
        HashMap hashMap = new HashMap(list.size());
        HashMap hashMap2 = new HashMap(list2.size());
        list.forEach(nodeFactory -> hashMap.put(nodeFactory.forLabel(), (NodeFactory<?>)nodeFactory));
        list2.forEach(edgeFactory -> hashMap2.put(edgeFactory.forLabel(), (EdgeFactory<?>)edgeFactory));
        return new Graph(config, hashMap, hashMap2, function);
    }

    public static Graph open(Config config, List<NodeFactory<?>> list, List<EdgeFactory<?>> list2) {
        return Graph.open(config, list, list2, Function.identity());
    }

    private Graph(Config config, Map<String, NodeFactory<?>> map, Map<String, EdgeFactory<?>> map2, Function<Object, Object> function) {
        this.config = config;
        this.nodeFactoryByLabel = map;
        this.edgeFactoryByLabel = map2;
        this.stringInterner = new StringInterner();
        this.storage = config.getStorageLocation().isPresent() ? OdbStorage.createWithSpecificLocation(config.getStorageLocation().get().toFile(), this.stringInterner, config) : OdbStorage.createWithTempFile(this.stringInterner, config);
        this.nodeDeserializer = new NodeDeserializer(this, map, config.isSerializationStatsEnabled(), this.storage);
        this.nodeSerializer = new NodeSerializer(config.isSerializationStatsEnabled(), this.storage, function);
        this.nodesWriter = new NodesWriter(this.nodeSerializer, this.storage);
        config.getStorageLocation().ifPresent(path -> this.initElementCollections(this.storage));
        this.overflowEnabled = config.isOverflowEnabled();
        this.referenceManager = this.overflowEnabled ? (config.getExecutorService().isPresent() ? new ReferenceManager(this.storage, this.nodesWriter, config.getExecutorService().get()) : new ReferenceManager(this.storage, this.nodesWriter)) : null;
    }

    private void initElementCollections(OdbStorage odbStorage) {
        long l = System.currentTimeMillis();
        Set<Map.Entry<Long, byte[]>> set = odbStorage.allNodes();
        int n = set.size();
        int n2 = 0;
        long l2 = this.currentId.get();
        for (Map.Entry<Long, byte[]> entry : set) {
            try {
                NodeRef<?> nodeRef = this.nodeDeserializer.deserializeRef(entry.getValue());
                this.nodes.add(nodeRef);
                ++n2;
                if (nodeRef.id <= l2) continue;
                l2 = nodeRef.id;
            }
            catch (IOException iOException) {
                throw new RuntimeException("error while initializing vertex from storage: id=" + String.valueOf(entry.getKey()), iOException);
            }
        }
        this.currentId.set(l2 + 1L);
        this.indexManager.initializeStoredIndices(odbStorage);
        long l3 = System.currentTimeMillis() - l;
    }

    public Node addNode(String string, Object ... objectArray) {
        return this.addNodeInternal(this.currentId.incrementAndGet(), string, objectArray);
    }

    public Node addNode(long l, String string, Object ... objectArray) {
        long l2;
        if (this.nodes.contains(l)) {
            throw new IllegalArgumentException(String.format("Node with id already exists: %s", l));
        }
        long l3 = this.currentId.get();
        if (!this.currentId.compareAndSet(l3, l2 = Long.max(l, this.currentId.get()))) {
            return this.addNode(l, string, objectArray);
        }
        return this.addNodeInternal(l, string, objectArray);
    }

    private Node addNodeInternal(long l, String string, Object ... objectArray) {
        if (this.isClosed()) {
            throw new AssertionError((Object)"graph is closed - no more mutation allowed");
        }
        NodeRef<?> nodeRef = this.createNode(l, string, objectArray);
        this.nodes.add(nodeRef);
        return nodeRef;
    }

    public DetachedNodeData createDetached(String string) {
        if (!this.nodeFactoryByLabel.containsKey(string)) {
            throw new IllegalArgumentException("No NodeFactory for label=" + string + " available.");
        }
        NodeFactory<?> nodeFactory = this.nodeFactoryByLabel.get(string);
        return nodeFactory.createDetached();
    }

    private NodeRef<?> createNode(long l, String string, Object ... objectArray) {
        if (this.isClosed()) {
            throw new AssertionError((Object)"graph is closed - no more mutation allowed");
        }
        if (!this.nodeFactoryByLabel.containsKey(string)) {
            throw new IllegalArgumentException("No NodeFactory for label=" + string + " available.");
        }
        NodeFactory<?> nodeFactory = this.nodeFactoryByLabel.get(string);
        Object obj = nodeFactory.createNode(this, l, null);
        PropertyHelper.attachProperties(obj, objectArray);
        this.registerNodeRef(((NodeDb)obj).ref);
        return ((NodeDb)obj).ref;
    }

    public void applyBackpressureMaybe() {
        if (this.referenceManager != null) {
            this.referenceManager.applyBackpressureMaybe();
        }
    }

    public void registerNodeRef(NodeRef<?> nodeRef) {
        if (this.referenceManager != null && !this.isClosed()) {
            this.referenceManager.registerRef(nodeRef);
        }
    }

    public String toString() {
        return String.format("%s [%d nodes]", this.getClass().getSimpleName(), this.nodeCount());
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            this.closed = true;
            this.shutdownNow();
            this.stringInterner.clear();
        }
    }

    private void shutdownNow() {
        try {
            if (this.config.getStorageLocation().isPresent()) {
                this.indexManager.storeIndexes(this.storage);
                if (this.referenceManager != null) {
                    this.referenceManager.clearAllReferences();
                } else {
                    this.nodes.persistAll(this.nodesWriter);
                }
            }
        }
        finally {
            if (this.referenceManager != null) {
                this.referenceManager.close();
            }
            this.storage.close();
        }
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public int nodeCount(String string) {
        return this.nodes.cardinality(string);
    }

    public Map<String, Integer> nodeCountByLabel() {
        Set<String> set = this.nodes.nodeLabels();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(set.size());
        for (String string : set) {
            hashMap.put(string, this.nodes.nodesByLabel(string).size());
        }
        return hashMap;
    }

    public int edgeCount() {
        int n = 0;
        Iterator<Node> iterator = this.nodes();
        while (iterator.hasNext()) {
            NodeDb nodeDb = this.getNodeDb(iterator.next());
            n += nodeDb.outEdgeCount();
        }
        return n;
    }

    public Map<String, Integer> edgeCountByLabel() {
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        this.edges().forEachRemaining(edge -> tObjectIntHashMap.adjustOrPutValue((Object)edge.label(), 1, 1));
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(tObjectIntHashMap.size());
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        while (tObjectIntIterator.hasNext()) {
            tObjectIntIterator.advance();
            hashMap.put((String)tObjectIntIterator.key(), tObjectIntIterator.value());
        }
        return hashMap;
    }

    public Iterator<Edge> E() {
        return this.edges();
    }

    public Iterator<Edge> edges() {
        return IteratorUtils.flatMap(this.nodes(), Node::outE);
    }

    public Iterator<Edge> edges(String string) {
        return IteratorUtils.flatMap(this.nodes(), node -> node.outE(string));
    }

    public Iterator<Node> V() {
        return this.nodes();
    }

    public Iterator<Node> nodes() {
        return this.nodes.iterator();
    }

    public Iterator<Node> V(long ... lArray) {
        return this.nodes(lArray);
    }

    public Node node(long l) {
        return this.nodes.nodeById(l);
    }

    public Iterator<Node> nodes(long ... lArray) {
        if (lArray.length == 0) {
            return Collections.emptyIterator();
        }
        if (lArray.length == 1) {
            return IteratorUtils.from(this.node(lArray[0]));
        }
        return IteratorUtils.map(Arrays.stream(lArray).iterator(), this::node);
    }

    public Iterator<Node> nodes(String string) {
        return this.nodes.nodesByLabel(string).iterator();
    }

    public Iterator<Node> nodes(String ... stringArray) {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        for (String string : stringArray) {
            this.addNodesToMultiIterator(multiIterator, string);
        }
        return multiIterator;
    }

    public Iterator<Node> nodes(Set<String> set) {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        for (String string : set) {
            this.addNodesToMultiIterator(multiIterator, string);
        }
        return multiIterator;
    }

    public Iterator<Node> nodes(Predicate<String> predicate) {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        for (String string : this.nodes.nodeLabels()) {
            if (!predicate.test(string)) continue;
            this.addNodesToMultiIterator(multiIterator, string);
        }
        return multiIterator;
    }

    private void addNodesToMultiIterator(MultiIterator<Node> multiIterator, String string) {
        ArrayList<Node> arrayList = this.nodes.nodesByLabel(string);
        if (arrayList != null) {
            multiIterator.addIterator(arrayList.iterator());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public OdbStorage getStorage() {
        return this.storage;
    }

    public void copyTo(Graph graph) {
        if (graph.nodeCount() > 0) {
            throw new AssertionError((Object)"destination graph must be empty, but isn't");
        }
        this.nodes().forEachRemaining(node -> graph.addNode(node.id(), node.label(), PropertyHelper.toKeyValueArray(node.propertiesMap())));
        this.nodes().forEachRemaining(node -> {
            Object n = ((NodeRef)graph.node(node.id())).get();
            node.outE().forEachRemaining(edge -> {
                NodeRef nodeRef = (NodeRef)graph.node(edge.inNode().id());
                n.storeAdjacentNode(Direction.OUT, edge.label(), nodeRef, PropertyHelper.toKeyValueArray(edge.propertiesMap()));
            });
            node.inE().forEachRemaining(edge -> {
                NodeRef nodeRef = (NodeRef)graph.node(edge.outNode().id());
                n.storeAdjacentNode(Direction.IN, edge.label(), nodeRef, PropertyHelper.toKeyValueArray(edge.propertiesMap()));
            });
        });
    }

    public void remove(Node node) {
        NodeRef<?> nodeRef = this.getNodeRef(node);
        this.nodes.remove(nodeRef);
        this.indexManager.removeElement(nodeRef);
        this.storage.removeNode(node.id());
    }

    private NodeRef<?> getNodeRef(Node node) {
        if (node instanceof NodeRef) {
            return (NodeRef)node;
        }
        return ((NodeDb)node).ref;
    }

    private NodeDb getNodeDb(Node node) {
        if (node instanceof NodeDb) {
            return (NodeDb)node;
        }
        return ((NodeRef)node).get();
    }

    public void persistLibraryVersion(String string, String string2) {
        this.storage.persistLibraryVersion(string, string2);
    }

    public ArrayList<Map<String, String>> getAllLibraryVersions() {
        return this.storage.getAllLibraryVersions();
    }

    public StringInterner getStringInterner() {
        return this.stringInterner;
    }
}

