/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.LongStream;
import org.h2.mvstore.MVMap;
import overflowdb.Graph;
import overflowdb.NodeRef;
import overflowdb.storage.OdbStorage;

public final class IndexManager {
    private final Graph graph;
    private Map<String, Map<Object, Set<NodeRef>>> indexes = new ConcurrentHashMap<String, Map<Object, Set<NodeRef>>>();
    private Map<String, Boolean> dirtyFlags = new ConcurrentHashMap<String, Boolean>();

    public IndexManager(Graph graph) {
        this.graph = graph;
    }

    public void createNodePropertyIndex(String string) {
        this.checkPropertyName(string);
        if (this.indexes.containsKey(string)) {
            return;
        }
        this.dirtyFlags.put(string, true);
        this.graph.nodes.iterator().forEachRemaining(node -> {
            Object object = node.property(string);
            if (object != null) {
                this.put(string, object, (NodeRef)node);
            }
        });
    }

    public boolean isIndexed(String string) {
        return this.indexes.containsKey(string);
    }

    private void checkPropertyName(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Illegal property name: " + string);
        }
    }

    private void loadNodePropertyIndex(String string, Map<Object, long[]> map) {
        this.dirtyFlags.put(string, false);
        map.entrySet().parallelStream().forEach(entry -> LongStream.of((long[])entry.getValue()).forEach(l -> this.put(string, entry.getKey(), (NodeRef)this.graph.node(l))));
    }

    public void putIfIndexed(String string, Object object, NodeRef<?> nodeRef) {
        if (this.indexes.containsKey(string)) {
            this.dirtyFlags.put(string, true);
            this.put(string, object, nodeRef);
        }
    }

    private void put(String string, Object object, NodeRef<?> nodeRef) {
        Set<NodeRef> set;
        Map<Object, Set<NodeRef>> map = this.indexes.get(string);
        if (null == map) {
            this.indexes.putIfAbsent(string, new ConcurrentHashMap());
            map = this.indexes.get(string);
        }
        if (null == (set = map.get(object))) {
            map.putIfAbsent(object, ConcurrentHashMap.newKeySet());
            set = map.get(object);
        }
        set.add(nodeRef);
    }

    public void dropNodePropertyIndex(String string) {
        if (this.indexes.containsKey(string)) {
            this.indexes.remove(string).clear();
            this.dirtyFlags.remove(string);
        }
    }

    public Set<String> getIndexedNodeProperties() {
        return this.indexes.keySet();
    }

    public int getIndexedNodeCount(String string) {
        Map<Object, Set<NodeRef>> map = this.indexes.get(string);
        return map == null ? 0 : map.values().stream().mapToInt(Set::size).sum();
    }

    public List<NodeRef> lookup(String string, Object object) {
        Map<Object, Set<NodeRef>> map = this.indexes.get(string);
        if (null == map) {
            return Collections.emptyList();
        }
        Set<NodeRef> set = map.get(object);
        if (null == set) {
            return Collections.emptyList();
        }
        return new ArrayList<NodeRef>(set);
    }

    void remove(String string, Object object, NodeRef<?> nodeRef) {
        Set<NodeRef> set;
        this.dirtyFlags.put(string, true);
        Map<Object, Set<NodeRef>> map = this.indexes.get(string);
        if (null != map && null != (set = map.get(object))) {
            set.remove(nodeRef);
            if (set.isEmpty()) {
                map.remove(string);
            }
        }
    }

    void removeElement(NodeRef<?> nodeRef) {
        for (String object : this.indexes.keySet()) {
            this.dirtyFlags.put(object, true);
        }
        for (Map map : this.indexes.values()) {
            for (Set set : map.values()) {
                set.remove(nodeRef);
            }
        }
    }

    private Map<Object, Set<NodeRef>> getIndexMap(String string) {
        return this.indexes.get(string);
    }

    void initializeStoredIndices(OdbStorage odbStorage) {
        odbStorage.getIndexNames().stream().forEach(string -> this.loadIndex((String)string, odbStorage));
    }

    private void loadIndex(String string, OdbStorage odbStorage) {
        MVMap<Object, long[]> mVMap = odbStorage.openIndex(string);
        this.loadNodePropertyIndex(string, (Map<Object, long[]>)mVMap);
    }

    void storeIndexes(OdbStorage odbStorage) {
        this.getIndexedNodeProperties().stream().forEach(string -> this.saveIndex(odbStorage, (String)string, this.getIndexMap((String)string)));
    }

    private void saveIndex(OdbStorage odbStorage, String string, Map<Object, Set<NodeRef>> map) {
        if (this.dirtyFlags.get(string).booleanValue()) {
            odbStorage.clearIndex(string);
            MVMap<Object, long[]> mVMap = odbStorage.openIndex(string);
            map.entrySet().parallelStream().forEach(entry -> {
                Object k = entry.getKey();
                Set set = (Set)entry.getValue();
                mVMap.put(k, (Object)set.stream().mapToLong(nodeRef -> nodeRef.id).toArray());
            });
            this.dirtyFlags.put(string, false);
        }
    }
}

