/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import overflowdb.AdjacentNodes;
import overflowdb.Direction;
import overflowdb.Edge;
import overflowdb.EdgeFactory;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.NodeLayoutInformation;
import overflowdb.NodeRef;
import overflowdb.Property;
import overflowdb.PropertyKey;
import overflowdb.misc.ArrayIter;
import overflowdb.util.ArrayOffsetIterator;
import overflowdb.util.DummyEdgeIterator;
import overflowdb.util.MultiIterator;
import overflowdb.util.PropertyHelper;
import scala.collection.Iterator;

public abstract class NodeDb
extends Node {
    public final NodeRef<?> ref;
    private volatile AdjacentNodes adjacentNodes;
    private volatile boolean dirty;
    private static final String[] ALL_LABELS = new String[0];

    protected NodeDb(NodeRef nodeRef) {
        this.ref = nodeRef;
        nodeRef.setNode(this);
        if (nodeRef.graph != null) {
            nodeRef.graph.applyBackpressureMaybe();
        }
        this.adjacentNodes = new AdjacentNodes(this.layoutInformation().numberOfDifferentAdjacentTypes());
    }

    public abstract NodeLayoutInformation layoutInformation();

    public AdjacentNodes getAdjacentNodes() {
        return this.adjacentNodes;
    }

    @Override
    public Graph graph() {
        return this.ref.graph;
    }

    @Override
    public long id() {
        return this.ref.id;
    }

    @Override
    public String label() {
        return this.ref.label();
    }

    @Override
    public <A> A property(PropertyKey<A> propertyKey) {
        return (A)this.property(propertyKey.name);
    }

    @Override
    public <A> Optional<A> propertyOption(PropertyKey<A> propertyKey) {
        return Optional.ofNullable(this.property(propertyKey));
    }

    @Override
    public Optional<Object> propertyOption(String string) {
        return Optional.ofNullable(this.property(string));
    }

    @Override
    public Map<String, Object> propertiesMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.propertyKeys().size());
        for (String string : this.propertyKeys()) {
            Object object = this.property(string);
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public Map<String, Object> propertiesMapForStorage() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.propertyKeys().size());
        for (String string : this.propertyKeys()) {
            Object object = this.property(string);
            if (object == null || object.equals(this.propertyDefaultValue(string))) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    @Override
    public Set<String> propertyKeys() {
        return this.layoutInformation().propertyKeys();
    }

    @Override
    public Object propertyDefaultValue(String string) {
        return this.ref.propertyDefaultValue(string);
    }

    @Override
    protected void setPropertyImpl(String string, Object object) {
        this.updateSpecificProperty(string, object);
        this.ref.graph.indexManager.putIfIndexed(string, object, this.ref);
        this.markAsDirty();
    }

    @Override
    protected <A> void setPropertyImpl(PropertyKey<A> propertyKey, A a) {
        this.setProperty(propertyKey.name, a);
    }

    @Override
    protected void setPropertyImpl(Property<?> property) {
        this.setProperty(property.key.name, property.value);
    }

    @Override
    protected void removePropertyImpl(String string) {
        Object object = this.property(string);
        this.removeSpecificProperty(string);
        this.ref.graph.indexManager.remove(string, object, this.ref);
        this.markAsDirty();
    }

    protected abstract void updateSpecificProperty(String var1, Object var2);

    protected abstract void removeSpecificProperty(String var1);

    @Override
    protected void removeImpl() {
        ArrayList arrayList = new ArrayList();
        this.bothE().forEachRemaining(arrayList::add);
        for (Edge edge : arrayList) {
            if (edge.isRemoved()) continue;
            edge.remove();
        }
        this.ref.graph.remove(this);
        this.markAsDirty();
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public void markAsClean() {
        this.dirty = false;
    }

    public <V> java.util.Iterator<V> getEdgeProperties(Direction direction, Edge edge, int n, String ... stringArray) {
        ArrayList arrayList = new ArrayList();
        if (stringArray.length != 0) {
            for (String string : stringArray) {
                arrayList.add(this.edgeProperty(direction, edge, n, string));
            }
        } else {
            for (String string : this.layoutInformation().edgePropertyKeys(edge.label())) {
                arrayList.add(this.edgeProperty(direction, edge, n, string));
            }
        }
        return arrayList.iterator();
    }

    public Map<String, Object> edgePropertyMap(Direction direction, Edge edge, int n) {
        Set<String> set = this.layoutInformation().edgePropertyKeys(edge.label());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(set.size());
        for (String string : set) {
            Object p = this.edgeProperty(direction, edge, n, string);
            if (p == null) continue;
            hashMap.put(string, p);
        }
        return hashMap;
    }

    public <V> Optional<V> edgePropertyOption(Direction direction, Edge edge, int n, String string) {
        Object p = this.edgeProperty(direction, edge, n, string);
        return Optional.ofNullable(p);
    }

    public <P> P edgeProperty(Direction direction, Edge edge, int n, String string) {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        int n2 = this.getEdgePropertyIndex(adjacentNodes, direction, edge.label(), string, n);
        if (n2 == -1) {
            return null;
        }
        return (P)adjacentNodes.nodesWithEdgeProperties[n2];
    }

    public synchronized <V> void setEdgeProperty(Direction direction, String string, String string2, V v, int n) {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        int n2 = this.getEdgePropertyIndex(adjacentNodes, direction, string, string2, n);
        if (n2 == -1) {
            throw new RuntimeException("Edge " + string + " does not support property `" + string2 + "`.");
        }
        adjacentNodes.nodesWithEdgeProperties[n2] = v;
        this.markAsDirty();
    }

    public void removeEdgeProperty(Direction direction, String string, String string2, int n) {
        this.setEdgeProperty(direction, string, string2, null, n);
    }

    private int calcAdjacentNodeIndex(AdjacentNodes adjacentNodes, Direction direction, String string, int n) {
        int n2 = this.getPositionInEdgeOffsets(direction, string);
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.startIndex(adjacentNodes, n2);
        return n3 + n;
    }

    private int getEdgePropertyIndex(AdjacentNodes adjacentNodes, Direction direction, String string, String string2, int n) {
        int n2 = this.calcAdjacentNodeIndex(adjacentNodes, direction, string, n);
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.layoutInformation().getEdgePropertyOffsetRelativeToAdjacentNodeRef(string, string2);
        if (n3 == -1) {
            return -1;
        }
        return n2 + n3;
    }

    @Override
    protected Edge addEdgeImpl(String string, Node node, Object ... objectArray) {
        NodeRef nodeRef = (NodeRef)node;
        NodeRef<?> nodeRef2 = this.ref;
        int n = this.storeAdjacentNode(Direction.OUT, string, nodeRef, objectArray);
        int n2 = ((NodeDb)nodeRef.get()).storeAdjacentNode(Direction.IN, string, nodeRef2, objectArray);
        Edge edge = this.instantiateDummyEdge(string, nodeRef2, nodeRef);
        edge.setOutBlockOffset(n);
        edge.setInBlockOffset(n2);
        return edge;
    }

    @Override
    protected Edge addEdgeImpl(String string, Node node, Map<String, Object> map) {
        return this.addEdge(string, node, PropertyHelper.toKeyValueArray(map));
    }

    @Override
    protected void addEdgeSilentImpl(String string, Node node, Object ... objectArray) {
        NodeRef nodeRef = (NodeRef)node;
        this.storeAdjacentNode(Direction.OUT, string, nodeRef, objectArray);
        ((NodeDb)nodeRef.get()).storeAdjacentNode(Direction.IN, string, this.ref, objectArray);
    }

    @Override
    protected void addEdgeSilentImpl(String string, Node node, Map<String, Object> map) {
        this.addEdgeSilent(string, node, PropertyHelper.toKeyValueArray(map));
    }

    @Override
    public java.util.Iterator<Node> out() {
        return this.createAdjacentNodeIterator(Direction.OUT, ALL_LABELS);
    }

    @Override
    public java.util.Iterator<Node> out(String ... stringArray) {
        return this.createAdjacentNodeIterator(Direction.OUT, stringArray);
    }

    @Override
    public java.util.Iterator<Node> in() {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        for (String string : this.layoutInformation().allowedInEdgeLabels()) {
            multiIterator.addIterator(this.in(string));
        }
        return multiIterator;
    }

    @Override
    public java.util.Iterator<Node> in(String ... stringArray) {
        return this.createAdjacentNodeIterator(Direction.IN, stringArray);
    }

    @Override
    public java.util.Iterator<Node> both() {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        multiIterator.addIterator(this.out());
        multiIterator.addIterator(this.in());
        return multiIterator;
    }

    @Override
    public java.util.Iterator<Node> both(String ... stringArray) {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        multiIterator.addIterator(this.out(stringArray));
        multiIterator.addIterator(this.in(stringArray));
        return multiIterator;
    }

    @Override
    public java.util.Iterator<Edge> outE() {
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        for (String string : this.layoutInformation().allowedOutEdgeLabels()) {
            multiIterator.addIterator(this.outE(string));
        }
        return multiIterator;
    }

    @Override
    public java.util.Iterator<Edge> outE(String ... stringArray) {
        return this.createDummyEdgeIterator(Direction.OUT, stringArray);
    }

    @Override
    public java.util.Iterator<Edge> inE() {
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        for (String string : this.layoutInformation().allowedInEdgeLabels()) {
            multiIterator.addIterator(this.inE(string));
        }
        return multiIterator;
    }

    @Override
    public java.util.Iterator<Edge> inE(String ... stringArray) {
        return this.createDummyEdgeIterator(Direction.IN, stringArray);
    }

    @Override
    public java.util.Iterator<Edge> bothE() {
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        multiIterator.addIterator(this.outE());
        multiIterator.addIterator(this.inE());
        return multiIterator;
    }

    @Override
    public java.util.Iterator<Edge> bothE(String ... stringArray) {
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        multiIterator.addIterator(this.outE(stringArray));
        multiIterator.addIterator(this.inE(stringArray));
        return multiIterator;
    }

    protected int outEdgeCount() {
        int n = 0;
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        for (String string : this.layoutInformation().allowedOutEdgeLabels()) {
            int n2 = this.getPositionInEdgeOffsets(Direction.OUT, string);
            if (n2 == -1) continue;
            int n3 = this.startIndex(adjacentNodes, n2);
            int n4 = this.blockLength(adjacentNodes, n2);
            int n5 = this.getStrideSize(string);
            int n6 = n3 + n4;
            for (int i = n3; i < adjacentNodes.nodesWithEdgeProperties.length && i < n6; i += n5) {
                if (adjacentNodes.nodesWithEdgeProperties[i] == null) continue;
                ++n;
            }
        }
        return n;
    }

    protected final int blockOffsetToOccurrence(Direction direction, String string, NodeRef<?> nodeRef, int n) {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        int n2 = this.getPositionInEdgeOffsets(direction, string);
        int n3 = this.startIndex(adjacentNodes, n2);
        int n4 = this.getStrideSize(string);
        Object[] objectArray = adjacentNodes.nodesWithEdgeProperties;
        int n5 = -1;
        for (int i = n3; i <= n3 + n; i += n4) {
            NodeRef nodeRef2 = (NodeRef)objectArray[i];
            if (nodeRef2 == null || nodeRef2.id() != nodeRef.id()) continue;
            ++n5;
        }
        if (n5 == -1) {
            throw new RuntimeException("unable to calculate occurrenceCount");
        }
        return n5;
    }

    protected final int occurrenceToBlockOffset(Direction direction, String string, NodeRef<?> nodeRef, int n) {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        int n2 = this.getPositionInEdgeOffsets(direction, string);
        int n3 = this.startIndex(adjacentNodes, n2);
        int n4 = this.blockLength(adjacentNodes, n2);
        int n5 = this.getStrideSize(string);
        Object[] objectArray = adjacentNodes.nodesWithEdgeProperties;
        int n6 = 0;
        int n7 = n3 + n4;
        for (int i = n3; i < n7; i += n5) {
            NodeRef nodeRef2 = (NodeRef)objectArray[i];
            if (nodeRef2 == null || nodeRef2.id() != nodeRef.id()) continue;
            if (n6 == n) {
                return i - n3;
            }
            ++n6;
        }
        throw new RuntimeException("Unable to find occurrence " + n + " of " + string + " edge to node " + nodeRef.id());
    }

    protected final synchronized void removeEdge(Direction direction, String string, int n) {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        int n2 = this.getPositionInEdgeOffsets(direction, string);
        int n3 = this.startIndex(adjacentNodes, n2) + n;
        int n4 = this.getStrideSize(string);
        Object[] objectArray = adjacentNodes.nodesWithEdgeProperties;
        for (int i = n3; i < n3 + n4; ++i) {
            objectArray[i] = null;
        }
        this.markAsDirty();
    }

    private java.util.Iterator<Edge> createDummyEdgeIterator(Direction direction, String ... stringArray) {
        if (stringArray.length == 1) {
            return this.createDummyEdgeIteratorForSingleLabel(this.adjacentNodes, direction, stringArray[0]);
        }
        String[] stringArray2 = stringArray.length == 0 ? this.allowedLabelsByDirection(direction) : stringArray;
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        for (String string : stringArray2) {
            multiIterator.addIterator(this.createDummyEdgeIteratorForSingleLabel(this.adjacentNodes, direction, string));
        }
        return multiIterator;
    }

    private java.util.Iterator<Edge> createDummyEdgeIteratorForSingleLabel(AdjacentNodes adjacentNodes, Direction direction, String string) {
        int n = this.getPositionInEdgeOffsets(direction, string);
        if (n != -1) {
            int n2 = this.startIndex(adjacentNodes, n);
            int n3 = this.blockLength(adjacentNodes, n);
            int n4 = this.getStrideSize(string);
            return new DummyEdgeIterator(adjacentNodes.nodesWithEdgeProperties, n2, n2 + n3, n4, direction, string, this.ref);
        }
        return Collections.emptyIterator();
    }

    private <A extends Node> java.util.Iterator<A> createAdjacentNodeIterator(Direction direction, String ... stringArray) {
        if (stringArray.length == 1) {
            return this.createAdjacentNodeIteratorByOffSet(this.getPositionInEdgeOffsets(direction, stringArray[0]));
        }
        String[] stringArray2 = stringArray.length == 0 ? this.allowedLabelsByDirection(direction) : stringArray;
        MultiIterator<A> multiIterator = new MultiIterator<A>();
        for (String string : stringArray2) {
            multiIterator.addIterator(this.createAdjacentNodeIteratorByOffSet(this.getPositionInEdgeOffsets(direction, string)));
        }
        return multiIterator;
    }

    public final <A extends Node> java.util.Iterator<A> createAdjacentNodeIteratorByOffSet(int n) {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        if (n != -1) {
            int n2 = this.startIndex(adjacentNodes, n);
            int n3 = this.blockLength(adjacentNodes, n);
            int n4 = this.layoutInformation().getEdgePropertyCountByOffsetPos(n) + 1;
            return new ArrayOffsetIterator(adjacentNodes.nodesWithEdgeProperties, n2, n2 + n3, n4);
        }
        return Collections.emptyIterator();
    }

    public final <A extends Node> Iterator<A> createAdjacentNodeScalaIteratorByOffSet(int n) {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        if (n != -1) {
            int n2 = this.startIndex(adjacentNodes, n);
            int n3 = this.blockLength(adjacentNodes, n);
            int n4 = this.layoutInformation().getEdgePropertyCountByOffsetPos(n) + 1;
            return new ArrayIter(adjacentNodes.nodesWithEdgeProperties, n2, n2 + n3, n4);
        }
        return Iterator.empty();
    }

    private String[] allowedLabelsByDirection(Direction direction) {
        if (direction.equals((Object)Direction.OUT)) {
            return this.layoutInformation().allowedOutEdgeLabels();
        }
        if (direction.equals((Object)Direction.IN)) {
            return this.layoutInformation().allowedInEdgeLabels();
        }
        throw new UnsupportedOperationException(direction.toString());
    }

    public synchronized int storeAdjacentNode(Direction direction, String string, NodeRef<?> nodeRef, Object ... objectArray) {
        int n = this.storeAdjacentNode(direction, string, nodeRef);
        for (int i = 0; i < objectArray.length; i += 2) {
            String string2 = (String)objectArray[i];
            Object object = objectArray[i + 1];
            this.setEdgeProperty(direction, string, string2, object, n);
        }
        this.markAsDirty();
        return n;
    }

    private int storeAdjacentNode(Direction direction, String string, NodeRef<?> nodeRef) {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        int n = this.getPositionInEdgeOffsets(direction, string);
        if (n == -1) {
            throw new RuntimeException(String.format("Edge with type='%s' with direction='%s' not supported by nodeType='%s'", new Object[]{string, direction, this.label()}));
        }
        int n2 = this.startIndex(adjacentNodes, n);
        int n3 = this.blockLength(adjacentNodes, n);
        int n4 = this.getStrideSize(string);
        Object[] objectArray = adjacentNodes.nodesWithEdgeProperties;
        int n5 = adjacentNodes.offsetLengths() >> 1;
        int n6 = n2 + n3;
        if (objectArray.length <= n6 || objectArray[n6] != null || n + 1 < n5 && n6 >= this.startIndex(adjacentNodes, n + 1)) {
            adjacentNodes = this.growAdjacentNodesWithEdgeProperties(adjacentNodes, n, n4, n6, n3);
        }
        adjacentNodes.nodesWithEdgeProperties[n6] = nodeRef;
        this.adjacentNodes = adjacentNodes = adjacentNodes.setOffset(2 * n + 1, n3 + n4);
        return n3;
    }

    public int startIndex(AdjacentNodes adjacentNodes, int n) {
        return adjacentNodes.getOffset(2 * n);
    }

    public final int getStrideSize(String string) {
        int n = 1;
        Set<String> set = this.layoutInformation().edgePropertyKeys(string);
        return n + set.size();
    }

    private int getPositionInEdgeOffsets(Direction direction, String string) {
        Integer n = direction == Direction.OUT ? this.layoutInformation().outEdgeToOffsetPosition(string) : this.layoutInformation().inEdgeToOffsetPosition(string);
        return Objects.requireNonNullElse(n, -1);
    }

    public final int blockLength(AdjacentNodes adjacentNodes, int n) {
        return adjacentNodes.getOffset(2 * n + 1);
    }

    private AdjacentNodes growAdjacentNodesWithEdgeProperties(AdjacentNodes adjacentNodes, int n, int n2, int n3, int n4) {
        int n5 = 2;
        int n6 = (n4 + n2) * n5;
        Object[] objectArray = adjacentNodes.nodesWithEdgeProperties;
        int n7 = objectArray.length + n6;
        Object[] objectArray2 = new Object[n7];
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        System.arraycopy(objectArray, n3, objectArray2, n3 + n6, objectArray.length - n3);
        AdjacentNodes adjacentNodes2 = new AdjacentNodes(objectArray2, adjacentNodes.offsets);
        int n8 = adjacentNodes2.offsetLengths();
        int n9 = n + 1;
        while (2 * n9 < n8) {
            adjacentNodes2 = adjacentNodes2.setOffset(2 * n9, adjacentNodes2.getOffset(2 * n9) + n6);
            ++n9;
        }
        return adjacentNodes2;
    }

    public final Edge instantiateDummyEdge(String string, NodeRef<?> nodeRef, NodeRef<?> nodeRef2) {
        EdgeFactory<?> edgeFactory = this.ref.graph.edgeFactoryByLabel.get(string);
        if (edgeFactory == null) {
            throw new IllegalArgumentException("specializedEdgeFactory for label=" + string + " not found - please register on startup!");
        }
        return edgeFactory.createEdge(this.ref.graph, nodeRef, nodeRef2);
    }

    public synchronized long trim() {
        AdjacentNodes adjacentNodes = this.adjacentNodes;
        int n = 0;
        int n2 = adjacentNodes.offsetLengths();
        int n3 = 0;
        while (2 * n3 < n2) {
            int n4 = this.blockLength(adjacentNodes, n3);
            n += n4;
            ++n3;
        }
        Object[] objectArray = new Object[n];
        AdjacentNodes adjacentNodes2 = new AdjacentNodes(objectArray, new byte[n2]);
        int n5 = 0;
        int n6 = 0;
        while (2 * n6 < n2) {
            int n7 = this.startIndex(adjacentNodes, n6);
            int n8 = this.blockLength(adjacentNodes, n6);
            System.arraycopy(adjacentNodes.nodesWithEdgeProperties, n7, objectArray, n5, n8);
            adjacentNodes2 = adjacentNodes2.setOffset(2 * n6, n5);
            adjacentNodes2 = adjacentNodes2.setOffset(2 * n6 + 1, n8);
            n5 += n8;
            ++n6;
        }
        n6 = adjacentNodes.nodesWithEdgeProperties.length;
        this.adjacentNodes = adjacentNodes2;
        return (long)n + ((long)n6 << 32);
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public int hashCode() {
        long l = (this.id() ^ this.id() >>> 33 ^ 0xC89F69FAAA76B9B7L) * -6643127405084517747L;
        return (int)l ^ (int)(l >>> 32);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof NodeDb && this.id() == ((Node)object).id();
    }
}

