/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import overflowdb.EdgeLayoutInformation;

public class NodeLayoutInformation {
    public final String label;
    private final Set<String> propertyKeys;
    private final String[] allowedOutEdgeLabels;
    private final String[] allowedInEdgeLabels;
    private final Map<String, Integer> outEdgeToOffsetPosition;
    private final Map<String, Integer> inEdgeToOffsetPosition;
    private final Map<String, HashSet<String>> edgePropertyKeysByLabel;
    private final int[] edgePropertyCountByOffsetPosition;
    private final Map<LabelAndKey, Integer> edgeLabelAndKeyToStrideIndex;

    public NodeLayoutInformation(String string, Set<String> set, List<EdgeLayoutInformation> list, List<EdgeLayoutInformation> list2) {
        this.label = string;
        this.propertyKeys = set;
        HashSet<EdgeLayoutInformation> hashSet = new HashSet<EdgeLayoutInformation>();
        hashSet.addAll(list);
        hashSet.addAll(list2);
        this.edgePropertyKeysByLabel = this.createEdgePropertyKeysByLabel(hashSet);
        this.edgeLabelAndKeyToStrideIndex = this.createEdgeLabelAndKeyToStrideIndex(hashSet);
        this.allowedOutEdgeLabels = new String[list.size()];
        this.allowedInEdgeLabels = new String[list2.size()];
        int n = 0;
        this.edgePropertyCountByOffsetPosition = new int[list.size() + list2.size()];
        int n2 = 0;
        this.outEdgeToOffsetPosition = new HashMap<String, Integer>(list.size());
        for (EdgeLayoutInformation edgeLayoutInformation : list) {
            this.edgePropertyCountByOffsetPosition[n] = this.edgePropertyKeysByLabel.get(edgeLayoutInformation.label).size();
            this.outEdgeToOffsetPosition.put(edgeLayoutInformation.label, n++);
            this.allowedOutEdgeLabels[n2++] = edgeLayoutInformation.label;
        }
        n2 = 0;
        this.inEdgeToOffsetPosition = new HashMap<String, Integer>(list2.size());
        for (EdgeLayoutInformation edgeLayoutInformation : list2) {
            this.edgePropertyCountByOffsetPosition[n] = this.edgePropertyKeysByLabel.get(edgeLayoutInformation.label).size();
            this.inEdgeToOffsetPosition.put(edgeLayoutInformation.label, n++);
            this.allowedInEdgeLabels[n2++] = edgeLayoutInformation.label;
        }
    }

    private Map<String, HashSet<String>> createEdgePropertyKeysByLabel(Set<EdgeLayoutInformation> set) {
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(set.size());
        for (EdgeLayoutInformation edgeLayoutInformation : set) {
            hashMap.put(edgeLayoutInformation.label, new HashSet<String>(edgeLayoutInformation.propertyKeys));
        }
        return hashMap;
    }

    private Map<LabelAndKey, Integer> createEdgeLabelAndKeyToStrideIndex(Set<EdgeLayoutInformation> set) {
        HashMap<LabelAndKey, Integer> hashMap = new HashMap<LabelAndKey, Integer>(set.size());
        for (EdgeLayoutInformation edgeLayoutInformation : set) {
            int n = 1;
            for (String string : this.sorted(edgeLayoutInformation.propertyKeys)) {
                hashMap.put(new LabelAndKey(this, edgeLayoutInformation.label, string), n++);
            }
        }
        return hashMap;
    }

    private Iterable<String> sorted(Set<String> set) {
        TreeSet<String> treeSet = new TreeSet<String>(String::compareTo);
        treeSet.addAll(set);
        return treeSet;
    }

    private SortedSet<EdgeLayoutInformation> sortByLabel(List<EdgeLayoutInformation> list) {
        TreeSet<EdgeLayoutInformation> treeSet = new TreeSet<EdgeLayoutInformation>(Comparator.comparing(edgeLayoutInformation -> edgeLayoutInformation.label));
        treeSet.addAll(list);
        return treeSet;
    }

    public Set<String> propertyKeys() {
        return this.propertyKeys;
    }

    public String[] allowedOutEdgeLabels() {
        return this.allowedOutEdgeLabels;
    }

    public String[] allowedInEdgeLabels() {
        return this.allowedInEdgeLabels;
    }

    public Set<String> edgePropertyKeys(String string) {
        return this.edgePropertyKeysByLabel.get(string);
    }

    public int numberOfDifferentAdjacentTypes() {
        return this.outEdgeToOffsetPosition.size() + this.inEdgeToOffsetPosition.size();
    }

    public Integer outEdgeToOffsetPosition(String string) {
        return this.outEdgeToOffsetPosition.get(string);
    }

    public Integer inEdgeToOffsetPosition(String string) {
        return this.inEdgeToOffsetPosition.get(string);
    }

    public int getEdgePropertyOffsetRelativeToAdjacentNodeRef(String string, String string2) {
        return this.edgeLabelAndKeyToStrideIndex.getOrDefault(new LabelAndKey(this, string, string2), -1);
    }

    public final int getEdgePropertyCountByOffsetPos(int n) {
        return this.edgePropertyCountByOffsetPosition[n];
    }

    class LabelAndKey {
        final String label;
        final String propertyKey;

        LabelAndKey(NodeLayoutInformation nodeLayoutInformation, String string, String string2) {
            this.label = string;
            this.propertyKey = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LabelAndKey labelAndKey = (LabelAndKey)object;
            return this.label.equals(labelAndKey.label) && this.propertyKey.equals(labelAndKey.propertyKey);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.propertyKey);
        }
    }
}

