/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import overflowdb.DetachedNodeData;
import overflowdb.Edge;
import overflowdb.Element;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.Property;
import overflowdb.PropertyKey;

public abstract class NodeRef<N extends NodeDb>
extends Node {
    protected final long id;
    protected final Graph graph;
    private N node;

    public NodeRef(Graph graph, N n) {
        this.graph = graph;
        this.node = n;
        this.id = ((NodeDb)n).ref.id;
    }

    public NodeRef(Graph graph, long l) {
        this.graph = graph;
        this.id = l;
        NodeRef nodeRef = (NodeRef)graph.node(l);
        if (nodeRef != null) {
            this.node = nodeRef.node;
        }
    }

    public boolean isSet() {
        return this.node != null;
    }

    public boolean isCleared() {
        return this.node == null;
    }

    public static void clear(NodeRef nodeRef) {
        nodeRef.node = null;
    }

    protected byte[] serializeWhenDirty() {
        N n = this.node;
        if (n != null && ((NodeDb)n).isDirty()) {
            try {
                return this.graph.nodeSerializer.serialize((NodeDb)n);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    protected void persist(byte[] byArray) {
        this.graph.storage.persist(this.id, byArray);
    }

    public final N get() {
        N n = this.node;
        if (n != null) {
            return n;
        }
        try {
            return this.getSynchronized();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private synchronized N getSynchronized() throws IOException {
        N n = this.node;
        if (n != null) {
            return n;
        }
        N n2 = this.readFromDisk();
        if (n2 == null) {
            throw new IllegalStateException("unable to read node from disk; id=" + this.id);
        }
        if (this.node != n2) {
            throw new AssertionError((Object)("invalid state after reading node from dist; id=" + this.id));
        }
        this.graph.registerNodeRef(this);
        return n2;
    }

    public final Optional<N> getOption() {
        return Optional.ofNullable(this.node);
    }

    public void setNode(N n) {
        this.node = n;
    }

    private final N readFromDisk() throws IOException {
        byte[] byArray = this.graph.storage.getSerializedNode(this.id);
        return (N)this.graph.nodeDeserializer.deserialize(byArray, this);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    protected void removeImpl() {
        ((Element)this.get()).removeInternal();
        NodeRef.clear(this);
    }

    public int hashCode() {
        long l = (this.id ^ this.id >>> 33) * 2063233195183692209L;
        return (int)l ^ (int)(l >>> 32);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof NodeRef && this.id == ((NodeRef)object).id;
    }

    @Override
    protected Edge addEdgeImpl(String string, Node node, Object ... objectArray) {
        return ((Node)this.get()).addEdgeInternal(string, node, objectArray);
    }

    @Override
    protected Edge addEdgeImpl(String string, Node node, Map<String, Object> map) {
        return ((Node)this.get()).addEdgeInternal(string, node, map);
    }

    @Override
    protected void addEdgeSilentImpl(String string, Node node, Object ... objectArray) {
        ((Node)this.get()).addEdgeSilentInternal(string, node, objectArray);
    }

    @Override
    protected void addEdgeSilentImpl(String string, Node node, Map<String, Object> map) {
        ((Node)this.get()).addEdgeSilentInternal(string, node, map);
    }

    @Override
    public Map<String, Object> propertiesMap() {
        return ((NodeDb)this.get()).propertiesMap();
    }

    @Override
    public Object property(String string) {
        return ((Element)this.get()).property(string);
    }

    @Override
    public <A> A property(PropertyKey<A> propertyKey) {
        return ((NodeDb)this.get()).property(propertyKey);
    }

    @Override
    public <A> Optional<A> propertyOption(PropertyKey<A> propertyKey) {
        return ((NodeDb)this.get()).propertyOption(propertyKey);
    }

    @Override
    public Optional<Object> propertyOption(String string) {
        return ((NodeDb)this.get()).propertyOption(string);
    }

    @Override
    protected <A> void setPropertyImpl(PropertyKey<A> propertyKey, A a) {
        ((Element)this.get()).setPropertyInternal(propertyKey, a);
    }

    @Override
    protected void setPropertyImpl(Property<?> property) {
        ((Element)this.get()).setPropertyInternal(property);
    }

    @Override
    protected void setPropertyImpl(String string, Object object) {
        ((Element)this.get()).setPropertyInternal(string, object);
    }

    @Override
    public Set<String> propertyKeys() {
        return ((NodeDb)this.get()).propertyKeys();
    }

    @Override
    protected void removePropertyImpl(String string) {
        ((Element)this.get()).removePropertyInternal(string);
    }

    @Override
    public Iterator<Node> out() {
        return ((NodeDb)this.get()).out();
    }

    @Override
    public Iterator<Node> out(String ... stringArray) {
        return ((NodeDb)this.get()).out(stringArray);
    }

    @Override
    public Iterator<Node> in() {
        return ((NodeDb)this.get()).in();
    }

    @Override
    public Iterator<Node> in(String ... stringArray) {
        return ((NodeDb)this.get()).in(stringArray);
    }

    @Override
    public Iterator<Node> both() {
        return ((NodeDb)this.get()).both();
    }

    @Override
    public Iterator<Node> both(String ... stringArray) {
        return ((NodeDb)this.get()).both(stringArray);
    }

    @Override
    public Iterator<Edge> outE() {
        return ((NodeDb)this.get()).outE();
    }

    @Override
    public Iterator<Edge> outE(String ... stringArray) {
        return ((NodeDb)this.get()).outE(stringArray);
    }

    @Override
    public Iterator<Edge> inE() {
        return ((NodeDb)this.get()).inE();
    }

    @Override
    public Iterator<Edge> inE(String ... stringArray) {
        return ((NodeDb)this.get()).inE(stringArray);
    }

    @Override
    public Iterator<Edge> bothE() {
        return ((NodeDb)this.get()).bothE();
    }

    @Override
    public Iterator<Edge> bothE(String ... stringArray) {
        return ((NodeDb)this.get()).bothE(stringArray);
    }

    @Override
    protected void _initializeFromDetached(DetachedNodeData detachedNodeData, Function<DetachedNodeData, Node> function) {
        ((Node)this.get())._initializeFromDetached(detachedNodeData, function);
    }

    public String toString() {
        return this.getClass().getName() + "[label=" + this.label() + "; id=" + this.id + "]";
    }
}

