/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import overflowdb.NodeRef;
import overflowdb.storage.NodesWriter;
import overflowdb.storage.OdbStorage;
import overflowdb.util.NamedThreadFactory;

public class ReferenceManager
implements AutoCloseable {
    public final int releaseCount = 100000;
    private final AtomicInteger totalReleaseCount = new AtomicInteger(0);
    private final ExecutorService executorService;
    private final boolean shutdownExecutorOnClose;
    private int clearingProcessCount = 0;
    private final Object backPressureSyncObject = new Object();
    private final OdbStorage storage;
    private final NodesWriter nodesWriter;
    private final List<NodeRef> clearableRefs = Collections.synchronizedList(new ArrayList());

    public ReferenceManager(OdbStorage odbStorage, NodesWriter nodesWriter) {
        this.storage = odbStorage;
        this.nodesWriter = nodesWriter;
        this.executorService = Executors.newSingleThreadExecutor(new NamedThreadFactory("overflowdb-reference-manager"));
        this.shutdownExecutorOnClose = true;
    }

    public ReferenceManager(OdbStorage odbStorage, NodesWriter nodesWriter, ExecutorService executorService) {
        this.storage = odbStorage;
        this.nodesWriter = nodesWriter;
        this.executorService = executorService;
        this.shutdownExecutorOnClose = false;
    }

    public void registerRef(NodeRef nodeRef) {
        this.clearableRefs.add(nodeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyBackpressureMaybe() {
        Object object = this.backPressureSyncObject;
        synchronized (object) {
            while (this.clearingProcessCount > 0) {
                try {
                    this.backPressureSyncObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
        }
    }

    private void syncClearReferences(int n) {
        List<NodeRef> list = this.collectRefsToClear(n);
        if (!list.isEmpty()) {
            this.safelyClearReferences(list);
        }
    }

    private List<NodeRef> collectRefsToClear(int n) {
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>(n);
        while (n > 0 && !this.clearableRefs.isEmpty()) {
            NodeRef nodeRef = this.clearableRefs.removeFirst();
            if (nodeRef != null) {
                arrayList.add(nodeRef);
            }
            --n;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyClearReferences(List<NodeRef> list) {
        Object object;
        try {
            object = this.backPressureSyncObject;
            synchronized (object) {
                ++this.clearingProcessCount;
            }
            this.nodesWriter.writeAndClearBatched(list.spliterator(), list.size());
            this.storage.flush();
        }
        catch (Exception exception) {
            Object object2 = this.backPressureSyncObject;
            synchronized (object2) {
                --this.clearingProcessCount;
                if (this.clearingProcessCount == 0) {
                    this.backPressureSyncObject.notifyAll();
                }
            }
        }
        finally {
            object = this.backPressureSyncObject;
            synchronized (object) {
                --this.clearingProcessCount;
                if (this.clearingProcessCount == 0) {
                    this.backPressureSyncObject.notifyAll();
                }
            }
        }
    }

    public void clearAllReferences() {
        this.nodesWriter.writeAndClearBatched(this.clearableRefs.spliterator(), this.clearableRefs.size());
    }

    @Override
    public void close() {
        if (this.shutdownExecutorOnClose) {
            this.executorService.shutdown();
        }
    }
}

