/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BookKeeper {
    public final boolean statsEnabled;
    private final AtomicInteger totalCount = new AtomicInteger(0);
    private final AtomicLong totalTimeSpentNanos = new AtomicLong(0L);

    protected BookKeeper(boolean bl) {
        this.statsEnabled = bl;
    }

    protected final long getStartTimeNanos() {
        return this.statsEnabled ? System.nanoTime() : 0L;
    }

    protected void recordStatistics(long l) {
        this.totalCount.incrementAndGet();
        this.totalTimeSpentNanos.addAndGet(System.nanoTime() - l);
    }

    public final int getSerializedCount() {
        if (this.statsEnabled) {
            return this.totalCount.intValue();
        }
        throw new RuntimeException("serialization statistics not enabled");
    }
}

