/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.Value;
import overflowdb.Direction;
import overflowdb.Graph;
import overflowdb.NodeDb;
import overflowdb.NodeFactory;
import overflowdb.NodeRef;
import overflowdb.storage.BookKeeper;
import overflowdb.storage.OdbStorage;
import overflowdb.storage.ValueTypes;
import overflowdb.util.PropertyHelper;
import overflowdb.util.StringInterner;

public class NodeDeserializer
extends BookKeeper {
    protected final Graph graph;
    private final Map<String, NodeFactory<?>> nodeFactoryByLabel;
    private final OdbStorage storage;
    private final StringInterner stringInterner;
    private final ThreadLocal<Map<Integer, String>> stringCache = ThreadLocal.withInitial(HashMap::new);

    public NodeDeserializer(Graph graph, Map<String, NodeFactory<?>> map, boolean bl, OdbStorage odbStorage) {
        super(bl);
        this.graph = graph;
        this.stringInterner = graph.getStringInterner();
        this.nodeFactoryByLabel = map;
        this.storage = odbStorage;
    }

    public final NodeDb deserialize(byte[] byArray) throws IOException {
        return this.deserialize(byArray, null);
    }

    public final NodeDb deserialize(byte[] byArray, NodeRef nodeRef) throws IOException {
        long l = this.getStartTimeNanos();
        if (null == byArray) {
            return null;
        }
        MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker((byte[])byArray);
        long l2 = messageUnpacker.unpackLong();
        int n2 = messageUnpacker.unpackInt();
        Object[] objectArray = this.unpackProperties(messageUnpacker);
        Map<Integer, String> map = this.stringCache.get();
        String string = map.computeIfAbsent(n2, n -> this.storage.reverseLookupStringToIntMapping((int)n));
        Object obj = this.getNodeFactory(string).createNode(this.graph, l2, nodeRef);
        PropertyHelper.attachProperties(obj, objectArray);
        this.deserializeEdges(messageUnpacker, (NodeDb)obj, Direction.OUT);
        this.deserializeEdges(messageUnpacker, (NodeDb)obj, Direction.IN);
        ((NodeDb)obj).markAsClean();
        if (this.statsEnabled) {
            this.recordStatistics(l);
        }
        return obj;
    }

    private void deserializeEdges(MessageUnpacker messageUnpacker, NodeDb nodeDb, Direction direction) throws IOException {
        int n2 = messageUnpacker.unpackInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = messageUnpacker.unpackInt();
            Map<Integer, String> map = this.stringCache.get();
            String string = map.computeIfAbsent(n3, n -> this.storage.reverseLookupStringToIntMapping((int)n));
            int n4 = messageUnpacker.unpackInt();
            for (int j = 0; j < n4; ++j) {
                long l = messageUnpacker.unpackLong();
                NodeRef nodeRef = (NodeRef)this.graph.node(l);
                Object[] objectArray = this.unpackProperties(messageUnpacker);
                nodeDb.storeAdjacentNode(direction, string, nodeRef, objectArray);
            }
        }
    }

    public final NodeRef<?> deserializeRef(byte[] byArray) throws IOException {
        try (MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker((byte[])byArray);){
            long l = messageUnpacker.unpackLong();
            int n = messageUnpacker.unpackInt();
            String string = this.storage.reverseLookupStringToIntMapping(n);
            NodeRef<?> nodeRef = this.createNodeRef(l, string);
            return nodeRef;
        }
    }

    private Object[] unpackProperties(MessageUnpacker messageUnpacker) throws IOException {
        int n2 = messageUnpacker.unpackMapHeader();
        Object[] objectArray = new Object[n2 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = messageUnpacker.unpackInt();
            Map<Integer, String> map = this.stringCache.get();
            String string = map.computeIfAbsent(n4, n -> this.storage.reverseLookupStringToIntMapping((int)n));
            ImmutableValue immutableValue = messageUnpacker.unpackValue();
            Object object = this.unpackValue((ArrayValue)immutableValue.asArrayValue());
            objectArray[n3++] = string;
            objectArray[n3++] = object;
        }
        return objectArray;
    }

    private Object unpackValue(ArrayValue arrayValue) {
        Iterator iterator = arrayValue.iterator();
        byte by = ((Value)iterator.next()).asIntegerValue().asByte();
        Value value = (Value)iterator.next();
        return switch (ValueTypes.lookup(by)) {
            default -> throw new MatchException(null, null);
            case ValueTypes.UNKNOWN -> null;
            case ValueTypes.NODE_REF -> {
                long var5_5 = value.asIntegerValue().asLong();
                yield this.graph.node(var5_5);
            }
            case ValueTypes.BOOLEAN -> value.asBooleanValue().getBoolean();
            case ValueTypes.STRING -> this.stringInterner.intern(value.asStringValue().asString());
            case ValueTypes.BYTE -> value.asIntegerValue().asByte();
            case ValueTypes.SHORT -> value.asIntegerValue().asShort();
            case ValueTypes.INTEGER -> value.asIntegerValue().asInt();
            case ValueTypes.LONG -> value.asIntegerValue().asLong();
            case ValueTypes.FLOAT -> Float.valueOf(value.asFloatValue().toFloat());
            case ValueTypes.DOUBLE -> value.asFloatValue().toDouble();
            case ValueTypes.LIST -> this.deserializeList(value.asArrayValue());
            case ValueTypes.CHARACTER -> Character.valueOf((char)value.asIntegerValue().asInt());
            case ValueTypes.ARRAY_BYTE -> this.deserializeArrayByte(value.asArrayValue());
            case ValueTypes.ARRAY_SHORT -> this.deserializeArrayShort(value.asArrayValue());
            case ValueTypes.ARRAY_INT -> this.deserializeArrayInt(value.asArrayValue());
            case ValueTypes.ARRAY_LONG -> this.deserializeArrayLong(value.asArrayValue());
            case ValueTypes.ARRAY_FLOAT -> this.deserializeArrayFloat(value.asArrayValue());
            case ValueTypes.ARRAY_DOUBLE -> this.deserializeArrayDouble(value.asArrayValue());
            case ValueTypes.ARRAY_CHAR -> this.deserializeArrayChar(value.asArrayValue());
            case ValueTypes.ARRAY_BOOL -> this.deserializeArrayBoolean(value.asArrayValue());
            case ValueTypes.ARRAY_OBJECT -> this.deserializeArrayObject(value.asArrayValue());
        };
    }

    protected final NodeRef<?> createNodeRef(long l, String string) {
        return this.getNodeFactory(string).createNodeRef(this.graph, l);
    }

    private NodeFactory<?> getNodeFactory(String string) {
        if (!this.nodeFactoryByLabel.containsKey(string)) {
            throw new AssertionError((Object)String.format("nodeFactory not found for label=%s", string));
        }
        return this.nodeFactoryByLabel.get(string);
    }

    private Object deserializeList(ArrayValue arrayValue) {
        ArrayList<Object> arrayList = new ArrayList<Object>(arrayValue.size());
        for (Value value : arrayValue) {
            arrayList.add(this.unpackValue(value.asArrayValue()));
        }
        return arrayList;
    }

    private byte[] deserializeArrayByte(ArrayValue arrayValue) {
        byte[] byArray = new byte[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            byArray[n++] = value.asIntegerValue().asByte();
        }
        return byArray;
    }

    private short[] deserializeArrayShort(ArrayValue arrayValue) {
        short[] sArray = new short[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            sArray[n++] = value.asIntegerValue().asShort();
        }
        return sArray;
    }

    private int[] deserializeArrayInt(ArrayValue arrayValue) {
        int[] nArray = new int[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            nArray[n++] = value.asIntegerValue().asInt();
        }
        return nArray;
    }

    private long[] deserializeArrayLong(ArrayValue arrayValue) {
        long[] lArray = new long[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            lArray[n++] = value.asIntegerValue().asLong();
        }
        return lArray;
    }

    private float[] deserializeArrayFloat(ArrayValue arrayValue) {
        float[] fArray = new float[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            fArray[n++] = value.asFloatValue().toFloat();
        }
        return fArray;
    }

    private double[] deserializeArrayDouble(ArrayValue arrayValue) {
        double[] dArray = new double[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            dArray[n++] = value.asFloatValue().toDouble();
        }
        return dArray;
    }

    private char[] deserializeArrayChar(ArrayValue arrayValue) {
        char[] cArray = new char[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            cArray[n++] = (char)value.asIntegerValue().asInt();
        }
        return cArray;
    }

    private boolean[] deserializeArrayBoolean(ArrayValue arrayValue) {
        boolean[] blArray = new boolean[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            blArray[n++] = value.asBooleanValue().getBoolean();
        }
        return blArray;
    }

    private Object[] deserializeArrayObject(ArrayValue arrayValue) {
        Object[] objectArray = new Object[arrayValue.size()];
        int n = 0;
        for (Value value : arrayValue) {
            objectArray[n++] = this.unpackValue(value.asArrayValue());
        }
        return objectArray;
    }
}

