/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.IOException;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import overflowdb.AdjacentNodes;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.NodeLayoutInformation;
import overflowdb.NodeRef;
import overflowdb.storage.BookKeeper;
import overflowdb.storage.OdbStorage;
import overflowdb.storage.ValueTypes;

public class NodeSerializer
extends BookKeeper {
    private final OdbStorage storage;
    private final Function<Object, Object> convertPropertyForPersistence;
    private final ThreadLocal<MessageBufferPacker> packerPool = ThreadLocal.withInitial(MessagePack::newDefaultBufferPacker);

    public NodeSerializer(boolean bl, OdbStorage odbStorage, Function<Object, Object> function) {
        super(bl);
        this.storage = odbStorage;
        this.convertPropertyForPersistence = function;
    }

    public NodeSerializer(boolean bl, OdbStorage odbStorage) {
        this(bl, odbStorage, null);
    }

    public byte[] serialize(NodeDb nodeDb) throws IOException {
        MessageBufferPacker messageBufferPacker;
        long l = this.getStartTimeNanos();
        try (MessageBufferPacker messageBufferPacker2 = messageBufferPacker = this.packerPool.get();){
            messageBufferPacker.clear();
            NodeLayoutInformation nodeLayoutInformation = nodeDb.layoutInformation();
            nodeDb.markAsClean();
            messageBufferPacker.packLong(nodeDb.ref.id());
            int n = this.storage.lookupOrCreateStringToIntMapping(nodeLayoutInformation.label);
            messageBufferPacker.packInt(n);
            this.packProperties(messageBufferPacker, nodeDb.propertiesMapForStorage());
            this.packEdges(messageBufferPacker, nodeDb);
            if (this.statsEnabled) {
                this.recordStatistics(l);
            }
            byte[] byArray = messageBufferPacker.toByteArray();
            return byArray;
        }
    }

    private void packProperties(MessageBufferPacker messageBufferPacker, Map<String, Object> map) throws IOException {
        messageBufferPacker.packMapHeader(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            int n = this.storage.lookupOrCreateStringToIntMapping(entry.getKey());
            messageBufferPacker.packInt(n);
            Object object = entry.getValue();
            Object object2 = this.convertPropertyForPersistence == null ? object : this.convertPropertyForPersistence.apply(object);
            this.packTypedValue(messageBufferPacker, object2);
        }
    }

    private void packEdges(MessageBufferPacker messageBufferPacker, NodeDb nodeDb) throws IOException {
        NodeLayoutInformation nodeLayoutInformation = nodeDb.layoutInformation();
        this.packEdgesForOneDirection(messageBufferPacker, nodeDb, nodeDb.getAdjacentNodes(), nodeLayoutInformation.allowedOutEdgeLabels(), nodeLayoutInformation::outEdgeToOffsetPosition);
        this.packEdgesForOneDirection(messageBufferPacker, nodeDb, nodeDb.getAdjacentNodes(), nodeLayoutInformation.allowedInEdgeLabels(), nodeLayoutInformation::inEdgeToOffsetPosition);
    }

    private void packEdgesForOneDirection(MessageBufferPacker messageBufferPacker, NodeDb nodeDb, AdjacentNodes adjacentNodes, String[] stringArray, Function<String, Integer> function) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length * 2);
        int n = 0;
        for (String string : stringArray) {
            int n2 = function.apply(string);
            int n3 = adjacentNodes.getOffset(n2 * 2 + 1);
            if (n3 <= 0) continue;
            ++n;
            arrayList.add(string);
            arrayList.add(n2);
        }
        messageBufferPacker.packInt(n);
        for (int i = 0; i < arrayList.size(); i += 2) {
            String string = (String)arrayList.get(i);
            int n4 = (Integer)arrayList.get(i + 1);
            this.packEdgesForOneLabel(messageBufferPacker, nodeDb, adjacentNodes, string, n4);
        }
    }

    private void packEdgesForOneLabel(MessageBufferPacker messageBufferPacker, NodeDb nodeDb, AdjacentNodes adjacentNodes, String string, int n) throws IOException {
        NodeLayoutInformation nodeLayoutInformation = nodeDb.layoutInformation();
        Object[] objectArray = adjacentNodes.nodesWithEdgeProperties;
        Set<String> set = nodeLayoutInformation.edgePropertyKeys(string);
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(set.size() * 2);
        int n2 = 0;
        int n3 = nodeDb.startIndex(adjacentNodes, n);
        int n4 = nodeDb.blockLength(adjacentNodes, n);
        int n5 = nodeDb.getStrideSize(string);
        int n6 = n3 + n4;
        for (int i = n3; i < n6; i += n5) {
            Node node = (Node)objectArray[i];
            if (node == null) continue;
            ++n2;
            arrayList.add(Long.valueOf(node.id()));
            HashMap<String, Object> hashMap = new HashMap<String, Object>(set.size());
            for (String string2 : set) {
                int n7 = nodeLayoutInformation.getEdgePropertyOffsetRelativeToAdjacentNodeRef(string, string2);
                Object object = objectArray[i + n7];
                if (object == null) continue;
                hashMap.put(string2, object);
            }
            arrayList.add(hashMap);
        }
        int n8 = this.storage.lookupOrCreateStringToIntMapping(string);
        messageBufferPacker.packInt(n8);
        messageBufferPacker.packInt(n2);
        for (int i = 0; i < n2; ++i) {
            long l = (Long)arrayList.get(i * 2);
            messageBufferPacker.packLong(l);
            Map map = (Map)arrayList.get(i * 2 + 1);
            this.packProperties(messageBufferPacker, map);
        }
    }

    private void packTypedValue(MessageBufferPacker messageBufferPacker, Object object) throws IOException {
        messageBufferPacker.packArrayHeader(2);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NodeRef.class, Boolean.class, String.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, List.class, Object[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, char[].class, boolean[].class}, (Object)object2, n)) {
            case -1: {
                messageBufferPacker.packByte(ValueTypes.UNKNOWN.id);
                messageBufferPacker.packNil();
                break;
            }
            case 0: {
                NodeRef nodeRef = (NodeRef)object2;
                messageBufferPacker.packByte(ValueTypes.NODE_REF.id);
                messageBufferPacker.packLong(nodeRef.id());
                break;
            }
            case 1: {
                Boolean bl = (Boolean)object2;
                messageBufferPacker.packByte(ValueTypes.BOOLEAN.id);
                messageBufferPacker.packBoolean(bl.booleanValue());
                break;
            }
            case 2: {
                String string = (String)object2;
                messageBufferPacker.packByte(ValueTypes.STRING.id);
                messageBufferPacker.packString(string);
                break;
            }
            case 3: {
                Byte by = (Byte)object2;
                messageBufferPacker.packByte(ValueTypes.BYTE.id);
                messageBufferPacker.packByte(((Byte)object).byteValue());
                break;
            }
            case 4: {
                Short s = (Short)object2;
                messageBufferPacker.packByte(ValueTypes.SHORT.id);
                messageBufferPacker.packShort(((Short)object).shortValue());
                break;
            }
            case 5: {
                Integer n2 = (Integer)object2;
                messageBufferPacker.packByte(ValueTypes.INTEGER.id);
                messageBufferPacker.packInt(((Integer)object).intValue());
                break;
            }
            case 6: {
                Long l = (Long)object2;
                messageBufferPacker.packByte(ValueTypes.LONG.id);
                messageBufferPacker.packLong(((Long)object).longValue());
                break;
            }
            case 7: {
                Float f = (Float)object2;
                messageBufferPacker.packByte(ValueTypes.FLOAT.id);
                messageBufferPacker.packFloat(((Float)object).floatValue());
                break;
            }
            case 8: {
                Double d = (Double)object2;
                messageBufferPacker.packByte(ValueTypes.DOUBLE.id);
                messageBufferPacker.packDouble(((Double)object).doubleValue());
                break;
            }
            case 9: {
                Character c = (Character)object2;
                messageBufferPacker.packByte(ValueTypes.CHARACTER.id);
                messageBufferPacker.packInt((int)c.charValue());
                break;
            }
            case 10: {
                List list = (List)object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_OBJECT.id);
                messageBufferPacker.packArrayHeader(list.size());
                for (Object e : list) {
                    this.packTypedValue(messageBufferPacker, e);
                }
                break;
            }
            case 11: {
                Object[] objectArray = (Object[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_OBJECT.id);
                messageBufferPacker.packArrayHeader(objectArray.length);
                for (Object object3 : objectArray) {
                    this.packTypedValue(messageBufferPacker, object3);
                }
                break;
            }
            case 12: {
                byte[] byArray = (byte[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_BYTE.id);
                messageBufferPacker.packArrayHeader(byArray.length);
                for (byte by : byArray) {
                    messageBufferPacker.packByte(by);
                }
                break;
            }
            case 13: {
                short[] sArray = (short[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_SHORT.id);
                messageBufferPacker.packArrayHeader(sArray.length);
                for (short s : sArray) {
                    messageBufferPacker.packShort(s);
                }
                break;
            }
            case 14: {
                int[] nArray = (int[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_INT.id);
                messageBufferPacker.packArrayHeader(nArray.length);
                for (int n3 : nArray) {
                    messageBufferPacker.packInt(n3);
                }
                break;
            }
            case 15: {
                long[] lArray = (long[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_LONG.id);
                messageBufferPacker.packArrayHeader(lArray.length);
                for (long l : lArray) {
                    messageBufferPacker.packLong(l);
                }
                break;
            }
            case 16: {
                float[] fArray = (float[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_FLOAT.id);
                messageBufferPacker.packArrayHeader(fArray.length);
                for (float f : fArray) {
                    messageBufferPacker.packFloat(f);
                }
                break;
            }
            case 17: {
                double[] dArray = (double[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_DOUBLE.id);
                messageBufferPacker.packArrayHeader(dArray.length);
                for (double d : dArray) {
                    messageBufferPacker.packDouble(d);
                }
                break;
            }
            case 18: {
                char[] cArray = (char[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_CHAR.id);
                messageBufferPacker.packArrayHeader(cArray.length);
                for (char c : cArray) {
                    messageBufferPacker.packInt((int)c);
                }
                break;
            }
            case 19: {
                boolean[] blArray = (boolean[])object2;
                messageBufferPacker.packByte(ValueTypes.ARRAY_BOOL.id);
                messageBufferPacker.packArrayHeader(blArray.length);
                for (boolean bl : blArray) {
                    messageBufferPacker.packBoolean(bl);
                }
                break;
            }
            default: {
                String string = this.getFullMessageString(object);
                throw new UnsupportedOperationException(string);
            }
        }
    }

    private String getFullMessageString(Object object) {
        String string = String.format("value of type %s not supported for serialization - ", object.getClass());
        String string2 = this.convertPropertyForPersistence == null ? "there is no `convertPropertyForPersistence` function defined, you might want to do so during graph initialisation..." : "there is a `convertPropertyForPersistence`, but it doesn't convert the given type to one of the supported types";
        return String.format("%s - %s", string, string2);
    }
}

