/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.IOException;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.NodeRef;
import overflowdb.storage.NodeSerializer;
import overflowdb.storage.OdbStorage;

public class NodesWriter {
    private final NodeSerializer nodeSerializer;
    private final OdbStorage storage;

    public NodesWriter(NodeSerializer nodeSerializer, OdbStorage odbStorage) {
        this.nodeSerializer = nodeSerializer;
        this.storage = odbStorage;
    }

    public void writeAndClearBatched(Spliterator<? extends Node> spliterator, int n) {
        ((Stream)StreamSupport.stream(spliterator, true).map(this::serializeIfDirty).sequential()).forEach(serializedNode -> {
            if (serializedNode != null) {
                this.storage.persist(serializedNode.id, serializedNode.data);
            }
        });
    }

    private SerializedNode serializeIfDirty(Node node) {
        NodeDb nodeDb = null;
        NodeRef nodeRef = null;
        if (node instanceof NodeDb) {
            nodeDb = (NodeDb)node;
            nodeRef = nodeDb.ref;
        } else if (node instanceof NodeRef && (nodeRef = (NodeRef)node).isSet()) {
            nodeDb = nodeRef.get();
        }
        if (nodeDb != null && nodeDb.isDirty()) {
            try {
                byte[] byArray = this.nodeSerializer.serialize(nodeDb);
                NodeRef.clear(nodeRef);
                return new SerializedNode(nodeRef.id(), byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    private static class SerializedNode {
        private final long id;
        private final byte[] data;

        private SerializedNode(long l, byte[] byArray) {
            this.id = l;
            this.data = byArray;
        }
    }
}

