/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import overflowdb.Config;
import overflowdb.storage.BackwardsCompatibilityError;
import overflowdb.util.StringInterner;

public class OdbStorage
implements AutoCloseable {
    public static final int STORAGE_FORMAT_VERSION = 2;
    public static final String METADATA_KEY_STORAGE_FORMAT_VERSION = "STORAGE_FORMAT_VERSION";
    public static final String METADATA_KEY_STRING_TO_INT_MAX_ID = "STRING_TO_INT_MAX_ID";
    public static final String METADATA_KEY_LIBRARY_VERSIONS_MAX_ID = "LIBRARY_VERSIONS_MAX_ID";
    public static final String METADATA_PREFIX_LIBRARY_VERSIONS = "LIBRARY_VERSIONS_ENTRY_";
    private static final String INDEX_PREFIX = "index_";
    public static final int DEFAULT_COMPACT_FILL_RATE = 50;
    public static final int DEFAULT_COMMIT_BUFFER_SIZE = 65536;
    private final File mvstoreFile;
    private final StringInterner stringInterner;
    private final Config config;
    protected MVStore mvstore;
    private MVMap<Long, byte[]> nodesMVMap;
    private MVMap<String, String> metadataMVMap;
    private MVMap<String, Integer> stringToIntMappings;
    private boolean closed;
    private final AtomicInteger stringToIntMappingsMaxId = new AtomicInteger(0);
    private ArrayList<String> stringToIntReverseMappings;
    private int libraryVersionsIdCurrentRun;

    public static OdbStorage createWithTempFile(StringInterner stringInterner) {
        Config config = Config.withDefaults();
        return new OdbStorage(Optional.empty(), stringInterner, config);
    }

    public static OdbStorage createWithSpecificLocation(File file, StringInterner stringInterner) {
        Config config = Config.withDefaults();
        return new OdbStorage(Optional.ofNullable(file), stringInterner, config);
    }

    public static OdbStorage createWithTempFile(StringInterner stringInterner, Config config) {
        return new OdbStorage(Optional.empty(), stringInterner, config);
    }

    public static OdbStorage createWithSpecificLocation(File file, StringInterner stringInterner, Config config) {
        return new OdbStorage(Optional.ofNullable(file), stringInterner, config);
    }

    private OdbStorage(Optional<File> optional, StringInterner stringInterner, Config config) {
        this.config = config;
        this.stringInterner = stringInterner;
        if (optional.isPresent()) {
            this.mvstoreFile = optional.get();
            if (this.mvstoreFile.exists() && this.mvstoreFile.length() > 0L) {
                this.verifyStorageVersion();
                this.initializeStringToIntMaxId();
            }
        } else {
            try {
                this.mvstoreFile = File.createTempFile("mvstore", ".bin");
                if (!System.getProperty("os.name").toLowerCase().contains("win")) {
                    this.mvstoreFile.delete();
                } else {
                    this.mvstoreFile.deleteOnExit();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("cannot create tmp file for mvstore", iOException);
            }
        }
    }

    private void initializeStringToIntMaxId() {
        MVMap<String, String> mVMap = this.getMetaDataMVMap();
        if (mVMap.containsKey((Object)METADATA_KEY_STRING_TO_INT_MAX_ID)) {
            int n = Integer.parseInt((String)mVMap.get((Object)METADATA_KEY_STRING_TO_INT_MAX_ID));
            this.stringToIntMappingsMaxId.set(n);
        }
    }

    private void verifyStorageVersion() {
        this.ensureMVStoreAvailable();
        MVMap<String, String> mVMap = this.getMetaDataMVMap();
        if (!mVMap.containsKey((Object)METADATA_KEY_STORAGE_FORMAT_VERSION)) {
            throw new BackwardsCompatibilityError("storage metadata does not contain version number, this must be an old format.");
        }
        String string = (String)mVMap.get((Object)METADATA_KEY_STORAGE_FORMAT_VERSION);
        int n = Integer.parseInt(string);
        if (n != 2) {
            throw new BackwardsCompatibilityError(String.format("attempting to open storage with different version: %s; this version of overflowdb requires the version to be exactly %s", n, 2));
        }
    }

    public void persist(long l, byte[] byArray) {
        if (!this.closed) {
            this.getNodesMVMap().put((Object)l, (Object)byArray);
        }
    }

    public void flush() {
        if (this.mvstore != null) {
            this.getMetaDataMVMap().put((Object)METADATA_KEY_STORAGE_FORMAT_VERSION, (Object)String.format("%s", 2));
            this.getMetaDataMVMap().put((Object)METADATA_KEY_STRING_TO_INT_MAX_ID, (Object)String.format("%s", this.stringToIntMappingsMaxId.get()));
            this.mvstore.commit();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.flush();
        if (this.mvstore != null) {
            this.mvstore.close();
        }
    }

    public File getStorageFile() {
        return this.mvstoreFile;
    }

    public void removeNode(Long l) {
        this.getNodesMVMap().remove((Object)l);
    }

    public Set<Map.Entry<Long, byte[]>> allNodes() {
        return this.getNodesMVMap().entrySet();
    }

    public MVMap<Long, byte[]> getNodesMVMap() {
        this.ensureMVStoreAvailable();
        if (this.nodesMVMap == null) {
            this.nodesMVMap = this.mvstore.openMap("nodes");
        }
        return this.nodesMVMap;
    }

    public MVMap<String, String> getMetaDataMVMap() {
        this.ensureMVStoreAvailable();
        if (this.metadataMVMap == null) {
            this.metadataMVMap = this.mvstore.openMap("metadata");
        }
        return this.metadataMVMap;
    }

    public MVMap<String, Integer> getStringToIntMappings() {
        this.ensureMVStoreAvailable();
        if (this.stringToIntMappings == null) {
            this.stringToIntMappings = this.mvstore.openMap("stringToIntMappings");
        }
        if (this.stringToIntReverseMappings == null) {
            int n2 = this.stringToIntMappings.size();
            this.stringToIntReverseMappings = new ArrayList(n2);
            this.stringToIntMappings.forEach((string, n) -> {
                this.ensureCapacity(this.stringToIntReverseMappings, n + 1);
                this.stringToIntReverseMappings.set((int)n, (String)string);
            });
        }
        return this.stringToIntMappings;
    }

    public int lookupOrCreateStringToIntMapping(String string) {
        MVMap<String, Integer> mVMap = this.getStringToIntMappings();
        if (mVMap.containsKey((Object)string)) {
            return (Integer)mVMap.get((Object)string);
        }
        return this.createStringToIntMapping(string);
    }

    private int createStringToIntMapping(String string) {
        int n = this.stringToIntMappingsMaxId.incrementAndGet();
        this.getStringToIntMappings().put((Object)string, (Object)n);
        this.ensureCapacity(this.stringToIntReverseMappings, n + 1);
        this.stringToIntReverseMappings.set(n, string);
        return n;
    }

    private void ensureCapacity(ArrayList<String> arrayList, int n) {
        while (arrayList.size() < n) {
            arrayList.add(null);
        }
    }

    public String reverseLookupStringToIntMapping(int n) {
        this.getStringToIntMappings();
        String string = this.stringToIntReverseMappings.get(n);
        return this.stringInterner.intern(string);
    }

    private void ensureMVStoreAvailable() {
        if (this.mvstore == null) {
            this.mvstore = this.initializeMVStore();
            this.persistOdbLibraryVersion();
            this.libraryVersionsIdCurrentRun = this.initializeLibraryVersionsIdCurrentRun();
        }
    }

    private MVStore initializeMVStore() {
        MVStore.Builder builder = new MVStore.Builder().compressHigh().autoCompactFillRate(50).autoCommitBufferSize(65536);
        if (this.config.getCacheSize().isPresent()) {
            builder.cacheSize(this.config.getCacheSize().get().intValue());
        }
        if (this.config.getPageSplitSize().isPresent()) {
            builder.pageSplitSize(this.config.getPageSplitSize().get().intValue());
        }
        builder.fileName(this.mvstoreFile.getAbsolutePath());
        return builder.open();
    }

    private int initializeLibraryVersionsIdCurrentRun() {
        MVMap<String, String> mVMap = this.getMetaDataMVMap();
        int n = mVMap.containsKey((Object)METADATA_KEY_LIBRARY_VERSIONS_MAX_ID) ? Integer.parseInt((String)mVMap.get((Object)METADATA_KEY_LIBRARY_VERSIONS_MAX_ID)) + 1 : 0;
        mVMap.put((Object)METADATA_KEY_LIBRARY_VERSIONS_MAX_ID, (Object)("" + n));
        return n;
    }

    private Map<String, String> getIndexNameMap(MVStore mVStore) {
        return mVStore.getMapNames().stream().filter(string -> string.startsWith(INDEX_PREFIX)).collect(Collectors.toConcurrentMap(this::removeIndexPrefix, string -> string));
    }

    public Set<String> getIndexNames() {
        return this.getIndexNameMap(this.mvstore).keySet();
    }

    private String removeIndexPrefix(String string) {
        assert (string.startsWith(INDEX_PREFIX));
        return string.substring(INDEX_PREFIX.length());
    }

    public MVMap<Object, long[]> openIndex(String string) {
        String string2 = this.getIndexMapName(string);
        return this.mvstore.openMap(string2);
    }

    private String getIndexMapName(String string) {
        return INDEX_PREFIX + string;
    }

    public void clearIndices() {
        this.getIndexNames().forEach(this::clearIndex);
    }

    public void clearIndex(String string) {
        this.openIndex(string).clear();
    }

    public byte[] getSerializedNode(long l) {
        return (byte[])this.getNodesMVMap().get((Object)l);
    }

    private void persistOdbLibraryVersion() {
        Class<?> clazz = this.getClass();
        String string = clazz.getPackage().getImplementationVersion();
        if (string != null) {
            this.persistLibraryVersion(clazz.getCanonicalName(), string);
        }
    }

    public void persistLibraryVersion(String string, String string2) {
        String string3 = String.format("%s%d_%s", METADATA_PREFIX_LIBRARY_VERSIONS, this.libraryVersionsIdCurrentRun, string);
        this.getMetaDataMVMap().put((Object)string3, (Object)string2);
    }

    public ArrayList<Map<String, String>> getAllLibraryVersions() {
        HashMap hashMap = new HashMap();
        this.getMetaDataMVMap().forEach((string, string2) -> {
            if (string.startsWith(METADATA_PREFIX_LIBRARY_VERSIONS)) {
                String string3 = string.substring(METADATA_PREFIX_LIBRARY_VERSIONS.length());
                int n2 = string3.indexOf(95);
                int n3 = Integer.parseInt(string3.substring(0, n2));
                String string4 = string3.substring(n2 + 1);
                Map map2 = hashMap.computeIfAbsent(n3, n -> new HashMap());
                map2.put(string4, string2);
            }
        });
        return new ArrayList<Map<String, String>>(hashMap.values());
    }
}

