/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import overflowdb.Edge;
import overflowdb.Graph;
import overflowdb.Node;

public class DiffTool {
    public static List<String> compare(Graph graph, Graph graph2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (graph.nodeCount() != graph2.nodeCount()) {
            arrayList.add(String.format("node count differs: graph1=%d, graph2=%d", graph.nodeCount(), graph2.nodeCount()));
        }
        if (graph.edgeCount() != graph2.edgeCount()) {
            arrayList.add(String.format("edge count differs: graph1=%d, graph2=%d", graph.edgeCount(), graph2.edgeCount()));
        }
        TreeSet treeSet = new TreeSet();
        graph.nodes().forEachRemaining(node -> treeSet.add(node.id()));
        graph2.nodes().forEachRemaining(node -> treeSet.add(node.id()));
        treeSet.forEach(l -> {
            Node node = graph.node((long)l);
            Node node2 = graph2.node((long)l);
            if (node == null) {
                arrayList.add(String.format("node %s only exists in graph2", node2));
            } else if (node2 == null) {
                arrayList.add(String.format("node %s only exists in graph1", node));
            } else {
                if (!node.label().equals(node2.label())) {
                    arrayList.add(String.format("different label for nodeId=%d; graph1=%s, graph2=%s ", l, node.label(), node2.label()));
                }
                String string = "nodeId=" + l;
                DiffTool.compareProperties(node.propertiesMap(), node2.propertiesMap(), arrayList, string);
                DiffTool.compareEdges(node.outE(), node2.outE(), arrayList, string + ".outE");
            }
        });
        return arrayList;
    }

    private static void compareProperties(Map<String, Object> map, Map<String, Object> map2, List<String> list, String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(map.keySet());
        treeSet.addAll(map2.keySet());
        treeSet.forEach(string2 -> {
            Object v = map.get(string2);
            Object v2 = map2.get(string2);
            if (v == null) {
                list.add(String.format("%s; property '%s' -> '%s' only exists in graph2", string, string2, v2));
            } else if (v2 == null) {
                list.add(String.format("%s; property '%s' -> '%s' only exists in graph1", string, string2, v));
            } else if (v.getClass().isArray() && v2.getClass().isArray()) {
                if (!DiffTool.arraysEqual(v, v2)) {
                    list.add(String.format("%s; array property '%s' has different values: graph1='%s', graph2='%s'", string, string2, v, v2));
                }
            } else if (!v.equals(v2)) {
                list.add(String.format("%s; property '%s' has different values: graph1='%s', graph2='%s'", string, string2, v, v2));
            }
        });
    }

    public static boolean arraysEqual(Object object, Object object2) {
        boolean bl;
        Object object3 = object;
        Objects.requireNonNull(object3);
        Object object4 = object3;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object[].class, boolean[].class, byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object4, n)) {
                case 0: {
                    Object[] objectArray = (Object[])object4;
                    if (!(object2 instanceof Object[])) {
                        n = 1;
                        continue block11;
                    }
                    bl = Arrays.deepEquals(objectArray, (Object[])object2);
                    break block11;
                }
                case 1: {
                    boolean[] blArray = (boolean[])object4;
                    if (!(object2 instanceof int[])) {
                        n = 2;
                        continue block11;
                    }
                    bl = Arrays.equals(blArray, (boolean[])object2);
                    break block11;
                }
                case 2: {
                    byte[] byArray = (byte[])object4;
                    if (!(object2 instanceof byte[])) {
                        n = 3;
                        continue block11;
                    }
                    bl = Arrays.equals(byArray, (byte[])object2);
                    break block11;
                }
                case 3: {
                    char[] cArray = (char[])object4;
                    if (!(object2 instanceof char[])) {
                        n = 4;
                        continue block11;
                    }
                    bl = Arrays.equals(cArray, (char[])object2);
                    break block11;
                }
                case 4: {
                    short[] sArray = (short[])object4;
                    if (!(object2 instanceof short[])) {
                        n = 5;
                        continue block11;
                    }
                    bl = Arrays.equals(sArray, (short[])object2);
                    break block11;
                }
                case 5: {
                    int[] nArray = (int[])object4;
                    if (!(object2 instanceof int[])) {
                        n = 6;
                        continue block11;
                    }
                    bl = Arrays.equals(nArray, (int[])object2);
                    break block11;
                }
                case 6: {
                    long[] lArray = (long[])object4;
                    if (!(object2 instanceof long[])) {
                        n = 7;
                        continue block11;
                    }
                    bl = Arrays.equals(lArray, (long[])object2);
                    break block11;
                }
                case 7: {
                    float[] fArray = (float[])object4;
                    if (!(object2 instanceof float[])) {
                        n = 8;
                        continue block11;
                    }
                    bl = Arrays.equals(fArray, (float[])object2);
                    break block11;
                }
                case 8: {
                    double[] dArray = (double[])object4;
                    if (!(object2 instanceof double[])) {
                        n = 9;
                        continue block11;
                    }
                    bl = Arrays.equals(dArray, (double[])object2);
                    break block11;
                }
                default: {
                    throw new AssertionError((Object)String.format("unable to compare given objects (%s of type %s; %s of type %s)", object, object.getClass(), object2, object2.getClass()));
                }
            }
            break;
        }
        return bl;
    }

    private static void compareEdges(Iterator<Edge> iterator, Iterator<Edge> iterator2, List<String> list, String string) {
        List<Edge> list2 = DiffTool.sort(iterator);
        List<Edge> list3 = DiffTool.sort(iterator2);
        if (list2.size() != list3.size()) {
            list.add(String.format("%s; different number of edges: graph1=%d, graph2=%d", string, list2.size(), list3.size()));
        } else {
            Iterator<Edge> iterator3 = list2.iterator();
            Iterator<Edge> iterator4 = list3.iterator();
            while (iterator3.hasNext()) {
                Edge edge = iterator3.next();
                Edge edge2 = iterator4.next();
                if (!edge.label().equals(edge2.label())) {
                    list.add(String.format("%s; different label for sorted edges; graph1=%s, graph2=%s ", string, edge.label(), edge2.label()));
                    continue;
                }
                DiffTool.compareProperties(edge.propertiesMap(), edge2.propertiesMap(), list, String.format("%s; edge label = %s", string, edge.label()));
            }
        }
    }

    private static List<Edge> sort(Iterator<Edge> iterator) {
        LinkedList<Edge> linkedList = new LinkedList<Edge>();
        iterator.forEachRemaining(linkedList::add);
        linkedList.sort(Comparator.comparing(edge -> String.format("%s %d", edge.label(), edge.propertiesMap().size())));
        return linkedList;
    }
}

